/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.vmem;

import com.sun.jimi.core.vmem.IntPageFrame;
import com.sun.jimi.core.vmem.PageFrame;
import com.sun.jimi.core.vmem.PageMapper;
import com.sun.jimi.util.RandomAccessStorage;
import java.awt.Dimension;
import java.io.IOException;

public class IntPageMapper
extends PageMapper {
    protected static final int SIZEOF_INT = 4;
    protected IntPageFrame[] pageFrames;
    protected int width;
    protected int height;
    protected int pageWidth;
    protected int pageHeight;
    protected int widthInPages;
    protected int heightInPages;

    public IntPageMapper(RandomAccessStorage storage, Dimension logicalDimensions, int pageFrameMemory) {
        super(storage, logicalDimensions, pageFrameMemory);
        this.width = logicalDimensions.width;
        this.height = logicalDimensions.height;
        this.pageWidth = this.pageDimensions.width;
        this.pageHeight = this.pageDimensions.height;
        this.widthInPages = this.width % this.pageWidth == 0 ? this.width / this.pageWidth : this.width / this.pageWidth + 1;
        this.heightInPages = this.height % this.pageHeight == 0 ? this.height / this.pageHeight : this.height / this.pageHeight + 1;
        int pageSize = this.pageWidth * this.pageHeight;
        this.pageFrames = new IntPageFrame[this.numberOfPageFrames];
        for (int i = 0; i < this.pageFrames.length; ++i) {
            this.pageFrames[i] = new IntPageFrame(pageSize);
        }
    }

    public int getPixel(int x, int y) throws IOException {
        int pageNumber = this.getLogicalPageNumberForLocation(x, y);
        IntPageFrame pageFrame = (IntPageFrame)this.getPageFrameForReading(pageNumber);
        int[] pageData = pageFrame.getPageData();
        return pageData[x % this.pageWidth + y % this.pageHeight * this.pageWidth];
    }

    public void setPixel(int x, int y, int value) throws IOException {
        int pageNumber = this.getLogicalPageNumberForLocation(x, y);
        IntPageFrame pageFrame = (IntPageFrame)this.getPageFrameForWriting(pageNumber);
        int[] pageData = pageFrame.getPageData();
        pageData[x % this.pageWidth + y % this.pageHeight * this.pageWidth] = value;
    }

    public void getRectangle(int x, int y, int width, int height, int[] buffer, int offset, int scansize) throws IOException {
        int readHeight;
        int bufferOffset = offset;
        int yPosition = y;
        for (int yRemaining = height; yRemaining != 0; yRemaining -= readHeight) {
            int readWidth;
            int xPosition = x;
            readHeight = Math.min(this.pageHeight - yPosition % this.pageHeight, yRemaining);
            for (int xRemaining = width; xRemaining != 0; xRemaining -= readWidth) {
                int pageNumber = this.getLogicalPageNumberForLocation(xPosition, yPosition);
                IntPageFrame pageFrame = (IntPageFrame)this.getPageFrameForReading(pageNumber);
                readWidth = Math.min(this.pageWidth - xPosition % this.pageWidth, xRemaining);
                int[] pageData = pageFrame.getPageData();
                for (int row = 0; row < readHeight; ++row) {
                    System.arraycopy(pageData, xPosition % this.pageWidth + (yPosition % this.pageHeight + row) * this.pageWidth, buffer, bufferOffset + xPosition - x + (yPosition - y + row) * scansize, readWidth);
                }
                xPosition += readWidth;
            }
            yPosition += readHeight;
        }
    }

    public void setRectangle(int x, int y, int width, int height, int[] buffer, int offset, int scansize) throws IOException {
        int writeHeight;
        int bufferOffset = offset;
        int yPosition = y;
        for (int yRemaining = height; yRemaining != 0; yRemaining -= writeHeight) {
            int writeWidth;
            int xPosition = x;
            writeHeight = Math.min(this.pageHeight - yPosition % this.pageHeight, yRemaining);
            for (int xRemaining = width; xRemaining != 0; xRemaining -= writeWidth) {
                int pageNumber = this.getLogicalPageNumberForLocation(xPosition, yPosition);
                IntPageFrame pageFrame = (IntPageFrame)this.getPageFrameForWriting(pageNumber);
                writeWidth = Math.min(this.pageWidth - xPosition % this.pageWidth, xRemaining);
                int[] pageData = pageFrame.getPageData();
                for (int row = 0; row < writeHeight; ++row) {
                    System.arraycopy(buffer, bufferOffset + xPosition - x + (yPosition - y + row) * scansize, pageData, xPosition % this.pageWidth + (yPosition % this.pageHeight + row) * this.pageWidth, writeWidth);
                }
                xPosition += writeWidth;
            }
            yPosition += writeHeight;
        }
    }

    public void setChannelRectangle(int channel, int x, int y, int width, int height, byte[] buffer, int offset, int scansize) throws IOException {
        int writeHeight;
        int shift = channel;
        int mask = ~(255 << shift);
        int bufferOffset = offset;
        int yPosition = y;
        for (int yRemaining = height; yRemaining != 0; yRemaining -= writeHeight) {
            int writeWidth;
            int xPosition = x;
            writeHeight = Math.min(this.pageHeight - yPosition % this.pageHeight, yRemaining);
            int xPageIndex = xPosition % this.pageWidth;
            int yPageIndex = yPosition % this.pageWidth;
            for (int xRemaining = width; xRemaining != 0; xRemaining -= writeWidth) {
                int pageNumber = this.getLogicalPageNumberForLocation(xPosition, yPosition);
                IntPageFrame pageFrame = (IntPageFrame)this.getPageFrameForWriting(pageNumber);
                writeWidth = Math.min(this.pageWidth - xPosition % this.pageWidth, xRemaining);
                int[] pageData = pageFrame.getPageData();
                for (int row = 0; row < writeHeight; ++row) {
                    int pageDataIndex = xPosition % this.pageWidth + (yPosition % this.pageHeight + row) * this.pageWidth;
                    int bufferIndex = bufferOffset + xPosition - x + (yPosition - y + row) * scansize;
                    for (int column = 0; column < writeWidth; ++column) {
                        int n = pageDataIndex + column;
                        pageData[n] = pageData[n] & mask;
                        int n2 = pageDataIndex + column;
                        pageData[n2] = pageData[n2] | (0xFF000000 | (buffer[bufferIndex + column] & 0xFF) << shift);
                    }
                }
                xPosition += writeWidth;
            }
            yPosition += writeHeight;
        }
    }

    public int getLogicalPageNumberForLocation(int x, int y) {
        return x / this.pageWidth + y / this.pageHeight * this.widthInPages;
    }

    public int getPageSize() {
        return this.pageWidth * this.pageHeight * 4;
    }

    protected int getPixelSize() {
        return 4;
    }

    public PageFrame[] getPageFrames() {
        return this.pageFrames;
    }

    public Dimension getPageDimensions() {
        return new Dimension(this.pageWidth, this.pageHeight);
    }
}

