/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.vmem;

import com.sun.jimi.core.vmem.PageFrame;
import com.sun.jimi.util.RandomAccessStorage;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class PageMapper {
    protected RandomAccessStorage storage;
    protected Dimension logicalSize;
    protected int pageFrameMemory;
    protected int pageFaults = 0;
    protected OutputStream output;
    protected InputStream input;
    protected int numberOfPageFrames;
    protected Dimension pageDimensions;

    public PageMapper(RandomAccessStorage storage, Dimension logicalSize, int pageFrameMemory) {
        this.storage = storage;
        this.logicalSize = logicalSize;
        this.pageFrameMemory = pageFrameMemory;
        this.output = storage.asOutputStream();
        this.input = storage.asInputStream();
        this.configurePageFrames();
    }

    protected void configurePageFrames() {
        this.pageDimensions = new Dimension(this.logicalSize.width / 8, 200);
        this.numberOfPageFrames = 9;
    }

    public Dimension getLogicalSize() {
        return this.logicalSize;
    }

    public PageFrame getPageFrameForReading(int logicalPageNumber) throws IOException {
        return this.getPageFrame(logicalPageNumber);
    }

    public PageFrame getPageFrameForWriting(int logicalPageNumber) throws IOException {
        PageFrame pageFrame = this.getPageFrame(logicalPageNumber);
        pageFrame.setModified(true);
        return pageFrame;
    }

    public PageFrame getPageFrame(int logicalPageNumber) throws IOException {
        PageFrame[] pageFrames = this.getPageFrames();
        long oldestTime = Long.MAX_VALUE;
        int oldestIndex = 0;
        for (int pageIndex = 0; pageIndex < pageFrames.length; ++pageIndex) {
            if (pageFrames[pageIndex].getLogicalPageNumber() == logicalPageNumber) {
                pageFrames[pageIndex].touch();
                return pageFrames[pageIndex];
            }
            if (pageFrames[pageIndex].lastTouched() >= oldestTime) continue;
            oldestIndex = pageIndex;
            oldestTime = pageFrames[pageIndex].lastTouched();
        }
        ++this.pageFaults;
        PageFrame frame = pageFrames[oldestIndex];
        if (frame.isModified()) {
            this.commitPage(frame);
        }
        this.readPageIntoFrame(frame, logicalPageNumber);
        return frame;
    }

    public void commitPage(PageFrame pageFrame) throws IOException {
        int offset = this.getPageSize() * pageFrame.getLogicalPageNumber();
        this.storage.seek(offset);
        pageFrame.writeTo(this.output);
        this.output.flush();
        pageFrame.setModified(false);
    }

    public void readPageIntoFrame(PageFrame pageFrame, int logicalPageNumber) throws IOException {
        int offset = this.getPageSize() * logicalPageNumber;
        this.storage.seek(offset);
        try {
            pageFrame.readFrom(this.input);
        }
        catch (IOException e) {
            // empty catch block
        }
        pageFrame.setLogicalPageNumber(logicalPageNumber);
        pageFrame.setModified(false);
        pageFrame.touch();
    }

    public int howManyPageFaults() {
        return this.pageFaults;
    }

    public void resetPageFaultCount() {
        this.pageFaults = 0;
    }

    public abstract int getPageSize();

    public abstract PageFrame[] getPageFrames();

    protected abstract int getPixelSize();
}

