/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.util;

import java.io.IOException;
import java.io.InputStream;

public class ByteCountInputStream
extends InputStream {
    protected InputStream in;
    protected long count;

    public ByteCountInputStream(InputStream in) {
        this.in = in;
        this.count = 0L;
    }

    public long getCount() {
        return this.count;
    }

    public synchronized void resetCount() {
        this.count = 0L;
    }

    public int read() throws IOException {
        ++this.count;
        return this.in.read();
    }

    public int read(byte[] b) throws IOException {
        int retLen = this.read(b, 0, b.length);
        this.count += (long)retLen;
        return retLen;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int retLen = this.in.read(b, off, len);
        this.count += (long)retLen;
        return retLen;
    }

    public long skip(long n) throws IOException {
        long retLen = this.in.skip(n);
        this.count += retLen;
        return retLen;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }
}

