/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;

public class DataType {
    static final String[] extension = new String[]{"BMP", "DIB", "RLE", "GIF", "JPG", "JPE", "JPEG", "PIC", "PCT", "PICT", "PNG", "PSD", "TGA", "TIF", "TIFF", "RAS", "ICO", "CUR", "XBM", "BM", "XPM", "PM", "PCX", "DCX"};
    static final String[] typeID = new String[]{"image/x-bmp", "image/x-bmp", "image/x-bmp", "image/gif", "image/jpeg", "image/jpeg", "image/jpeg", "image/x-pict", "image/x-pict", "image/x-pict", "image/png", "image/x-psd", "image/x-tga", "image/tiff", "image/tiff", "image/x-cmu-raster", "image/x-ico", "image/x-cur", "image/x-xbitmap", "image/x-xbitmap", "image/x-xpixmap", "image/x-xpixmap", "image/x-pcx", "image/x-dcx"};
    public static int MAX_REWIND = 2500;
    private String client = "";
    private int version = -1;
    static Properties extMap = new Properties();

    public DataType(String client, int version) {
        this();
        this.client = client;
        this.version = version;
    }

    public DataType(String client) {
        this();
        this.client = client;
    }

    public DataType() {
    }

    public static void putMapping(String extension, String typeID) {
        ((Hashtable)extMap).put(extension, typeID);
    }

    protected static String getExtension(String str) {
        int lastDot = str.lastIndexOf(46);
        if (lastDot != -1 || lastDot == str.length()) {
            return str.substring(lastDot + 1);
        }
        return "";
    }

    public static String getIDe(String fileName) {
        return extMap.getProperty(DataType.getExtension(fileName).toUpperCase());
    }

    public static String getIDe(URL url) {
        return DataType.getIDe(url.getFile());
    }

    public static String getID(String fileName) throws IOException {
        return DataType.getIDe(fileName);
    }

    public static String getID(URL url) throws IOException {
        return DataType.getIDe(url.getFile());
    }

    public static String getID(InputStream is) throws IOException {
        throw new IOException("FileType getID() InputStream Identifying not finished");
    }

    static {
        for (int i = 0; i < extension.length; ++i) {
            DataType.putMapping(extension[i], typeID[i]);
        }
    }
}

