/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.util;

public class ExpandableArray {
    Object[] elementData_;
    int capacityIncrement_;
    protected int elementCount_ = 0;

    public ExpandableArray(int initialCapacity, int capacityIncrement) {
        this.elementData_ = new Object[initialCapacity];
        this.capacityIncrement_ = capacityIncrement;
    }

    public ExpandableArray(int initialCapacity) {
        this(initialCapacity, 5);
    }

    public ExpandableArray() {
        this(10, 5);
    }

    public int size() {
        return this.elementCount_;
    }

    public int addElement(Object o) {
        if (this.elementCount_ == this.elementData_.length) {
            Object[] oNew = new Object[this.elementCount_ + this.capacityIncrement_];
            System.arraycopy(this.elementData_, 0, oNew, 0, this.elementCount_);
            this.elementData_ = oNew;
        }
        this.elementData_[this.elementCount_++] = o;
        return this.elementCount_ - 1;
    }

    public Object elementAt(int i) {
        if (i >= this.elementCount_) {
            throw new ArrayIndexOutOfBoundsException(i + " >= " + this.elementCount_);
        }
        return this.elementData_[i];
    }

    public void removeElementAt(int i) {
        if (i >= this.elementCount_) {
            throw new ArrayIndexOutOfBoundsException(i + " >= " + this.elementCount_);
        }
        int numCopy = this.elementCount_ - i - 1;
        if (numCopy > 0) {
            System.arraycopy(this.elementData_, i + 1, this.elementData_, i, numCopy);
        }
        --this.elementCount_;
        this.elementData_[this.elementCount_] = null;
    }

    public Object lastElement() {
        return this.elementAt(this.elementCount_ - 1);
    }
}

