/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.util;

import com.sun.jimi.util.RandomAccessStorage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public final class FileRandomAccessStorage
extends RandomAccessFile
implements RandomAccessStorage {
    protected InputStream in = new InputStreamWrapper(this);
    protected OutputStream out = new OutputStreamWrapper(this);
    protected File file;

    public FileRandomAccessStorage(File file) throws IOException {
        super(file, "rw");
        this.file = file;
    }

    public OutputStream asOutputStream() {
        return this.out;
    }

    public InputStream asInputStream() {
        return this.in;
    }

    public void skip(int bytes) throws IOException {
        this.seek(this.getFilePointer() + (long)bytes);
    }

    public void seek(long pos) throws IOException {
        super.seek(pos);
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.file.delete();
    }

    protected final class InputStreamWrapper
    extends InputStream {
        protected FileRandomAccessStorage storage;
        private final /* synthetic */ FileRandomAccessStorage this$0;

        protected InputStreamWrapper(FileRandomAccessStorage fileRandomAccessStorage) {
            this.storage = this.this$0 = fileRandomAccessStorage;
        }

        public int read() throws IOException {
            return this.storage.read();
        }

        public int read(byte[] buffer) throws IOException {
            return this.storage.read(buffer);
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            return this.storage.read(buffer, offset, length);
        }
    }

    protected final class OutputStreamWrapper
    extends OutputStream {
        protected FileRandomAccessStorage storage;
        private final /* synthetic */ FileRandomAccessStorage this$0;

        protected OutputStreamWrapper(FileRandomAccessStorage fileRandomAccessStorage) {
            this.storage = this.this$0 = fileRandomAccessStorage;
        }

        public void write(int value) throws IOException {
            this.storage.write(value);
        }

        public void write(byte[] data) throws IOException {
            this.storage.write(data);
        }

        public void write(byte[] data, int offset, int length) throws IOException {
            this.storage.write(data, offset, length);
        }
    }
}

