/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class FullyBufferedInputStream
extends FilterInputStream {
    protected InputStream in;
    protected Vector buffers;
    protected int count;
    protected int pos;
    protected int bufSize;
    protected int markpos;
    protected static final int BUFSIZE = 8096;

    public FullyBufferedInputStream(InputStream in) {
        this(in, 8096);
    }

    public FullyBufferedInputStream(InputStream in, int bufSize) {
        super(in);
        this.in = in;
        this.bufSize = bufSize;
        this.buffers = new Vector();
        this.dropBuf();
    }

    public synchronized void dropBuf() {
        this.buffers.removeAllElements();
        this.count = 0;
        this.pos = 0;
        this.markpos = -1;
    }

    private void fillBuffer() throws IOException {
        int remainCount;
        int offsetCount;
        byte[] buf;
        int bytesRead;
        int countBIndex = this.count / this.bufSize;
        int numBuffers = this.buffers.size();
        if (countBIndex >= numBuffers) {
            this.buffers.addElement(new byte[this.bufSize]);
            numBuffers = this.buffers.size();
        }
        if ((bytesRead = this.in.read(buf = (byte[])this.buffers.lastElement(), offsetCount = this.count - (numBuffers - 1) * this.bufSize, remainCount = this.bufSize - offsetCount)) != -1) {
            this.count += bytesRead;
        }
    }

    public synchronized int read() throws IOException {
        if (this.pos >= this.count) {
            this.fillBuffer();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        int posBIndex = this.pos / this.bufSize;
        byte[] buf = (byte[])this.buffers.elementAt(posBIndex);
        int offsetPos = this.pos - posBIndex * this.bufSize;
        ++this.pos;
        return buf[offsetPos] & 0xFF;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int origLen = len;
        while (len > 0) {
            if (this.pos >= this.count) {
                this.fillBuffer();
            }
            if (this.pos >= this.count) {
                if (origLen == len) {
                    return -1;
                }
                return origLen - len;
            }
            int posBIndex = this.pos / this.bufSize;
            int countBIndex = this.count / this.bufSize;
            int numBuffers = this.buffers.size();
            byte[] buf = (byte[])this.buffers.elementAt(posBIndex);
            int offsetCount = 0;
            int offsetPos = this.pos - posBIndex * this.bufSize;
            int actualBufSize = this.bufSize;
            if (posBIndex == countBIndex) {
                actualBufSize = this.count - countBIndex * this.bufSize;
            }
            int remainPos = Math.min(actualBufSize - offsetPos, actualBufSize - offsetCount);
            int readLen = Math.min(remainPos, len);
            System.arraycopy(buf, offsetPos, b, off, readLen);
            this.pos += readLen;
            off += readLen;
            len -= readLen;
        }
        return origLen - len;
    }

    public synchronized long skip(long n) throws IOException {
        return -1L;
    }

    public synchronized void close() throws IOException {
        this.in.close();
    }

    public synchronized int available() throws IOException {
        return this.count - this.pos + this.in.available();
    }

    public synchronized void mark(int readlimit) {
        this.markpos = this.pos;
    }

    public synchronized void reset() throws IOException {
        if (this.markpos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.pos = this.markpos;
    }

    public boolean markSupported() {
        return true;
    }
}

