/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.util;

import com.sun.jimi.util.RandomAccessStorage;
import java.io.InputStream;
import java.io.OutputStream;

public class MemoryRandomAccessStorage
implements RandomAccessStorage {
    protected byte[] storage;
    protected int position;
    protected OutputStream out = new MemoryOutputStream(this);
    protected InputStream in = new MemoryInputStream(this);

    public MemoryRandomAccessStorage(int storageSize) {
        this.storage = new byte[storageSize];
        this.position = 0;
    }

    public synchronized void seek(long pos) {
        this.position = (int)pos;
    }

    public synchronized void skip(int bytes) {
        this.position += bytes;
    }

    public synchronized OutputStream asOutputStream() {
        return this.out;
    }

    public synchronized InputStream asInputStream() {
        return this.in;
    }

    protected class MemoryInputStream
    extends InputStream {
        protected MemoryRandomAccessStorage memStorage;
        private final /* synthetic */ MemoryRandomAccessStorage this$0;

        protected MemoryInputStream(MemoryRandomAccessStorage memoryRandomAccessStorage) {
            this.memStorage = this.this$0 = memoryRandomAccessStorage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() {
            MemoryRandomAccessStorage memoryRandomAccessStorage = this.memStorage;
            synchronized (memoryRandomAccessStorage) {
                byte value = this.memStorage.storage[this.memStorage.position];
                this.memStorage.skip(1);
                return value & 0xFF;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] buffer, int offset, int length) {
            MemoryRandomAccessStorage memoryRandomAccessStorage = this.memStorage;
            synchronized (memoryRandomAccessStorage) {
                System.arraycopy(this.memStorage.storage, this.memStorage.position, buffer, offset, length);
                this.memStorage.skip(length);
            }
            return length;
        }

        public int read(byte[] buffer) {
            return this.read(buffer, 0, buffer.length);
        }
    }

    protected class MemoryOutputStream
    extends OutputStream {
        protected MemoryRandomAccessStorage memStorage;
        private final /* synthetic */ MemoryRandomAccessStorage this$0;

        protected MemoryOutputStream(MemoryRandomAccessStorage memoryRandomAccessStorage) {
            this.memStorage = this.this$0 = memoryRandomAccessStorage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] data, int offset, int length) {
            MemoryRandomAccessStorage memoryRandomAccessStorage = this.memStorage;
            synchronized (memoryRandomAccessStorage) {
                System.arraycopy(data, offset, this.memStorage.storage, this.memStorage.position, length);
                this.memStorage.skip(length);
            }
        }

        public void write(byte[] data) {
            this.write(data, 0, data.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int value) {
            MemoryRandomAccessStorage memoryRandomAccessStorage = this.memStorage;
            synchronized (memoryRandomAccessStorage) {
                this.memStorage.storage[this.memStorage.position] = (byte)value;
                this.memStorage.skip(1);
            }
        }
    }
}

