/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.util.zip;

import com.sun.jimi.util.zip.DataFormatException;
import com.sun.jimi.util.zip.Inflater;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InflaterInputStream
extends FilterInputStream {
    protected Inflater inf;
    protected byte[] buf;
    protected int len;

    public InflaterInputStream(InputStream in, Inflater inf, int size) {
        super(in);
        this.inf = inf;
        this.buf = new byte[size];
    }

    public InflaterInputStream(InputStream in, Inflater inf) {
        this(in, inf, 512);
    }

    public InflaterInputStream(InputStream in) {
        this(in, new Inflater());
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        return this.read(b, 0, 1) == -1 ? -1 : b[0] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len <= 0) {
            return 0;
        }
        try {
            int n;
            while ((n = this.inf.inflate(b, off, len)) == 0) {
                if (this.inf.finished() || this.inf.needsDictionary()) {
                    return -1;
                }
                if (!this.inf.needsInput()) continue;
                this.fill();
            }
            return n;
        }
        catch (DataFormatException e) {
            String s = e.getMessage();
            throw new DataFormatException(s != null ? s : "Invalid ZLIB data format");
        }
    }

    public long skip(long n) throws IOException {
        long total;
        long len;
        byte[] b = new byte[512];
        for (total = 0L; total < n && (len = (long)this.read(b, 0, (len = n - total) < (long)b.length ? (int)len : b.length)) != -1L; total += len) {
        }
        return total;
    }

    protected void fill() throws IOException {
        this.len = this.in.read(this.buf, 0, this.buf.length);
        if (this.len == -1) {
            throw new EOFException("Unexpected end of ZLIB input stream");
        }
        this.inf.setInput(this.buf, 0, this.len);
    }
}

