/*
 * Decompiled with CFR 0.152.
 */
package netimager;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import netimager.Layers_Repository;

public class BrightnessContrast_Dialog
extends JDialog {
    JPanel contentPane = new JPanel();
    JSlider jSlider_Brightness = new JSlider(-255, 255, 0);
    JSlider jSlider_Contrast = new JSlider(0, 255, 0);
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JCheckBox jCheckBox_Preview = new JCheckBox();
    JButton jButton_Cancel = new JButton();
    JButton jButton_OK = new JButton();
    boolean OK;
    Layers_Repository LayersForChange;
    Layers_Repository SrcLayers;
    JPanel ImagePanel;
    int SelectedLayer;
    boolean Run = false;

    public BrightnessContrast_Dialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public BrightnessContrast_Dialog() {
        this((Frame)null, "", false);
    }

    void jbInit() throws Exception {
        this.contentPane.setLayout(null);
        this.jSlider_Brightness.setBounds(new Rectangle(13, 29, 255, 24));
        this.jSlider_Brightness.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                BrightnessContrast_Dialog.this.jSlider_Brightness_stateChanged(e);
            }
        });
        this.jSlider_Contrast.setBounds(new Rectangle(14, 83, 251, 24));
        this.jSlider_Contrast.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                BrightnessContrast_Dialog.this.jSlider_Contrast_stateChanged(e);
            }
        });
        this.jLabel1.setText("Brightness:");
        this.jLabel1.setBounds(new Rectangle(17, 7, 142, 17));
        this.jLabel2.setBounds(new Rectangle(16, 62, 142, 17));
        this.jLabel2.setText("Contrast:");
        this.jCheckBox_Preview.setSelected(true);
        this.jCheckBox_Preview.setText("Preview");
        this.jCheckBox_Preview.setBounds(new Rectangle(16, 130, 73, 25));
        this.jCheckBox_Preview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrightnessContrast_Dialog.this.jCheckBox_Preview_actionPerformed(e);
            }
        });
        this.jButton_Cancel.setText("Cancel");
        this.jButton_Cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrightnessContrast_Dialog.this.jButton_Cancel_actionPerformed(e);
            }
        });
        this.jButton_Cancel.setBounds(new Rectangle(182, 125, 86, 27));
        this.jButton_OK.setBounds(new Rectangle(94, 125, 79, 27));
        this.jButton_OK.setText("OK");
        this.jButton_OK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrightnessContrast_Dialog.this.jButton_OK_actionPerformed(e);
            }
        });
        this.contentPane.setMinimumSize(new Dimension(270, 170));
        this.contentPane.setPreferredSize(new Dimension(270, 170));
        this.getContentPane().add(this.contentPane);
        this.contentPane.add((Component)this.jSlider_Brightness, null);
        this.contentPane.add((Component)this.jSlider_Contrast, null);
        this.contentPane.add((Component)this.jLabel1, null);
        this.contentPane.add((Component)this.jLabel2, null);
        this.contentPane.add((Component)this.jCheckBox_Preview, null);
        this.contentPane.add((Component)this.jButton_Cancel, null);
        this.contentPane.add((Component)this.jButton_OK, null);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException exc) {
            System.err.println("Unsupported Look And Feel");
        }
        SwingUtilities.updateComponentTreeUI(this.contentPane);
    }

    public boolean ShowDialog(Layers_Repository Layers, int selectedLayer, JPanel imagePanel) {
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension screenSize = kit.getScreenSize();
        int screenWidth = screenSize.width;
        int screenHeight = screenSize.height;
        this.setLocation((screenWidth - this.getWidth()) / 2, (screenHeight - this.getHeight()) / 2);
        this.LayersForChange = Layers;
        try {
            ByteArrayOutputStream ByteStream = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(ByteStream);
            out.writeObject(Layers);
            out.close();
            byte[] buf = ByteStream.toByteArray();
            ByteStream.close();
            ByteArrayInputStream ByteStream1 = new ByteArrayInputStream(buf, 0, ByteStream.size());
            ObjectInputStream in = new ObjectInputStream(ByteStream1);
            this.SrcLayers = (Layers_Repository)in.readObject();
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
        this.ImagePanel = imagePanel;
        this.SelectedLayer = selectedLayer;
        this.OK = false;
        this.show();
        this.ImagePanel = null;
        this.LayersForChange = null;
        this.SrcLayers = null;
        return this.OK;
    }

    void jButton_Cancel_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    void jButton_OK_actionPerformed(ActionEvent e) {
        this.OK = true;
        this.setVisible(false);
    }

    void SetBrightnessContrast() {
        if (!this.Run) {
            this.Run = true;
            if (this.SelectedLayer >= 0) {
                BufferedImage displayImage = this.SrcLayers.Layers[this.SelectedLayer].LayersData;
                int shift_Brigntness = this.jSlider_Brightness.getValue();
                int shift_Contrast = this.jSlider_Contrast.getValue();
                Contrast con = new Contrast();
                Brightness Bright = new Brightness();
                this.LayersForChange.Layers[this.SelectedLayer].LayersData = this.LayersForChange.Layers[this.SelectedLayer].ImageToBufferedImage(con.filter(displayImage, 1.0 + (double)shift_Contrast / 255.0));
                this.LayersForChange.Layers[this.SelectedLayer].LayersData = this.LayersForChange.Layers[this.SelectedLayer].ImageToBufferedImage(Bright.filter(this.LayersForChange.Layers[this.SelectedLayer].LayersData, shift_Brigntness));
                if (this.jCheckBox_Preview.isSelected()) {
                    this.ImagePanel.repaint();
                }
            }
            this.Run = false;
        }
    }

    void jSlider_Brightness_stateChanged(ChangeEvent e) {
        this.SetBrightnessContrast();
    }

    void jSlider_Contrast_stateChanged(ChangeEvent e) {
        this.SetBrightnessContrast();
    }

    void jCheckBox_Preview_actionPerformed(ActionEvent e) {
        if (this.jCheckBox_Preview.isSelected()) {
            this.ImagePanel.paint(this.ImagePanel.getGraphics());
        }
    }

    public class Contrast
    extends RGBImageFilter {
        double gain = 1.2;

        public Image filter(Image in, double Gain) {
            this.gain = Gain;
            Canvas C = new Canvas();
            return C.createImage(new FilteredImageSource(in.getSource(), this));
        }

        private final int multclamp(int in, double factor) {
            return (in = (int)((double)in * factor)) > 255 ? 255 : in;
        }

        private final int cont(int in) {
            return in < 128 ? (int)((double)in / this.gain) : this.multclamp(in, this.gain);
        }

        public int filterRGB(int x, int y, int rgb) {
            int a = rgb >> 24 & 0xFF;
            int r = this.cont(rgb >> 16 & 0xFF);
            int g = this.cont(rgb >> 8 & 0xFF);
            int b = this.cont(rgb & 0xFF);
            return a << 24 | r << 16 | g << 8 | b;
        }
    }

    public class Brightness
    extends RGBImageFilter {
        int offset;

        public Image filter(Image in, int Offset) {
            this.offset = Offset;
            Canvas C = new Canvas();
            return C.createImage(new FilteredImageSource(in.getSource(), this));
        }

        public int filterRGB(int x, int y, int rgb) {
            int a = rgb >> 24 & 0xFF;
            int r = (rgb >> 16 & 0xFF) + this.offset;
            r = r > 255 ? 255 : r;
            r = r < 0 ? 0 : r;
            int g = (rgb >> 8 & 0xFF) + this.offset;
            g = g > 255 ? 255 : g;
            g = g < 0 ? 0 : g;
            int b = (rgb & 0xFF) + this.offset;
            b = b > 255 ? 255 : b;
            b = b < 0 ? 0 : b;
            return a << 24 | r << 16 | g << 8 | b;
        }
    }
}

