/*
 * Decompiled with CFR 0.152.
 */
package netimager;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import javax.swing.JComponent;
import netimager.Layer;

public class ColorSelection_Area
extends JComponent {
    public static final int COLOR_SELECTION = 1;
    public float ImageZoom;
    Layer SelectedLayer;
    int Tolerance;
    int[] Mask;
    int AreaWidth;
    int AreaHeight;
    Image Img;
    public float x = 0.0f;
    public float y = 0.0f;
    public float bx = 0.0f;
    public float by = 0.0f;
    Point[] Lines = new Point[10000];
    int LinesCount;
    public BufferedImage b_image;

    public ColorSelection_Area(Layer selectedLayer, int tolerance, float Scale) {
        this.ImageZoom = Scale;
        this.setOpaque(false);
        this.addMouseListener(new MouseHandler());
        int boundUpX = (int)((float)selectedLayer.LayersX * this.ImageZoom);
        int boundDX = (int)((float)selectedLayer.LayersY * this.ImageZoom);
        int boundX = (int)((float)selectedLayer.Width * this.ImageZoom);
        int boundY = (int)((float)selectedLayer.Height * this.ImageZoom);
        this.setBounds(boundUpX, boundDX, boundX + 1, boundY + 1);
        this.SelectedLayer = selectedLayer;
        this.Tolerance = tolerance;
        this.LinesCount = 0;
    }

    public void paintComponent(Graphics g) {
        Graphics2D G2 = (Graphics2D)g;
        if (this.Img != null) {
            G2.drawImage(this.Img, 0, 0, null);
        }
        int i = 0;
        while (i <= this.LinesCount - 1) {
            G2.setColor(Color.black);
            G2.drawLine((int)this.Lines[i].getX(), (int)this.Lines[i].getY(), (int)this.Lines[i].getX(), (int)this.Lines[i].getY());
            ++i;
        }
    }

    private void resize() {
        int Width = this.getWidth();
        int Height = this.getHeight();
        BufferedImage bi = new BufferedImage(Width, Height, 2);
        Graphics2D graphics = bi.createGraphics();
        graphics.drawImage((Image)this.SelectedLayer.LayersData, 0, 0, null);
        AffineTransform AffineTrans = new AffineTransform();
        AffineTrans.scale(this.ImageZoom, this.ImageZoom);
        this.b_image = new BufferedImage(Width, Height, 2);
        AffineTransformOp biop = new AffineTransformOp(AffineTrans, 2);
        biop.filter(bi, this.b_image);
    }

    public void createArea() {
        int boundUpX = (int)((float)this.SelectedLayer.LayersX * this.ImageZoom);
        int boundDX = (int)((float)this.SelectedLayer.LayersY * this.ImageZoom);
        int boundX = (int)((float)this.SelectedLayer.Width * this.ImageZoom);
        int boundY = (int)((float)this.SelectedLayer.Height * this.ImageZoom);
        this.setBounds(boundUpX, boundDX, boundX + 1, boundY + 1);
        this.bx = this.x * this.ImageZoom;
        this.by = this.y * this.ImageZoom;
        this.CreateMaskSelection((int)this.bx, (int)this.bx);
        this.CreateSelectionBorder();
        this.repaint();
    }

    private void CreateSelectionBorder() {
        int Width = this.getWidth();
        int Height = this.getHeight();
        this.LinesCount = 0;
        int i = 0;
        while (i <= Height - 1) {
            int j = 0;
            while (j <= Width - 1) {
                if (this.Mask[i * Width + j] == 1) {
                    if (i > 0 && this.Mask[(i - 1) * Width + j] != 1) {
                        this.Lines[this.LinesCount++] = new Point(j, i);
                    } else if (i < Height - 2 && this.Mask[(i + 1) * Width + j] != 1) {
                        this.Lines[this.LinesCount++] = new Point(j, i);
                    } else if (j < Width - 2 && this.Mask[i * Width + j + 1] != 1) {
                        this.Lines[this.LinesCount++] = new Point(j, i);
                    } else if (j > 0 && this.Mask[i * Width + j - 1] != 1) {
                        this.Lines[this.LinesCount++] = new Point(j, i);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void CreateMaskSelection(int StartX, int StartY) {
        int j;
        int i;
        int SelectionColor;
        int Width = this.getWidth();
        int Height = this.getHeight();
        this.Mask = new int[Width * Height];
        this.resize();
        try {
            PixelGrabber Grabber = new PixelGrabber(this.b_image, 0, 0, Width, Height, this.Mask, 0, Width);
            Grabber.grabPixels();
        }
        catch (InterruptedException ee) {
            ee.printStackTrace();
        }
        int StartColor = this.Mask[StartY * Width + StartX];
        this.Mask[StartY * Width + StartX] = SelectionColor = -255;
        boolean Processing = true;
        while (Processing) {
            Processing = false;
            i = 0;
            while (i <= Height - 1) {
                j = 0;
                while (j <= Width - 1) {
                    if (this.Mask[i * Width + j] == SelectionColor) {
                        if (i > 0 && this.Mask[(i - 1) * Width + j] == StartColor) {
                            this.Mask[(i - 1) * Width + j] = SelectionColor;
                            Processing = true;
                        }
                        if (i < Height - 2 && this.Mask[(i + 1) * Width + j] == StartColor) {
                            this.Mask[(i + 1) * Width + j] = SelectionColor;
                            Processing = true;
                        }
                        if (j < Width - 2 && this.Mask[i * Width + j + 1] == StartColor) {
                            this.Mask[i * Width + j + 1] = SelectionColor;
                            Processing = true;
                        }
                        if (j > 0 && this.Mask[i * Width + j - 1] == StartColor) {
                            this.Mask[i * Width + j - 1] = SelectionColor;
                            Processing = true;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        i = 0;
        while (i <= Height - 1) {
            j = 0;
            while (j <= Width - 1) {
                this.Mask[i * Width + j] = this.Mask[i * Width + j] == SelectionColor ? 1 : 0;
                ++j;
            }
            ++i;
        }
        Canvas C = new Canvas();
        this.Img = C.createImage(new MemoryImageSource(Width, Height, this.Mask, 0, Width));
    }

    public int[] getMask() {
        return this.Mask;
    }

    public int getAreaWidth() {
        return this.getWidth();
    }

    public int getAreaHeight() {
        return this.getHeight();
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mousePressed(MouseEvent event) {
            ColorSelection_Area.this.x = (float)event.getX() / ColorSelection_Area.this.ImageZoom;
            ColorSelection_Area.this.y = (float)event.getY() / ColorSelection_Area.this.ImageZoom;
            ColorSelection_Area.this.CreateMaskSelection(event.getX(), event.getY());
            ColorSelection_Area.this.CreateSelectionBorder();
            ColorSelection_Area.this.repaint();
        }
    }
}

