/*
 * Decompiled with CFR 0.152.
 */
package netimager;

import java.awt.Color;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyledDocument;
import netimager.Layer;
import netimager.Layers_Repository;
import netimager.Main_Panel;
import netimager.ScaledTextPane;

public class History {
    State[] States;
    int Index;
    int MaxIndex;
    int MaxRedoIndex;
    Main_Panel MainPanel;

    public History(int number, Main_Panel mainPanel, Layers_Repository Layers) {
        this.MainPanel = mainPanel;
        this.MaxIndex = number - 1;
        this.States = new State[number];
        this.Clear(Layers);
    }

    public void Reindex() {
        if (this.Index == this.MaxIndex) {
            this.Index = 0;
            this.States[1].NewLayers = this.Redo(this.States[0].NewLayers);
            this.States[1].OperationType = 1;
            this.Index = this.MaxIndex;
            int i = 1;
            while (i <= this.MaxIndex) {
                this.States[i - 1] = this.States[i];
                ++i;
            }
            this.States[this.MaxIndex] = new State();
            --this.Index;
            this.MaxRedoIndex = this.Index;
        }
    }

    public void addMoveLayer(int LayersIndex, Point NewPoint) {
        this.Reindex();
        ++this.Index;
        this.States[this.Index].OperationType = 2;
        this.States[this.Index].NewPoint = new Point(NewPoint);
        this.States[this.Index].LayersIndex = LayersIndex;
        this.MaxRedoIndex = this.Index;
    }

    public void addNewLayers(Layers_Repository NewLayers) {
        this.Reindex();
        ++this.Index;
        try {
            ByteArrayOutputStream ByteStream = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(ByteStream);
            out.writeObject(NewLayers);
            out.close();
            byte[] buf = ByteStream.toByteArray();
            ByteStream.close();
            ByteArrayInputStream ByteStream1 = new ByteArrayInputStream(buf, 0, ByteStream.size());
            ObjectInputStream in = new ObjectInputStream(ByteStream1);
            this.States[this.Index].NewLayers = (Layers_Repository)in.readObject();
            this.States[this.Index].OperationType = 1;
            this.MaxRedoIndex = this.Index;
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
    }

    public ScaledTextPane undoTextLayer(Layers_Repository Layers) {
        if (Layers.Layers[Layers.SelectedLayer].LayersType == 1 && Layers.Layers[Layers.SelectedLayer].scaledTextPane != null && Layers.SelectedLayer != -1) {
            StyledDocument doc = Layers.Layers[Layers.SelectedLayer].scaledTextPane.getStyledDocument();
            doc.setParagraphAttributes(1, Layers.Layers[Layers.SelectedLayer].scaledTextPane.getText().length(), this.States[this.Index].set, true);
            return Layers.Layers[Layers.SelectedLayer].scaledTextPane;
        }
        return null;
    }

    public void saveTextLayer(Layers_Repository Layers) {
        this.Reindex();
        ++this.Index;
        this.States[this.Index].NewLayers = Layers;
        this.States[this.Index].OperationType = 4;
        if (Layers.Layers[Layers.SelectedLayer].LayersType == 1 && Layers.Layers[Layers.SelectedLayer].scaledTextPane != null) {
            StyledDocument doc = Layers.Layers[Layers.SelectedLayer].scaledTextPane.getStyledDocument();
            AttributeSet save_style = doc.getParagraphElement(0).getAttributes().copyAttributes();
            this.States[this.Index].saveTextState(save_style);
            this.MaxRedoIndex = this.Index;
        }
    }

    public void saveShapeLayer(Layers_Repository Layers) {
        this.Reindex();
        ++this.Index;
        this.States[this.Index].NewLayers = Layers;
        this.States[this.Index].OperationType = 5;
        if (Layers.Layers[Layers.SelectedLayer].isShape()) {
            this.States[this.Index].saveShapeState(Layers.Layers[Layers.SelectedLayer]);
            this.MaxRedoIndex = this.Index;
        }
    }

    public Layers_Repository Undo(Layers_Repository Layers) {
        if (this.Index >= 1) {
            int UndoIndex;
            int i = UndoIndex = this.Index - 1;
            while (this.States[i].OperationType != 1 && this.States[i].OperationType != 5 && this.States[i].OperationType != 4 && this.States[i].OperationType != 6 && this.States[i].OperationType != 7) {
                --i;
            }
            this.Index = i - 1;
            int k = i;
            while (k <= UndoIndex) {
                Layers = this.Redo(Layers);
                ++k;
            }
        }
        Layers.addChangeSelectedLayerActionListener(this.MainPanel.ChangeSelectedLayerActionListener);
        return Layers;
    }

    public Layers_Repository Redo(Layers_Repository Layers) {
        if (this.Index < this.MaxRedoIndex) {
            ++this.Index;
            switch (this.States[this.Index].OperationType) {
                case 2: {
                    if (Layers.Layers[this.States[this.Index].LayersIndex] == null) break;
                    Layers.Layers[this.States[this.Index].LayersIndex].SetPoint(this.States[this.Index].NewPoint);
                    break;
                }
                case 1: {
                    try {
                        ByteArrayOutputStream ByteStream = new ByteArrayOutputStream();
                        ObjectOutputStream out = new ObjectOutputStream(ByteStream);
                        out.writeObject(this.States[this.Index].NewLayers);
                        out.close();
                        byte[] buf = ByteStream.toByteArray();
                        ByteStream.close();
                        ByteArrayInputStream ByteStream1 = new ByteArrayInputStream(buf, 0, ByteStream.size());
                        ObjectInputStream in = new ObjectInputStream(ByteStream1);
                        Layers = (Layers_Repository)in.readObject();
                    }
                    catch (Exception ioe) {
                        ioe.printStackTrace();
                    }
                    break;
                }
                case 4: {
                    if (Layers.SelectedLayer == -1) break;
                    Layers.Layers[this.States[this.Index].LayersIndex].scaledTextPane = this.undoTextLayer(Layers);
                    Layers.Layers[Layers.SelectedLayer].setScaleEditingText(false);
                    break;
                }
                case 5: {
                    if (Layers.SelectedLayer == -1) break;
                    Layers.Layers[Layers.SelectedLayer].LineType = this.States[this.Index].LineType;
                    Layers.Layers[Layers.SelectedLayer].LineWidth = this.States[this.Index].LineWidth;
                    Layers.Layers[Layers.SelectedLayer].LineColor = this.States[this.Index].LineColor;
                    Layers.Layers[Layers.SelectedLayer].FillColor = this.States[this.Index].FillColor;
                    Layers.Layers[Layers.SelectedLayer].CornerRadius = this.States[this.Index].CornerRadius;
                    Layers.Layers[Layers.SelectedLayer].DashType = this.States[this.Index].DashType;
                    Layers.Layers[Layers.SelectedLayer].FillShape = this.States[this.Index].FillShape;
                    Layers.Layers[Layers.SelectedLayer].AntiAliasing = this.States[this.Index].AntiAliasing;
                    Layers.Layers[Layers.SelectedLayer].ChangeShapeParam();
                    break;
                }
                case 6: {
                    if (Layers.SelectedLayer == -1) break;
                    Layers.MoveUp(Layers.SelectedLayer);
                    break;
                }
                case 7: {
                    if (Layers.SelectedLayer == -1) break;
                    Layers.MoveDown(Layers.SelectedLayer);
                }
            }
        }
        Layers.addChangeSelectedLayerActionListener(this.MainPanel.ChangeSelectedLayerActionListener);
        return Layers;
    }

    public void Clear(Layers_Repository Layers) {
        this.MaxRedoIndex = this.Index = -1;
        int i = 0;
        while (i <= this.MaxIndex) {
            this.States[i] = new State();
            ++i;
        }
        this.addNewLayers(Layers);
    }

    public void SaveMoveLayer(int operation, Layers_Repository Layers) {
        this.Reindex();
        ++this.Index;
        this.States[this.Index].NewLayers = Layers;
        this.States[this.Index].OperationType = operation;
        this.States[this.Index].SelectedLayer = Layers.SelectedLayer;
        this.MaxRedoIndex = this.Index;
    }

    public String printStates() {
        StringBuffer stb = new StringBuffer();
        int i = 0;
        while (i < this.States.length) {
            stb.append(this.States[i] + " ");
            ++i;
        }
        return stb.toString();
    }

    public class State {
        public static final int SAVE_ALL = 1;
        public static final int MOVE_LAYER = 2;
        public static final int CHANGE_IMAGE_SIZE = 3;
        public static final int SAVE_TEXTPARAM = 4;
        public static final int SAVE_SHAPEPARAM = 5;
        public static final int LAYER_DOWN = 6;
        public static final int LAYER_UP = 7;
        int OperationType = 0;
        Layers_Repository NewLayers;
        Layer OldLayer;
        Layer NewLayer;
        int NewImageWidth;
        int NewImageHeight;
        int SelectedLayer;
        StyledDocument doc = null;
        AttributeSet set = null;
        Point OldPoint;
        Point NewPoint;
        int LayersIndex;
        int LayersType = 0;
        int LineType;
        int LineWidth;
        Color LineColor;
        Color FillColor;
        int CornerRadius;
        int DashType;
        boolean FillShape;
        boolean EditingText = false;
        boolean AntiAliasing = true;
        boolean Enabled = true;

        public void saveTextState(AttributeSet set) {
            this.set = set;
        }

        public void saveShapeState(Layer layer) {
            this.LineType = layer.LineType;
            this.LineWidth = layer.LineWidth;
            this.LineColor = layer.LineColor;
            this.FillColor = layer.FillColor;
            this.CornerRadius = layer.CornerRadius;
            this.DashType = layer.DashType;
            this.FillShape = layer.FillShape;
            this.AntiAliasing = layer.AntiAliasing;
        }

        public String toString() {
            return String.valueOf(this.OperationType);
        }
    }
}

