/*
 * Decompiled with CFR 0.152.
 */
package netimager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import netimager.JNumberTextField;

public class ImgResize_Dialog
extends JDialog {
    int OldImageWidth;
    int OldImageHeight;
    int NewImageWidth;
    int NewImageHeight;
    int PreviewPosition = 0;
    boolean OK;
    boolean imageRadioStatus = true;
    boolean layerRadioStatus = false;
    JPanel contentPane = new JPanel();
    JNumberTextField jTextField_Width = new JNumberTextField();
    JNumberTextField jTextField_Height = new JNumberTextField();
    JComboBox jComboBox_Type = new JComboBox<String>(new String[]{"pixels", "Percentage"});
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JButton jButton_OK = new JButton();
    JCheckBox jCheckBox_ConstrainProportions = new JCheckBox();
    BorderLayout borderLayout1 = new BorderLayout();
    JComboBox jComboBox_InterpolationType = new JComboBox<String>(new String[]{"bilinear", "nearest neighbor"});
    JLabel jLabel4 = new JLabel();
    JButton jButton_Cancel = new JButton();
    boolean run = false;
    JLabel jLabel5 = new JLabel();
    JRadioButton jRadioButton_SelectedLayer = new JRadioButton();
    JRadioButton jRadioButton_AllLayers = new JRadioButton();

    public ImgResize_Dialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ImgResize_Dialog() {
        this((Frame)null, "", false);
    }

    void jbInit() throws Exception {
        this.contentPane.setLayout(null);
        this.contentPane.setMinimumSize(new Dimension(300, 300));
        this.contentPane.setPreferredSize(new Dimension(300, 300));
        this.contentPane.setSize(new Dimension(300, 300));
        this.jTextField_Width.setBounds(new Rectangle(98, 61, 73, 21));
        this.jTextField_Height.setBounds(new Rectangle(97, 97, 73, 21));
        this.jTextField_Height.getDocument().addDocumentListener(new SizeFieldListener());
        this.jTextField_Width.getDocument().addDocumentListener(new SizeFieldListener());
        this.jTextField_Width.setCharNumber(6);
        this.jTextField_Height.setCharNumber(6);
        this.jLabel2.setToolTipText("");
        this.jLabel2.setText("Width:");
        this.jLabel2.setBounds(new Rectangle(14, 64, 70, 17));
        this.jLabel3.setText("Height:");
        this.jLabel3.setBounds(new Rectangle(13, 100, 75, 17));
        this.jButton_OK.setBounds(new Rectangle(64, 229, 86, 27));
        this.jButton_OK.setText("OK");
        this.jButton_OK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImgResize_Dialog.this.jButton_OK_actionPerformed(e);
            }
        });
        this.jCheckBox_ConstrainProportions.setText("Constrain Proportions");
        this.jCheckBox_ConstrainProportions.setSelected(true);
        this.jCheckBox_ConstrainProportions.setBounds(new Rectangle(14, 130, 219, 25));
        this.jCheckBox_ConstrainProportions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImgResize_Dialog.this.jCheckBox_ConstrainProportions_actionPerformed(e);
            }
        });
        this.getContentPane().setLayout(this.borderLayout1);
        this.jComboBox_InterpolationType.setDoubleBuffered(true);
        this.jComboBox_InterpolationType.setBounds(new Rectangle(125, 169, 125, 21));
        this.jLabel4.setBounds(new Rectangle(14, 169, 120, 17));
        this.jLabel4.setText("Interpolation Type:");
        this.jLabel4.setToolTipText("");
        this.jButton_Cancel.setText("Cancel");
        this.jButton_Cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImgResize_Dialog.this.jButton_Cancel_actionPerformed(e);
            }
        });
        this.jButton_Cancel.setBounds(new Rectangle(161, 229, 86, 27));
        this.jComboBox_Type.setBounds(new Rectangle(98, 27, 125, 21));
        this.jComboBox_Type.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImgResize_Dialog.this.jComboBox_Type_actionPerformed(e);
            }
        });
        this.jLabel5.setBounds(new Rectangle(15, 28, 48, 17));
        this.jLabel5.setText("Units:");
        this.jLabel5.setToolTipText("");
        this.jRadioButton_SelectedLayer.setBounds(new Rectangle(124, 198, 103, 25));
        this.jRadioButton_SelectedLayer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImgResize_Dialog.this.jRadioButton_SelectedLayer_actionPerformed(e);
            }
        });
        this.jRadioButton_SelectedLayer.setSelected(true);
        this.jRadioButton_SelectedLayer.setText("Selected layer");
        this.jRadioButton_AllLayers.setBounds(new Rectangle(12, 197, 103, 25));
        this.jRadioButton_AllLayers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImgResize_Dialog.this.jRadioButton_AllLayers_actionPerformed(e);
            }
        });
        this.jRadioButton_AllLayers.setToolTipText("");
        this.jRadioButton_AllLayers.setText("Entire Image");
        this.contentPane.add((Component)this.jTextField_Width, null);
        this.contentPane.add((Component)this.jTextField_Height, null);
        this.contentPane.add((Component)this.jComboBox_Type, null);
        this.contentPane.add((Component)this.jLabel5, null);
        this.contentPane.add((Component)this.jComboBox_InterpolationType, null);
        this.contentPane.add((Component)this.jCheckBox_ConstrainProportions, null);
        this.contentPane.add((Component)this.jLabel4, null);
        this.contentPane.add((Component)this.jLabel3, null);
        this.contentPane.add((Component)this.jLabel2, null);
        this.contentPane.add((Component)this.jButton_Cancel, null);
        this.contentPane.add((Component)this.jButton_OK, null);
        this.contentPane.add((Component)this.jRadioButton_AllLayers, null);
        this.contentPane.add((Component)this.jRadioButton_SelectedLayer, null);
        this.getContentPane().add((Component)this.contentPane, "Center");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException exc) {
            System.err.println("Unsupported Look And Feel");
        }
        SwingUtilities.updateComponentTreeUI(this.contentPane);
    }

    public boolean ShowDialog(int ImageWidth, int ImageHeight) {
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension screenSize = kit.getScreenSize();
        int screenWidth = screenSize.width;
        int screenHeight = screenSize.height;
        this.setLocation((screenWidth - this.getWidth()) / 2, (screenHeight - this.getHeight()) / 2);
        this.PreviewPosition = 0;
        this.jComboBox_Type.setSelectedIndex(0);
        this.OldImageWidth = ImageWidth;
        this.OldImageHeight = ImageHeight;
        this.NewImageWidth = new Integer(ImageWidth);
        this.NewImageHeight = new Integer(ImageHeight);
        this.OK = false;
        this.jTextField_Width.setIntValue(ImageWidth);
        this.jTextField_Height.setIntValue(ImageHeight);
        this.jRadioButton_AllLayers.setSelected(this.imageRadioStatus);
        this.jRadioButton_SelectedLayer.setSelected(this.layerRadioStatus);
        this.show();
        return this.OK;
    }

    private void UpdateProportions() {
        if (!this.run && this.jCheckBox_ConstrainProportions.isSelected()) {
            this.run = true;
            switch (this.jComboBox_Type.getSelectedIndex()) {
                case 0: {
                    if (this.jTextField_Width.isFocusOwner()) {
                        this.NewImageWidth = this.jTextField_Width.getIntValue();
                        this.NewImageHeight = (int)((double)this.OldImageHeight * ((double)this.NewImageWidth / (double)this.OldImageWidth));
                        this.jTextField_Height.setIntValue(this.NewImageHeight);
                    }
                    if (!this.jTextField_Height.isFocusOwner()) break;
                    this.NewImageHeight = this.jTextField_Height.getIntValue();
                    this.NewImageWidth = (int)((double)this.OldImageWidth * ((double)this.NewImageHeight / (double)this.OldImageHeight));
                    this.jTextField_Width.setIntValue(this.NewImageWidth);
                    break;
                }
                case 1: {
                    if (this.jTextField_Width.isFocusOwner()) {
                        this.jTextField_Height.setIntValue(this.jTextField_Width.getIntValue());
                        break;
                    }
                    this.jTextField_Width.setIntValue(this.jTextField_Height.getIntValue());
                }
            }
            this.run = false;
        }
    }

    void jButton_OK_actionPerformed(ActionEvent e) {
        this.OK = true;
        this.setVisible(false);
    }

    void jButton_Cancel_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    void jRadioButton_SelectedLayer_actionPerformed(ActionEvent e) {
        if (this.jRadioButton_SelectedLayer.isSelected()) {
            this.jRadioButton_AllLayers.setSelected(false);
        } else {
            this.jRadioButton_AllLayers.setSelected(true);
        }
    }

    void jRadioButton_AllLayers_actionPerformed(ActionEvent e) {
        if (this.jRadioButton_AllLayers.isSelected()) {
            this.jRadioButton_SelectedLayer.setSelected(false);
        } else {
            this.jRadioButton_SelectedLayer.setSelected(true);
        }
    }

    void jComboBox_Type_actionPerformed(ActionEvent e) {
        if (this.jComboBox_Type.getSelectedIndex() == 0 && this.PreviewPosition == 1) {
            this.run = true;
            this.NewImageWidth = (int)((double)(this.OldImageWidth * this.jTextField_Width.getIntValue()) / 100.0);
            this.NewImageHeight = (int)((double)(this.OldImageHeight * this.jTextField_Height.getIntValue()) / 100.0);
            this.jTextField_Height.setIntValue(this.NewImageHeight);
            this.jTextField_Width.setIntValue(this.NewImageWidth);
            this.run = false;
        }
        if (this.jComboBox_Type.getSelectedIndex() == 1 && this.PreviewPosition == 0) {
            this.run = true;
            this.NewImageWidth = (int)((double)this.jTextField_Width.getIntValue() / (double)this.OldImageWidth * 100.0);
            this.NewImageHeight = (int)((double)this.jTextField_Height.getIntValue() / (double)this.OldImageHeight * 100.0);
            this.jTextField_Height.setIntValue(this.NewImageHeight);
            this.jTextField_Width.setIntValue(this.NewImageWidth);
            this.run = false;
        }
        this.PreviewPosition = this.jComboBox_Type.getSelectedIndex();
    }

    void jCheckBox_ConstrainProportions_actionPerformed(ActionEvent e) {
        if (this.jCheckBox_ConstrainProportions.isSelected()) {
            this.run = true;
            switch (this.jComboBox_Type.getSelectedIndex()) {
                case 0: {
                    this.NewImageWidth = this.jTextField_Width.getIntValue();
                    this.NewImageHeight = (int)((double)this.OldImageHeight * ((double)this.NewImageWidth / (double)this.OldImageWidth));
                    this.jTextField_Height.setIntValue(this.NewImageHeight);
                    break;
                }
                case 1: {
                    this.jTextField_Height.setIntValue(this.jTextField_Width.getIntValue());
                }
            }
            this.run = false;
        }
    }

    private class SizeFieldListener
    implements DocumentListener {
        private SizeFieldListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            try {
                ImgResize_Dialog.this.UpdateProportions();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void removeUpdate(DocumentEvent e) {
            try {
                ImgResize_Dialog.this.UpdateProportions();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void changedUpdate(DocumentEvent e) {
            try {
                ImgResize_Dialog.this.UpdateProportions();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

