/*
 * Decompiled with CFR 0.152.
 */
package netimager;

import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Vector;

public class IndexImage {
    /*
     * Unable to fully structure code
     */
    public static BufferedImage getIndexedImage(BufferedImage bi, int nColors) {
        block18: {
            block17: {
                w = bi.getWidth();
                h = bi.getHeight();
                colors = new Vector[4096];
                rgb = 0;
                i_w = 0;
                while (i_w < w) {
                    i_h = 0;
                    while (i_h < h) {
                        block16: {
                            rgb = bi.getRGB(i_w, i_h) & 0xFFFFFF;
                            idx = (rgb & 0xF00000) >>> 12 | (rgb & 61440) >>> 8 | (rgb & 240) >>> 4;
                            v = colors[idx];
                            if (v == null) {
                                v = new Vector<Counter>();
                                v.add(new Counter(rgb));
                                colors[idx] = v;
                            } else {
                                i = v.iterator();
                                while (i.hasNext()) {
                                    if (!((Counter)i.next()).add(rgb)) continue;
                                    break block16;
                                }
                                v.add(new Counter(rgb));
                            }
                        }
                        ++i_h;
                    }
                    ++i_w;
                }
                nCubes = 1;
                fCube = 0;
                cubes = new Cube[nColors];
                cubes[0] = new Cube(colors, w * h);
                break block17;
                while (++fCube != nCubes) lbl-1000:
                // 2 sources

                {
                    ** while (!cubes[fCube].isDone())
lbl36:
                    // 1 sources

                }
lbl37:
                // 2 sources

                if (fCube == nCubes) break block18;
                c = cubes[fCube];
                nc = c.split();
                if (nc != null) {
                    if (nc.count > c.count) {
                        tmp = c;
                        c = nc;
                        nc = tmp;
                    }
                    j = fCube;
                    cnt = c.count;
                    i = fCube + 1;
                    while (i < nCubes) {
                        if (cubes[i].count < cnt) break;
                        cubes[j++] = cubes[i];
                        ++i;
                    }
                    cubes[j++] = c;
                    cnt = nc.count;
                    while (j < nCubes) {
                        if (cubes[j].count < cnt) break;
                        ++j;
                    }
                    i = nCubes;
                    while (i > j) {
                        cubes[i] = cubes[i - 1];
                        --i;
                    }
                    cubes[j++] = nc;
                    ++nCubes;
                }
            }
            if (nCubes < nColors) ** GOTO lbl-1000
        }
        r = new byte[nCubes];
        g = new byte[nCubes];
        b = new byte[nCubes];
        i = 0;
        while (i < nCubes) {
            val = cubes[i].averageColor();
            r[i] = (byte)(val >> 16 & 255);
            g[i] = (byte)(val >> 8 & 255);
            b[i] = (byte)(val & 255);
            ++i;
        }
        icm = new IndexColorModel(8, nCubes, r, g, b);
        indexed = new BufferedImage(w, h, 13, icm);
        g2d = indexed.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.drawImage((Image)bi, 0, 0, null);
        g2d.dispose();
        bits = 1;
        while (bits <= 8) {
            if (1 << bits >= nCubes) break;
            ++bits;
        }
        if (bits > 4) {
            return indexed;
        }
        if (bits == 3) {
            bits = 4;
        }
        cm = new IndexColorModel(bits, nCubes, r, g, b);
        sm = new MultiPixelPackedSampleModel(0, w, h, bits);
        ras = Raster.createWritableRaster(sm, new Point(0, 0));
        bi = indexed;
        indexed = new BufferedImage(cm, ras, bi.isAlphaPremultiplied(), null);
        IndexImage.copyData(bi, indexed);
        return indexed;
    }

    public static void copyData(Raster src, WritableRaster dst) {
        if (IndexImage.is_INT_PACK_Data(src.getSampleModel(), false) && IndexImage.is_INT_PACK_Data(dst.getSampleModel(), false)) {
            IndexImage.copyData_INT_PACK(src, dst);
            return;
        }
        IndexImage.copyData_FALLBACK(src, dst);
    }

    public static boolean is_INT_PACK_Data(SampleModel sm, boolean requireAlpha) {
        if (!(sm instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        if (sm.getDataType() != 3) {
            return false;
        }
        SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)sm;
        int[] masks = sppsm.getBitMasks();
        if (masks.length == 3 ? requireAlpha : masks.length != 4) {
            return false;
        }
        if (masks[0] != 0xFF0000) {
            return false;
        }
        if (masks[1] != 65280) {
            return false;
        }
        if (masks[2] != 255) {
            return false;
        }
        return masks.length != 4 || masks[3] == -16777216;
    }

    public static void copyData_INT_PACK(Raster src, WritableRaster dst) {
        int y1;
        int x1;
        int y0;
        int x0 = dst.getMinX();
        if (x0 < src.getMinX()) {
            x0 = src.getMinX();
        }
        if ((y0 = dst.getMinY()) < src.getMinY()) {
            y0 = src.getMinY();
        }
        if ((x1 = dst.getMinX() + dst.getWidth() - 1) > src.getMinX() + src.getWidth() - 1) {
            x1 = src.getMinX() + src.getWidth() - 1;
        }
        if ((y1 = dst.getMinY() + dst.getHeight() - 1) > src.getMinY() + src.getHeight() - 1) {
            y1 = src.getMinY() + src.getHeight() - 1;
        }
        int width = x1 - x0 + 1;
        int height = y1 - y0 + 1;
        SinglePixelPackedSampleModel srcSPPSM = (SinglePixelPackedSampleModel)src.getSampleModel();
        int srcScanStride = srcSPPSM.getScanlineStride();
        DataBufferInt srcDB = (DataBufferInt)src.getDataBuffer();
        int[] srcPixels = srcDB.getBankData()[0];
        int srcBase = srcDB.getOffset() + srcSPPSM.getOffset(x0 - src.getSampleModelTranslateX(), y0 - src.getSampleModelTranslateY());
        SinglePixelPackedSampleModel dstSPPSM = (SinglePixelPackedSampleModel)dst.getSampleModel();
        int dstScanStride = dstSPPSM.getScanlineStride();
        DataBufferInt dstDB = (DataBufferInt)dst.getDataBuffer();
        int[] dstPixels = dstDB.getBankData()[0];
        int dstBase = dstDB.getOffset() + dstSPPSM.getOffset(x0 - dst.getSampleModelTranslateX(), y0 - dst.getSampleModelTranslateY());
        if (srcScanStride == dstScanStride && srcScanStride == width) {
            System.arraycopy(srcPixels, srcBase, dstPixels, dstBase, width * height);
        } else if (width > 128) {
            int srcSP = srcBase;
            int dstSP = dstBase;
            int y = 0;
            while (y < height) {
                System.arraycopy(srcPixels, srcSP, dstPixels, dstSP, width);
                srcSP += srcScanStride;
                dstSP += dstScanStride;
                ++y;
            }
        } else {
            int y = 0;
            while (y < height) {
                int srcSP = srcBase + y * srcScanStride;
                int dstSP = dstBase + y * dstScanStride;
                int x = 0;
                while (x < width) {
                    dstPixels[dstSP++] = srcPixels[srcSP++];
                    ++x;
                }
                ++y;
            }
        }
    }

    public static void copyData_FALLBACK(Raster src, WritableRaster dst) {
        int y1;
        int x1;
        int y0;
        int x0 = dst.getMinX();
        if (x0 < src.getMinX()) {
            x0 = src.getMinX();
        }
        if ((y0 = dst.getMinY()) < src.getMinY()) {
            y0 = src.getMinY();
        }
        if ((x1 = dst.getMinX() + dst.getWidth() - 1) > src.getMinX() + src.getWidth() - 1) {
            x1 = src.getMinX() + src.getWidth() - 1;
        }
        if ((y1 = dst.getMinY() + dst.getHeight() - 1) > src.getMinY() + src.getHeight() - 1) {
            y1 = src.getMinY() + src.getHeight() - 1;
        }
        int width = x1 - x0 + 1;
        int[] data = null;
        int y = y0;
        while (y <= y1) {
            data = src.getPixels(x0, y, width, 1, data);
            dst.setPixels(x0, y, width, 1, data);
            ++y;
        }
    }

    public static void copyData(BufferedImage src, BufferedImage dst) {
        Rectangle srcRect = new Rectangle(0, 0, src.getWidth(), src.getHeight());
        IndexImage.copyData(src, srcRect, dst, new Point(0, 0));
    }

    public static void copyData(BufferedImage src, Rectangle srcRect, BufferedImage dst, Point destP) {
        boolean dstAlpha;
        boolean srcAlpha = src.getColorModel().hasAlpha();
        if (!(srcAlpha != (dstAlpha = dst.getColorModel().hasAlpha()) || srcAlpha && src.isAlphaPremultiplied() != dst.isAlphaPremultiplied())) {
            IndexImage.copyData(src.getRaster(), dst.getRaster());
            return;
        }
        int[] pixel = null;
        WritableRaster srcR = src.getRaster();
        WritableRaster dstR = dst.getRaster();
        int bands = dstR.getNumBands();
        int dx = destP.x - srcRect.x;
        int dy = destP.y - srcRect.y;
        int w = srcRect.width;
        int x0 = srcRect.x;
        int y0 = srcRect.y;
        int y1 = y0 + srcRect.height - 1;
        if (!srcAlpha) {
            int[] oPix = new int[bands * w];
            int out = w * bands - 1;
            while (out >= 0) {
                oPix[out] = 255;
                out -= bands;
            }
            int y = y0;
            while (y <= y1) {
                pixel = srcR.getPixels(x0, y, w, 1, pixel);
                int in = w * (bands - 1) - 1;
                out = w * bands - 2;
                switch (bands) {
                    case 4: {
                        while (in >= 0) {
                            oPix[out--] = pixel[in--];
                            oPix[out--] = pixel[in--];
                            oPix[out--] = pixel[in--];
                            --out;
                        }
                        break;
                    }
                    default: {
                        while (in >= 0) {
                            int b = 0;
                            while (b < bands - 1) {
                                oPix[out--] = pixel[in--];
                                ++b;
                            }
                            --out;
                        }
                        break block0;
                    }
                }
                dstR.setPixels(x0 + dx, y + dy, w, 1, oPix);
                ++y;
            }
        } else if (dstAlpha && dst.isAlphaPremultiplied()) {
            int fpNorm = 65793;
            int pt5 = 0x800000;
            int y = y0;
            while (y <= y1) {
                pixel = srcR.getPixels(x0, y, w, 1, pixel);
                int in = bands * w - 1;
                switch (bands) {
                    case 4: {
                        int alpha;
                        int a;
                        while (in >= 0) {
                            a = pixel[in];
                            if (a == 255) {
                                in -= 4;
                                continue;
                            }
                            alpha = fpNorm * a;
                            pixel[--in] = pixel[in] * alpha + pt5 >>> 24;
                            pixel[--in] = pixel[in] * alpha + pt5 >>> 24;
                            pixel[--in] = pixel[in] * alpha + pt5 >>> 24;
                            --in;
                        }
                        break;
                    }
                    default: {
                        int alpha;
                        int a;
                        while (in >= 0) {
                            a = pixel[in];
                            if (a == 255) {
                                in -= bands;
                                continue;
                            }
                            --in;
                            alpha = fpNorm * a;
                            int b = 0;
                            while (b < bands - 1) {
                                pixel[in] = pixel[in] * alpha + pt5 >>> 24;
                                --in;
                                ++b;
                            }
                        }
                        break block3;
                    }
                }
                dstR.setPixels(x0 + dx, y + dy, w, 1, pixel);
                ++y;
            }
        } else if (dstAlpha && !dst.isAlphaPremultiplied()) {
            int fpNorm = 0xFF0000;
            int pt5 = 32768;
            int y = y0;
            while (y <= y1) {
                pixel = srcR.getPixels(x0, y, w, 1, pixel);
                int in = bands * w - 1;
                switch (bands) {
                    case 4: {
                        int ialpha;
                        int a;
                        while (in >= 0) {
                            a = pixel[in];
                            if (a <= 0 || a >= 255) {
                                in -= 4;
                                continue;
                            }
                            ialpha = fpNorm / a;
                            pixel[--in] = pixel[in] * ialpha + pt5 >>> 16;
                            pixel[--in] = pixel[in] * ialpha + pt5 >>> 16;
                            pixel[--in] = pixel[in] * ialpha + pt5 >>> 16;
                            --in;
                        }
                        break;
                    }
                    default: {
                        int ialpha;
                        int a;
                        while (in >= 0) {
                            a = pixel[in];
                            if (a <= 0 || a >= 255) {
                                in -= bands;
                                continue;
                            }
                            --in;
                            ialpha = fpNorm / a;
                            int b = 0;
                            while (b < bands - 1) {
                                pixel[in] = pixel[in] * ialpha + pt5 >>> 16;
                                --in;
                                ++b;
                            }
                        }
                        break block6;
                    }
                }
                dstR.setPixels(x0 + dx, y + dy, w, 1, pixel);
                ++y;
            }
        } else if (src.isAlphaPremultiplied()) {
            int[] oPix = new int[bands * w];
            int fpNorm = 0xFF0000;
            int pt5 = 32768;
            int y = y0;
            while (y <= y1) {
                pixel = srcR.getPixels(x0, y, w, 1, pixel);
                int in = (bands + 1) * w - 1;
                int out = bands * w - 1;
                while (in >= 0) {
                    int b;
                    int a = pixel[in];
                    --in;
                    if (a > 0) {
                        if (a < 255) {
                            int ialpha = fpNorm / a;
                            b = 0;
                            while (b < bands) {
                                oPix[out--] = pixel[in--] * ialpha + pt5 >>> 16;
                                ++b;
                            }
                            continue;
                        }
                        b = 0;
                        while (b < bands) {
                            oPix[out--] = pixel[in--];
                            ++b;
                        }
                        continue;
                    }
                    in -= bands;
                    b = 0;
                    while (b < bands) {
                        oPix[out--] = 255;
                        ++b;
                    }
                }
                dstR.setPixels(x0 + dx, y + dy, w, 1, oPix);
                ++y;
            }
        } else {
            Rectangle dstRect = new Rectangle(destP.x, destP.y, srcRect.width, srcRect.height);
            int b = 0;
            while (b < bands) {
                IndexImage.copyBand(srcR, srcRect, b, dstR, dstRect, b);
                ++b;
            }
        }
    }

    public static void copyBand(Raster src, Rectangle sR, int sBand, WritableRaster dst, Rectangle dR, int dBand) {
        int dy = dR.y - sR.y;
        int dx = dR.x - sR.x;
        sR = sR.intersection(src.getBounds());
        dR = dR.intersection(dst.getBounds());
        int width = dR.width < sR.width ? dR.width : sR.width;
        int height = dR.height < sR.height ? dR.height : sR.height;
        int x = sR.x + dx;
        int[] samples = null;
        int y = sR.y;
        while (y < sR.y + height) {
            samples = src.getSamples(sR.x, y, width, 1, sBand, samples);
            dst.setSamples(x, y + dy, width, 1, dBand, samples);
            ++y;
        }
    }

    private static class Counter {
        public int val;
        public int count = 1;

        public Counter(int val) {
            this.val = val;
        }

        public boolean add(int val) {
            if (this.val != val) {
                return false;
            }
            ++this.count;
            return true;
        }
    }

    private static class Cube {
        int[] min = new int[3];
        int[] max = new int[]{255, 255, 255};
        boolean done = false;
        Vector[] colors = null;
        int count = 0;
        static final int RED = 0;
        static final int GRN = 1;
        static final int BLU = 2;

        public Cube(Vector[] colors, int count) {
            this.colors = colors;
            this.count = count;
        }

        public boolean isDone() {
            return this.done;
        }

        public Cube split() {
            int c1;
            int splitChannel;
            int c0;
            int dr = this.max[0] - this.min[0] + 1;
            int dg = this.max[1] - this.min[1] + 1;
            int db = this.max[2] - this.min[2] + 1;
            if (dr >= dg) {
                c0 = 1;
                if (dr >= db) {
                    splitChannel = 0;
                    c1 = 2;
                } else {
                    splitChannel = 2;
                    c1 = 0;
                }
            } else if (dg >= db) {
                splitChannel = 1;
                c0 = 0;
                c1 = 2;
            } else {
                splitChannel = 2;
                c0 = 0;
                c1 = 1;
            }
            Cube ret = this.splitChannel(splitChannel, c0, c1);
            if (ret != null) {
                return ret;
            }
            ret = this.splitChannel(c0, splitChannel, c1);
            if (ret != null) {
                return ret;
            }
            ret = this.splitChannel(c1, splitChannel, c0);
            if (ret != null) {
                return ret;
            }
            this.done = true;
            return null;
        }

        public Cube splitChannel(int splitChannel, int c0, int c1) {
            if (this.min[splitChannel] == this.max[splitChannel]) {
                return null;
            }
            int splitSh4 = (2 - splitChannel) * 4;
            int c0Sh4 = (2 - c0) * 4;
            int c1Sh4 = (2 - c1) * 4;
            int half = this.count / 2;
            int[] counts = new int[256];
            int tcount = 0;
            int[] minIdx = new int[]{this.min[0] >> 4, this.min[1] >> 4, this.min[2] >> 4};
            int[] maxIdx = new int[]{this.max[0] >> 4, this.max[1] >> 4, this.max[2] >> 4};
            int minR = this.min[0];
            int minG = this.min[1];
            int minB = this.min[2];
            int maxR = this.max[0];
            int maxG = this.max[1];
            int maxB = this.max[2];
            int val = 0;
            int[] vals = new int[3];
            int i = minIdx[splitChannel];
            while (i <= maxIdx[splitChannel]) {
                int idx1 = i << splitSh4;
                int j = minIdx[c0];
                while (j <= maxIdx[c0]) {
                    int idx2 = idx1 | j << c0Sh4;
                    int k = minIdx[c1];
                    while (k <= maxIdx[c1]) {
                        int idx = idx2 | k << c1Sh4;
                        Vector v = this.colors[idx];
                        if (v != null) {
                            for (Counter c : v) {
                                val = c.val;
                                vals[0] = (val & 0xFF0000) >> 16;
                                vals[1] = (val & 0xFF00) >> 8;
                                vals[2] = val & 0xFF;
                                if (vals[0] < minR || vals[0] > maxR || vals[1] < minG || vals[1] > maxG || vals[2] < minB || vals[2] > maxB) continue;
                                int n = vals[splitChannel];
                                counts[n] = counts[n] + c.count;
                                tcount += c.count;
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                if (tcount >= half) break;
                ++i;
            }
            tcount = 0;
            int lastAdd = -1;
            int splitLo = this.min[splitChannel];
            int splitHi = this.max[splitChannel];
            int i2 = this.min[splitChannel];
            while (i2 <= this.max[splitChannel]) {
                int c = counts[i2];
                if (c == 0) {
                    if (tcount == 0 && i2 < this.max[splitChannel]) {
                        this.min[splitChannel] = i2 + 1;
                    }
                } else if (tcount + c < half) {
                    lastAdd = i2;
                    tcount += c;
                } else {
                    if (half - tcount <= tcount + c - half) {
                        if (lastAdd == -1) {
                            if (c == this.count) {
                                this.max[splitChannel] = i2;
                                return null;
                            }
                            splitLo = i2;
                            splitHi = i2 + 1;
                            break;
                        }
                        splitLo = lastAdd;
                        splitHi = i2;
                        break;
                    }
                    if (i2 == this.max[splitChannel]) {
                        if (c == this.count) {
                            return null;
                        }
                        splitLo = lastAdd;
                        splitHi = i2;
                        break;
                    }
                    tcount += c;
                    splitLo = i2;
                    splitHi = i2 + 1;
                    break;
                }
                ++i2;
            }
            Cube ret = new Cube(this.colors, tcount);
            this.count -= tcount;
            ret.min[splitChannel] = this.min[splitChannel];
            ret.max[splitChannel] = splitLo;
            this.min[splitChannel] = splitHi;
            ret.min[c0] = this.min[c0];
            ret.max[c0] = this.max[c0];
            ret.min[c1] = this.min[c1];
            ret.max[c1] = this.max[c1];
            return ret;
        }

        public int averageColor() {
            if (this.count == 0) {
                return 0;
            }
            float red = 0.0f;
            float grn = 0.0f;
            float blu = 0.0f;
            int minR = this.min[0];
            int minG = this.min[1];
            int minB = this.min[2];
            int maxR = this.max[0];
            int maxG = this.max[1];
            int maxB = this.max[2];
            int[] minIdx = new int[]{minR >> 4, minG >> 4, minB >> 4};
            int[] maxIdx = new int[]{maxR >> 4, maxG >> 4, maxB >> 4};
            int i = minIdx[0];
            while (i <= maxIdx[0]) {
                int idx1 = i << 8;
                int j = minIdx[1];
                while (j <= maxIdx[1]) {
                    int idx2 = idx1 | j << 4;
                    int k = minIdx[2];
                    while (k <= maxIdx[2]) {
                        int idx = idx2 | k;
                        Vector v = this.colors[idx];
                        if (v != null) {
                            for (Counter c : v) {
                                int val = c.val;
                                int ired = (val & 0xFF0000) >> 16;
                                int igrn = (val & 0xFF00) >> 8;
                                int iblu = val & 0xFF;
                                if (ired < minR || ired > maxR || igrn < minG || igrn > maxG || iblu < minB || iblu > maxB) continue;
                                float weight = (float)c.count / (float)this.count;
                                red += (float)ired * weight;
                                grn += (float)igrn * weight;
                                blu += (float)iblu * weight;
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            return (int)((double)red + 0.5) << 16 | (int)((double)grn + 0.5) << 8 | (int)((double)blu + 0.5);
        }
    }
}

