/*
 * Decompiled with CFR 0.152.
 */
package netimager;

import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import netimager.DCT;
import netimager.Huffman;
import netimager.JpegInfo;

public class JpegEncoder
extends Frame {
    Thread runner;
    BufferedOutputStream outStream;
    Image image;
    JpegInfo JpegObj;
    Huffman Huf;
    DCT dct;
    int imageHeight;
    int imageWidth;
    int Quality;
    int code;
    public static int[] jpegNaturalOrder;

    static {
        int[] nArray = new int[64];
        nArray[1] = 1;
        nArray[2] = 8;
        nArray[3] = 16;
        nArray[4] = 9;
        nArray[5] = 2;
        nArray[6] = 3;
        nArray[7] = 10;
        nArray[8] = 17;
        nArray[9] = 24;
        nArray[10] = 32;
        nArray[11] = 25;
        nArray[12] = 18;
        nArray[13] = 11;
        nArray[14] = 4;
        nArray[15] = 5;
        nArray[16] = 12;
        nArray[17] = 19;
        nArray[18] = 26;
        nArray[19] = 33;
        nArray[20] = 40;
        nArray[21] = 48;
        nArray[22] = 41;
        nArray[23] = 34;
        nArray[24] = 27;
        nArray[25] = 20;
        nArray[26] = 13;
        nArray[27] = 6;
        nArray[28] = 7;
        nArray[29] = 14;
        nArray[30] = 21;
        nArray[31] = 28;
        nArray[32] = 35;
        nArray[33] = 42;
        nArray[34] = 49;
        nArray[35] = 56;
        nArray[36] = 57;
        nArray[37] = 50;
        nArray[38] = 43;
        nArray[39] = 36;
        nArray[40] = 29;
        nArray[41] = 22;
        nArray[42] = 15;
        nArray[43] = 23;
        nArray[44] = 30;
        nArray[45] = 37;
        nArray[46] = 44;
        nArray[47] = 51;
        nArray[48] = 58;
        nArray[49] = 59;
        nArray[50] = 52;
        nArray[51] = 45;
        nArray[52] = 38;
        nArray[53] = 31;
        nArray[54] = 39;
        nArray[55] = 46;
        nArray[56] = 53;
        nArray[57] = 60;
        nArray[58] = 61;
        nArray[59] = 54;
        nArray[60] = 47;
        nArray[61] = 55;
        nArray[62] = 62;
        nArray[63] = 63;
        jpegNaturalOrder = nArray;
    }

    public JpegEncoder(Image image, int quality, OutputStream out) {
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.Quality = quality;
        this.JpegObj = new JpegInfo(image);
        this.imageHeight = this.JpegObj.imageHeight;
        this.imageWidth = this.JpegObj.imageWidth;
        this.outStream = new BufferedOutputStream(out);
        this.dct = new DCT(this.Quality);
        this.Huf = new Huffman(this.imageWidth, this.imageHeight);
    }

    public void setQuality(int quality) {
        this.dct = new DCT(quality);
    }

    public int getQuality() {
        return this.Quality;
    }

    public void Compress() {
        this.WriteHeaders(this.outStream);
        this.WriteCompressedData(this.outStream);
        this.WriteEOI(this.outStream);
        try {
            this.outStream.flush();
        }
        catch (IOException e) {
            System.out.println("IO Error: " + e.getMessage());
        }
    }

    public void WriteCompressedData(BufferedOutputStream outStream) {
        boolean temp = false;
        float[][] dctArray1 = new float[8][8];
        double[][] dctArray2 = new double[8][8];
        int[] dctArray3 = new int[64];
        int[] lastDCvalue = new int[this.JpegObj.NumberOfComponents];
        int[] zeroArray = new int[64];
        int Width = 0;
        int Height = 0;
        boolean nothing = false;
        int MinBlockWidth = this.imageWidth % 8 != 0 ? (int)(Math.floor((double)this.imageWidth / 8.0) + 1.0) * 8 : this.imageWidth;
        int MinBlockHeight = this.imageHeight % 8 != 0 ? (int)(Math.floor((double)this.imageHeight / 8.0) + 1.0) * 8 : this.imageHeight;
        int comp = 0;
        while (comp < this.JpegObj.NumberOfComponents) {
            MinBlockWidth = Math.min(MinBlockWidth, this.JpegObj.BlockWidth[comp]);
            MinBlockHeight = Math.min(MinBlockHeight, this.JpegObj.BlockHeight[comp]);
            ++comp;
        }
        int xpos = 0;
        int r = 0;
        while (r < MinBlockHeight) {
            int c = 0;
            while (c < MinBlockWidth) {
                xpos = c * 8;
                int ypos = r * 8;
                comp = 0;
                while (comp < this.JpegObj.NumberOfComponents) {
                    Width = this.JpegObj.BlockWidth[comp];
                    Height = this.JpegObj.BlockHeight[comp];
                    float[][] inputArray = (float[][])this.JpegObj.Components[comp];
                    int i = 0;
                    while (i < this.JpegObj.VsampFactor[comp]) {
                        int j = 0;
                        while (j < this.JpegObj.HsampFactor[comp]) {
                            int xblockoffset = j * 8;
                            int yblockoffset = i * 8;
                            int a = 0;
                            while (a < 8) {
                                int b = 0;
                                while (b < 8) {
                                    dctArray1[a][b] = inputArray[ypos + yblockoffset + a][xpos + xblockoffset + b];
                                    ++b;
                                }
                                ++a;
                            }
                            dctArray2 = this.dct.forwardDCT(dctArray1);
                            dctArray3 = this.dct.quantizeBlock(dctArray2, this.JpegObj.QtableNumber[comp]);
                            this.Huf.HuffmanBlockEncoder(outStream, dctArray3, lastDCvalue[comp], this.JpegObj.DCtableNumber[comp], this.JpegObj.ACtableNumber[comp]);
                            lastDCvalue[comp] = dctArray3[0];
                            ++j;
                        }
                        ++i;
                    }
                    ++comp;
                }
                ++c;
            }
            ++r;
        }
        this.Huf.flushBuffer(outStream);
    }

    public void WriteEOI(BufferedOutputStream out) {
        byte[] EOI = new byte[]{-1, -39};
        this.WriteMarker(EOI, out);
    }

    public void WriteHeaders(BufferedOutputStream out) {
        int j;
        byte[] SOI = new byte[]{-1, -40};
        this.WriteMarker(SOI, out);
        byte[] JFIF = new byte[]{-1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0};
        this.WriteArray(JFIF, out);
        String comment = new String();
        comment = this.JpegObj.getComment();
        int length = comment.length();
        byte[] COM = new byte[length + 4];
        COM[0] = -1;
        COM[1] = -2;
        COM[2] = (byte)(length >> 8 & 0xFF);
        COM[3] = (byte)(length & 0xFF);
        System.arraycopy(this.JpegObj.Comment.getBytes(), 0, COM, 4, this.JpegObj.Comment.length());
        this.WriteArray(COM, out);
        byte[] DQT = new byte[134];
        DQT[0] = -1;
        DQT[1] = -37;
        DQT[2] = 0;
        DQT[3] = -124;
        int offset = 4;
        int i = 0;
        while (i < 2) {
            DQT[offset++] = (byte)(0 + i);
            int[] tempArray = (int[])this.dct.quantum[i];
            j = 0;
            while (j < 64) {
                DQT[offset++] = (byte)tempArray[jpegNaturalOrder[j]];
                ++j;
            }
            ++i;
        }
        this.WriteArray(DQT, out);
        byte[] SOF = new byte[19];
        SOF[0] = -1;
        SOF[1] = -64;
        SOF[2] = 0;
        SOF[3] = 17;
        SOF[4] = (byte)this.JpegObj.Precision;
        SOF[5] = (byte)(this.JpegObj.imageHeight >> 8 & 0xFF);
        SOF[6] = (byte)(this.JpegObj.imageHeight & 0xFF);
        SOF[7] = (byte)(this.JpegObj.imageWidth >> 8 & 0xFF);
        SOF[8] = (byte)(this.JpegObj.imageWidth & 0xFF);
        SOF[9] = (byte)this.JpegObj.NumberOfComponents;
        int index = 10;
        i = 0;
        while (i < SOF[9]) {
            SOF[index++] = (byte)this.JpegObj.CompID[i];
            SOF[index++] = (byte)((this.JpegObj.HsampFactor[i] << 4) + this.JpegObj.VsampFactor[i]);
            SOF[index++] = (byte)this.JpegObj.QtableNumber[i];
            ++i;
        }
        this.WriteArray(SOF, out);
        length = 2;
        index = 4;
        int oldindex = 4;
        byte[] DHT1 = new byte[17];
        byte[] DHT4 = new byte[4];
        DHT4[0] = -1;
        DHT4[1] = -60;
        i = 0;
        while (i < 4) {
            int bytes = 0;
            DHT1[index++ - oldindex] = (byte)((int[])this.Huf.bits.elementAt(i))[0];
            j = 1;
            while (j < 17) {
                int temp = ((int[])this.Huf.bits.elementAt(i))[j];
                DHT1[index++ - oldindex] = (byte)temp;
                bytes += temp;
                ++j;
            }
            int intermediateindex = index;
            byte[] DHT2 = new byte[bytes];
            j = 0;
            while (j < bytes) {
                DHT2[index++ - intermediateindex] = (byte)((int[])this.Huf.val.elementAt(i))[j];
                ++j;
            }
            byte[] DHT3 = new byte[index];
            System.arraycopy(DHT4, 0, DHT3, 0, oldindex);
            System.arraycopy(DHT1, 0, DHT3, oldindex, 17);
            System.arraycopy(DHT2, 0, DHT3, oldindex + 17, bytes);
            DHT4 = DHT3;
            oldindex = index;
            ++i;
        }
        DHT4[2] = (byte)(index - 2 >> 8 & 0xFF);
        DHT4[3] = (byte)(index - 2 & 0xFF);
        this.WriteArray(DHT4, out);
        byte[] SOS = new byte[14];
        SOS[0] = -1;
        SOS[1] = -38;
        SOS[2] = 0;
        SOS[3] = 12;
        SOS[4] = (byte)this.JpegObj.NumberOfComponents;
        index = 5;
        i = 0;
        while (i < SOS[4]) {
            SOS[index++] = (byte)this.JpegObj.CompID[i];
            SOS[index++] = (byte)((this.JpegObj.DCtableNumber[i] << 4) + this.JpegObj.ACtableNumber[i]);
            ++i;
        }
        SOS[index++] = (byte)this.JpegObj.Ss;
        SOS[index++] = (byte)this.JpegObj.Se;
        SOS[index++] = (byte)((this.JpegObj.Ah << 4) + this.JpegObj.Al);
        this.WriteArray(SOS, out);
    }

    void WriteMarker(byte[] data, BufferedOutputStream out) {
        try {
            out.write(data, 0, 2);
        }
        catch (IOException e) {
            System.out.println("IO Error: " + e.getMessage());
        }
    }

    void WriteArray(byte[] data, BufferedOutputStream out) {
        try {
            int length = ((data[2] & 0xFF) << 8) + (data[3] & 0xFF) + 2;
            out.write(data, 0, length);
        }
        catch (IOException e) {
            System.out.println("IO Error: " + e.getMessage());
        }
    }
}

