/*
 * Decompiled with CFR 0.152.
 */
package netimager;

import com.sun.jimi.core.filters.Flip;
import com.sun.jimi.core.filters.Smooth;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import netimager.ColorSelection_Area;
import netimager.ComboBox_DashType_Renderer;
import netimager.JLayerTextPane;
import netimager.ManualSelection_Area;
import netimager.ScaledEditorKit;
import netimager.ScaledTextPane;

public class Layer
extends Component
implements Serializable {
    public static final int ROTATE_LEFT = 1;
    public static final int ROTATE_RIGHT = 2;
    public static final int LAYERTYPE_TEXT = 1;
    public static final int LAYERTYPE_RASTER = 2;
    public static final int LAYERTYPE_SHAPE_LINE = 3;
    public static final int LAYERTYPE_SHAPE_RECTANGLE = 4;
    public static final int LAYERTYPE_SHAPE_ELLIPSE = 5;
    public static final int LINETYPE_START_UP_CORNER = 6;
    public static final int LINETYPE_START_DOWN_CORNER = 7;
    int[] g = new int[10000];
    transient BufferedImage LayersData;
    transient BufferedImage copyLayersData;
    int LayersX;
    int LayersY;
    String Title;
    String[] LayersText;
    public int Width;
    public int Height;
    JLayerTextPane LayerTextPane;
    transient ScaledTextPane scaledTextPane;
    int LayersType = 0;
    int LineType;
    int LineWidth;
    Color LineColor;
    Color FillColor;
    int CornerRadius;
    int DashType;
    boolean FillShape;
    boolean EditingText = false;
    boolean AntiAliasing = true;
    boolean Enabled = true;
    public boolean isShadow = false;
    public boolean scaleTextShadow = true;
    public float ImageZoom;
    public int blur_size;
    public int transparencySize;
    boolean isTransparency = false;
    public Layer Shadow = null;
    Color ShadowColor;
    int displaceXShadow;
    int displaceYShadow;

    public Layer(Image LayersImage, int x, int y, String Tit) {
        this.LayersX = x;
        this.LayersY = y;
        this.Title = Tit;
        this.Width = LayersImage.getWidth(null);
        this.Height = LayersImage.getHeight(null);
        this.LayersData = this.ImageToBufferedImage(LayersImage);
        this.LayersType = 2;
    }

    public Layer(Image LayersImage, int x, int y, String Tit, boolean enabled) {
        this.LayersX = x;
        this.LayersY = y;
        this.Title = Tit;
        this.Enabled = enabled;
        this.Width = LayersImage.getWidth(null);
        this.Height = LayersImage.getHeight(null);
        this.LayersData = this.ImageToBufferedImage(LayersImage);
        this.LayersType = 2;
    }

    public Layer(JLayerTextPane LayerTextpane, int x, int y, String Tit) {
        this.LayersX = x;
        this.LayersY = y;
        this.Title = Tit;
        this.LayersType = 1;
        this.LayerTextPane = LayerTextpane;
        this.LayerTextPane.addKeyListener(new TextPaneKeyListener());
    }

    public Layer(ScaledTextPane scaledTextPane, int x, int y, String Tit) {
        this.LayersX = x;
        this.LayersY = y;
        this.Title = Tit;
        this.LayersType = 1;
        this.scaledTextPane = scaledTextPane;
        scaledTextPane.addKeyListener(new TextScalePaneKeyListener());
    }

    public Layer(int ShapeType, int x, int y, int ShapeWidth, int ShapeHeight, int lineType, int lineWidth, Color lineColor, Color fillColor, int dashType, int cornerRadius, boolean fillShape, String Tit) {
        int offset = lineWidth / 2;
        this.LayersX = x - offset;
        this.LayersY = y - offset;
        this.Width = ShapeWidth + offset * 2;
        this.Height = ShapeHeight + offset * 2;
        this.Title = Tit;
        this.LayersType = ShapeType;
        this.LineType = lineType;
        this.LineWidth = lineWidth;
        this.DashType = dashType;
        this.CornerRadius = cornerRadius;
        this.LineColor = lineColor;
        this.FillColor = fillColor;
        this.FillShape = fillShape;
        BufferedImage bi = new BufferedImage(this.Width, this.Height, 2);
        Graphics2D G2 = bi.createGraphics();
        this.PaintShapeXY(G2, 0, 0);
        this.LayersData = bi;
        G2.dispose();
    }

    public void setEditingText(boolean editingText) {
        if (!editingText) {
            int prefferedWidth = this.LayerTextPane.getWidth();
            int prefferedHeight = this.LayerTextPane.getHeight();
            BufferedImage bi = new BufferedImage(prefferedWidth, prefferedHeight, 2);
            Graphics2D g = bi.createGraphics();
            try {
                Color CaretColor = this.LayerTextPane.getCaretColor();
                Color SelectedTextColor = this.LayerTextPane.getSelectedTextColor();
                Color SelectionColor = this.LayerTextPane.getSelectionColor();
                this.LayerTextPane.setCaretColor(new Color(0, 0, 0, 0));
                this.LayerTextPane.setSelectionColor(new Color(0, 0, 0, 0));
                this.LayerTextPane.setSelectedTextColor(this.LayerTextPane.getForeground());
                this.LayerTextPane.toRaster = true;
                this.LayerTextPane.paint(g);
                this.LayerTextPane.toRaster = false;
                this.LayerTextPane.setCaretColor(CaretColor);
                this.LayerTextPane.setSelectionColor(SelectionColor);
                this.LayerTextPane.setSelectedTextColor(SelectedTextColor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.LayersData = bi;
            this.Width = this.LayersData.getWidth(null);
            this.Height = this.LayersData.getHeight(null);
        }
        this.EditingText = editingText;
    }

    public void setScaleEditingText(boolean editingText) {
        if (!editingText && this.scaledTextPane != null) {
            this.scaledTextPane.getDocument().putProperty("ZOOM_FACTOR", new Double(1.0));
            int prefferedWidth = this.scaledTextPane.getWidth();
            int prefferedHeight = this.scaledTextPane.getHeight();
            BufferedImage bi = new BufferedImage(prefferedWidth, prefferedHeight, 2);
            Graphics2D g = bi.createGraphics();
            Graphics2D g2d = bi.createGraphics();
            g2d.setColor(new Color(0, 0, 0));
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            if (this.AntiAliasing) {
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            try {
                Color CaretColor = this.scaledTextPane.getCaretColor();
                Color SelectedTextColor = this.scaledTextPane.getSelectedTextColor();
                Color SelectionColor = this.scaledTextPane.getSelectionColor();
                this.scaledTextPane.setCaretColor(new Color(0, 0, 0, 0));
                this.scaledTextPane.setSelectionColor(new Color(0, 0, 0, 0));
                this.scaledTextPane.setSelectedTextColor(this.scaledTextPane.getForeground());
                ((ScaledEditorKit)this.scaledTextPane.getEditorKit()).toRaster = true;
                AttributedString as = new AttributedString(this.scaledTextPane.getText());
                StyledDocument doc = this.scaledTextPane.getStyledDocument();
                AttributeSet style = doc.getParagraphElement(0).getAttributes().copyAttributes();
                Graphics gr = this.scaledTextPane.getGraphics();
                Color oldFontColor = (Color)style.getAttribute(StyleConstants.Foreground);
                as.addAttribute(TextAttribute.FOREGROUND, oldFontColor);
                as.addAttribute(TextAttribute.FAMILY, StyleConstants.getFontFamily(style));
                as.addAttribute(TextAttribute.SIZE, new Float(StyleConstants.getFontSize(style)));
                if (StyleConstants.isUnderline(style)) {
                    as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                }
                if (StyleConstants.isBold(style)) {
                    as.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                }
                if (StyleConstants.isItalic(style)) {
                    as.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
                }
                Integer aligment = new Integer(0);
                if (style.getAttribute(StyleConstants.Alignment) != null) {
                    aligment = (Integer)style.getAttribute(StyleConstants.Alignment);
                }
                AttributedCharacterIterator chIterator = as.getIterator();
                FontRenderContext fontRenderContext = g2d.getFontRenderContext();
                LineBreakMeasurer measurer = new LineBreakMeasurer(chIterator, fontRenderContext);
                Insets insets = this.scaledTextPane.getInsets();
                int width = this.scaledTextPane.getSize().width - insets.right - insets.left;
                int x = insets.left + aligment;
                int y = insets.top;
                while (measurer.getPosition() < chIterator.getEndIndex()) {
                    TextLayout textLayout = measurer.nextLayout(width);
                    y = (int)((float)y + textLayout.getAscent());
                    textLayout.draw(g2d, x, y);
                    y = (int)((float)y + (textLayout.getDescent() + textLayout.getLeading()));
                }
                this.scaledTextPane.setVisible(false);
                ((ScaledEditorKit)this.scaledTextPane.getEditorKit()).toRaster = false;
                this.scaledTextPane.setCaretColor(CaretColor);
                this.scaledTextPane.setSelectionColor(SelectionColor);
                this.scaledTextPane.setSelectedTextColor(SelectedTextColor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.LayersData = bi;
            if (this.isShadow && this.scaleTextShadow) {
                this.Shadow.LayersData = bi;
                this.Shadow.transparency(this.Shadow.transparencySize);
            }
            this.Width = this.LayersData.getWidth(null);
            this.Height = this.LayersData.getHeight(null);
        }
        this.EditingText = editingText;
    }

    public int getType() {
        return this.LayersType;
    }

    public void PaintLayer(Graphics2D G, ImageObserver IOS, float Scale) {
        try {
            Graphics2D G2 = (Graphics2D)G.create();
            G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            float ScaleX = (float)this.Width / (float)this.LayersData.getWidth();
            float ScaleY = (float)this.Height / (float)this.LayersData.getHeight();
            if (this.Shadow != null && this.isShadow) {
                if (this.LayersType == 1) {
                    if (this.scaledTextPane != null) {
                        G2.scale(ScaleX, ScaleY);
                        StyledDocument doc = this.scaledTextPane.getStyledDocument();
                        AttributeSet style = doc.getParagraphElement(0).getAttributes().copyAttributes();
                        SimpleAttributeSet new_style = new SimpleAttributeSet();
                        new_style.setResolveParent(style);
                        Color OldForeGround = (Color)style.getAttribute(StyleConstants.Foreground);
                        StyleConstants.setForeground(new_style, this.ShadowColor);
                        doc.setParagraphAttributes(1, this.scaledTextPane.getText().length(), new_style, true);
                        this.scaleTextShadow = true;
                        this.setScaleEditingText(false);
                        G2.drawImage((Image)this.Shadow.LayersData, (int)((float)this.LayersX / ScaleX) + this.displaceXShadow, (int)((float)this.LayersY / ScaleY) + this.displaceYShadow, IOS);
                        StyleConstants.setForeground(new_style, OldForeGround);
                        if (doc != null) {
                            doc.setParagraphAttributes(1, this.scaledTextPane.getText().length(), new_style, true);
                        }
                        this.scaleTextShadow = false;
                        this.setScaleEditingText(false);
                    }
                } else {
                    this.Shadow.LayersData = this.shadowImage(this.Shadow.transparencySize);
                    G2.drawImage((Image)this.Shadow.LayersData, this.LayersX + this.displaceXShadow, this.LayersY + this.displaceYShadow, IOS);
                }
            }
            if (ScaleX == 1.0f && ScaleY == 1.0f) {
                if (this.isShape()) {
                    this.PaintShapeXY(G2, this.LayersX, this.LayersY);
                } else {
                    G2.drawImage((Image)this.LayersData, this.LayersX, this.LayersY, IOS);
                }
            } else if (this.isShape()) {
                this.PaintShapeXY(G2, this.LayersX, this.LayersY);
            } else {
                G2.scale(ScaleX, ScaleY);
                G2.drawImage((Image)this.LayersData, (int)((float)this.LayersX / ScaleX), (int)((float)this.LayersY / ScaleY), IOS);
            }
            G2.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void PaintShapeXY(Graphics2D G2, int x, int y) {
        if (this.AntiAliasing) {
            G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        float[] dash_array = ComboBox_DashType_Renderer.DASHTYPE_SOLID_ARRAY;
        switch (this.DashType) {
            case 1: {
                dash_array = ComboBox_DashType_Renderer.DASHTYPE_SOLID_ARRAY;
                break;
            }
            case 2: {
                dash_array = ComboBox_DashType_Renderer.DASHTYPE_DOTTED_ARRAY;
                break;
            }
            case 3: {
                dash_array = ComboBox_DashType_Renderer.DASHTYPE_DASHED_ARRAY;
                break;
            }
            case 4: {
                dash_array = ComboBox_DashType_Renderer.DASHTYPE_CENTER_ARRAY;
            }
        }
        if (this.LineWidth > 0) {
            G2.setStroke(new BasicStroke(this.LineWidth, 2, 0, 1.0f, dash_array, 1.0f));
        }
        int offset = this.LineWidth / 2;
        if (this.LayersType == 3) {
            G2.setColor(this.LineColor);
            if (this.LineWidth > 0) {
                if (this.LineType == 6) {
                    G2.drawLine(x + offset, y + offset, this.Width - 1 + x - offset * 2, this.Height - 1 + y - offset * 2);
                } else {
                    G2.drawLine(0 + x + offset, this.Height - 1 + y - offset * 2, this.Width - 1 + x - offset * 2, 0 + y + offset);
                }
            }
        } else if (this.LayersType == 4) {
            if (this.FillShape) {
                G2.setColor(this.FillColor);
                G2.fillRoundRect(0 + x + offset, 0 + y + offset, this.Width - 1 - offset * 2, this.Height - 1 - offset * 2, this.CornerRadius, this.CornerRadius);
            }
            G2.setColor(this.LineColor);
            if (this.LineWidth > 0) {
                G2.drawRoundRect(0 + x + offset, 0 + y + offset, this.Width - 1 - offset * 2, this.Height - 1 - offset * 2, this.CornerRadius, this.CornerRadius);
            }
        } else if (this.LayersType == 5) {
            if (this.FillShape) {
                G2.setColor(this.FillColor);
                G2.fillOval(0 + x + offset, 0 + y + offset, this.Width - 1 - offset * 2, this.Height - 1 - offset * 2);
            }
            G2.setColor(this.LineColor);
            if (this.LineWidth > 0) {
                G2.drawOval(0 + x + offset, 0 + y + offset, this.Width - 1 - offset * 2, this.Height - 1 - offset * 2);
            }
        }
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    public void setShadow(int displaceX, int displaceY, Color color, int transparencySize) {
        if (this.LayersData != null) {
            BufferedImage bi;
            this.ShadowColor = color;
            this.displaceXShadow = displaceX;
            this.displaceYShadow = displaceY;
            BufferedImage bim = this.shadowImage(transparencySize);
            this.Shadow = new Layer(bim, this.LayersX + displaceX, this.LayersY + displaceY, "");
            this.Shadow.transparencySize = transparencySize;
            this.Shadow.copyLayersData = bi = new BufferedImage(this.Width, this.Height, 2);
            this.Shadow.copyLayersData.setData(this.LayersData.getData());
            this.isShadow = true;
        }
    }

    public void deleteShadow() {
        this.Shadow = null;
        this.isShadow = false;
    }

    public Point GetPoint() {
        Point P2 = new Point();
        P2.setLocation(this.LayersX, this.LayersY);
        return P2;
    }

    public void SetPoint(Point P2) {
        this.LayersX = (int)P2.getX();
        this.LayersY = (int)P2.getY();
    }

    public void setAntiAliasing(boolean antiAliasing) {
        this.AntiAliasing = antiAliasing;
        if (this.scaledTextPane != null) {
            this.scaledTextPane.AntiAliasing = this.AntiAliasing;
        }
    }

    public boolean CropLayer(Rectangle CropRect) {
        int NewLayersY;
        int RealCropY1;
        int NewLayersX;
        int RealCropX1;
        int CropAreaX1 = (int)CropRect.getX();
        int CropAreaY1 = (int)CropRect.getY();
        int CropAreaX2 = (int)CropRect.getX() + (int)CropRect.getWidth() - 1;
        int CropAreaY2 = (int)CropRect.getY() + (int)CropRect.getHeight() - 1;
        int LayersX1 = this.LayersX;
        int LayersY1 = this.LayersY;
        int LayersX2 = this.LayersX + this.Width - 1;
        int LayersY2 = this.LayersY + this.Height - 1;
        if (LayersX1 < CropAreaX1) {
            RealCropX1 = CropAreaX1;
            NewLayersX = 0;
        } else {
            NewLayersX = this.LayersX - CropAreaX1;
            RealCropX1 = LayersX1;
        }
        if (LayersY1 > CropAreaY1) {
            RealCropY1 = LayersY1;
            NewLayersY = this.LayersY - CropAreaY1;
        } else {
            NewLayersY = 0;
            RealCropY1 = CropAreaY1;
        }
        int RealCropX2 = LayersX2 < CropAreaX2 ? LayersX2 : CropAreaX2;
        int RealCropY2 = LayersY2 > CropAreaY2 ? CropAreaY2 : LayersY2;
        int NewWidth = (RealCropX2 -= this.LayersX) - (RealCropX1 -= this.LayersX) + 1;
        int NewHeight = (RealCropY2 -= this.LayersY) - (RealCropY1 -= this.LayersY) + 1;
        if (NewWidth > 0 && NewHeight > 0) {
            int[] DstData = new int[NewWidth * NewHeight];
            try {
                PixelGrabber Grabber = new PixelGrabber(this.LayersData, RealCropX1, RealCropY1, NewWidth, NewHeight, DstData, 0, NewWidth);
                Grabber.grabPixels();
            }
            catch (InterruptedException Grabber) {
                // empty catch block
            }
            Canvas C = new Canvas();
            Image Img = C.createImage(new MemoryImageSource(NewWidth, NewHeight, DstData, 0, NewWidth));
            this.LayersData = this.ImageToBufferedImage(Img);
            this.LayersX = NewLayersX;
            this.LayersY = NewLayersY;
            this.Width = NewWidth;
            this.Height = NewHeight;
            return true;
        }
        return false;
    }

    public Image CopyFromLayer(ManualSelection_Area ManualArea) {
        int SelectionWidth = ManualArea.getAreaWidth();
        int SelectionHeight = ManualArea.getAreaHeight();
        int[] Mask = ManualArea.getMask();
        int TransparentPixel = 0;
        int MaxX = Integer.MIN_VALUE;
        int MinX = Integer.MAX_VALUE;
        int MaxY = Integer.MIN_VALUE;
        int MinY = Integer.MAX_VALUE;
        int i = 0;
        while (i <= SelectionHeight - 1) {
            int j = 0;
            while (j <= SelectionWidth - 1) {
                if (Mask[i * SelectionWidth + j] == 1) {
                    if (MaxX < j) {
                        MaxX = j;
                    }
                    if (MinX > j) {
                        MinX = j;
                    }
                    if (MaxY < i) {
                        MaxY = i;
                    }
                    if (MinY > i) {
                        MinY = i;
                    }
                }
                ++j;
            }
            ++i;
        }
        Canvas C = new Canvas();
        int newImageHeight = 0;
        int newImageWidth = 0;
        newImageHeight = MaxY - MinY + 1;
        newImageWidth = MaxX - MinX + 1;
        int[] DstData = new int[newImageWidth * newImageHeight];
        BufferedImage b_image = ManualArea.resize(this.LayersData);
        PixelGrabber Grabber = null;
        try {
            Grabber = new PixelGrabber(b_image, MinX, MinY, newImageWidth, newImageHeight, DstData, 0, newImageWidth);
            Grabber.grabPixels();
        }
        catch (InterruptedException ee) {
            ee.printStackTrace();
        }
        int i2 = 0;
        while (i2 <= newImageHeight - 1) {
            int j = 0;
            while (j <= newImageWidth - 1) {
                if (Mask[(i2 + MinY) * SelectionWidth + j + MinX] != 1) {
                    DstData[i2 * newImageWidth + j] = TransparentPixel;
                }
                ++j;
            }
            ++i2;
        }
        Image Img = C.createImage(new MemoryImageSource(newImageWidth, newImageHeight, DstData, 0, newImageWidth));
        return Img;
    }

    public Image CopyFromLayer(ColorSelection_Area ColorArea) {
        int SelectionWidth = ColorArea.getAreaWidth();
        int SelectionHeight = ColorArea.getAreaHeight();
        int[] Mask = ColorArea.getMask();
        int TransparentPixel = 0;
        int MaxX = Integer.MIN_VALUE;
        int MinX = Integer.MAX_VALUE;
        int MaxY = Integer.MIN_VALUE;
        int MinY = Integer.MAX_VALUE;
        int i = 0;
        while (i <= SelectionHeight - 1) {
            int j = 0;
            while (j <= SelectionWidth - 1) {
                if (Mask[i * SelectionWidth + j] == 1) {
                    if (MaxX < j) {
                        MaxX = j;
                    }
                    if (MinX > j) {
                        MinX = j;
                    }
                    if (MaxY < i) {
                        MaxY = i;
                    }
                    if (MinY > i) {
                        MinY = i;
                    }
                }
                ++j;
            }
            ++i;
        }
        Canvas C = new Canvas();
        int newImageHeight = MaxY - MinY + 1;
        int newImageWidth = MaxX - MinX + 1;
        int[] DstData = new int[newImageWidth * newImageHeight];
        try {
            PixelGrabber Grabber = new PixelGrabber(this.LayersData, MinX, MinY, newImageWidth, newImageHeight, DstData, 0, newImageWidth);
            Grabber.grabPixels();
        }
        catch (InterruptedException ee) {
            ee.printStackTrace();
        }
        int i2 = 0;
        while (i2 <= newImageHeight - 1) {
            int j = 0;
            while (j <= newImageWidth - 1) {
                if (Mask[(i2 + MinY) * SelectionWidth + j + MinX] != 1) {
                    DstData[i2 * newImageWidth + j] = TransparentPixel;
                }
                ++j;
            }
            ++i2;
        }
        Image Img = C.createImage(new MemoryImageSource(newImageWidth, newImageHeight, DstData, 0, newImageWidth));
        return Img;
    }

    public Image CopyFromLayer(Rectangle CopyRect) {
        int RealCopyY1;
        int RealCopyX1;
        int CopyAreaX1 = (int)CopyRect.getX();
        int CopyAreaY1 = (int)CopyRect.getY();
        int CopyAreaX2 = (int)CopyRect.getX() + (int)CopyRect.getWidth() - 1;
        int CopyAreaY2 = (int)CopyRect.getY() + (int)CopyRect.getHeight() - 1;
        int LayersX1 = this.LayersX;
        int LayersY1 = this.LayersY;
        int LayersX2 = this.LayersX + this.Width - 1;
        int LayersY2 = this.LayersY + this.Height - 1;
        if (LayersX1 < CopyAreaX1) {
            RealCopyX1 = CopyAreaX1;
            boolean NewLayersX = false;
        } else {
            int NewLayersX = this.LayersX - CopyAreaX1;
            RealCopyX1 = LayersX1;
        }
        if (LayersY1 > CopyAreaY1) {
            RealCopyY1 = LayersY1;
            int NewLayersY = this.LayersY - CopyAreaY1;
        } else {
            boolean NewLayersY = false;
            RealCopyY1 = CopyAreaY1;
        }
        int RealCopyX2 = LayersX2 < CopyAreaX2 ? LayersX2 : CopyAreaX2;
        int RealCopyY2 = LayersY2 > CopyAreaY2 ? CopyAreaY2 : LayersY2;
        int NewWidth = (RealCopyX2 -= this.LayersX) - (RealCopyX1 -= this.LayersX) + 1;
        int NewHeight = (RealCopyY2 -= this.LayersY) - (RealCopyY1 -= this.LayersY) + 1;
        if (NewWidth > 0 && NewHeight > 0) {
            int[] DstData = new int[NewWidth * NewHeight];
            try {
                PixelGrabber Grabber = new PixelGrabber(this.LayersData, RealCopyX1, RealCopyY1, NewWidth, NewHeight, DstData, 0, NewWidth);
                Grabber.grabPixels();
            }
            catch (InterruptedException ee) {
                ee.printStackTrace();
            }
            Canvas C = new Canvas();
            Image Img = C.createImage(new MemoryImageSource(NewWidth, NewHeight, DstData, 0, NewWidth));
            return Img;
        }
        return null;
    }

    public BufferedImage ImageToBufferedImage(Image image) {
        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D G2 = bi.createGraphics();
        G2.drawImage(image, 0, 0, null);
        G2.dispose();
        return bi;
    }

    public void setIndexTransparency(int _red, int _green, int _blue) {
        int TransparentPixel = 0;
        int[] pixels = new int[this.Width * this.Height];
        Canvas C = new Canvas();
        PixelGrabber grabber = new PixelGrabber(this.LayersData, 0, 0, this.Width, this.Height, pixels, 0, this.Width);
        try {
            grabber.grabPixels();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int index = 0;
        while (index < pixels.length) {
            int rgba = pixels[index];
            int red = rgba >> 16 & 0xFF;
            int green = rgba >> 8 & 0xFF;
            int blue = rgba & 0xFF;
            int alpha = rgba >> 24 & 0xFF;
            if (red == _red && blue == _blue && green == _green) {
                pixels[index] = TransparentPixel;
            }
            Image Img = C.createImage(new MemoryImageSource(this.Width, this.Height, pixels, 0, this.Width));
            this.LayersData = this.ImageToBufferedImage(Img);
            ++index;
        }
    }

    public Image CutFromLayer(ColorSelection_Area ColorArea) {
        int[] Mask = ColorArea.getMask();
        int TransparentPixel = 0;
        int MaxX = Integer.MIN_VALUE;
        int MinX = Integer.MAX_VALUE;
        int MaxY = Integer.MIN_VALUE;
        int MinY = Integer.MAX_VALUE;
        int i = 0;
        while (i <= this.Height - 1) {
            int j = 0;
            while (j <= this.Width - 1) {
                if (Mask[i * this.Width + j] == 1) {
                    if (MaxX < j) {
                        MaxX = j;
                    }
                    if (MinX > j) {
                        MinX = j;
                    }
                    if (MaxY < i) {
                        MaxY = i;
                    }
                    if (MinY > i) {
                        MinY = i;
                    }
                }
                ++j;
            }
            ++i;
        }
        Canvas C = new Canvas();
        int SelectionHeight = MaxY - MinY + 1;
        int SelectionWidth = MaxX - MinX + 1;
        int[] SelectionData = new int[SelectionHeight * SelectionWidth];
        int[] NewLayersData = new int[this.Width * this.Height];
        try {
            PixelGrabber Grabber = new PixelGrabber(this.LayersData, 0, 0, this.Width, this.Height, NewLayersData, 0, this.Width);
            Grabber.grabPixels();
        }
        catch (InterruptedException Grabber) {
            // empty catch block
        }
        int i2 = MinY;
        while (i2 <= MinY + SelectionHeight - 1) {
            int j = MinX;
            while (j <= MinX + SelectionWidth - 1) {
                if (Mask[i2 * this.Width + j] == 1) {
                    SelectionData[(i2 - MinY) * SelectionWidth + j - MinX] = NewLayersData[i2 * this.Width + j];
                    NewLayersData[i2 * this.Width + j] = TransparentPixel;
                }
                ++j;
            }
            ++i2;
        }
        Image Img = C.createImage(new MemoryImageSource(this.Width, this.Height, NewLayersData, 0, this.Width));
        this.LayersData = this.ImageToBufferedImage(Img);
        Img = C.createImage(new MemoryImageSource(SelectionWidth, SelectionHeight, SelectionData, 0, SelectionWidth));
        return Img;
    }

    public Image CutFromLayer(ManualSelection_Area ManualArea) {
        int[] Mask = ManualArea.getMask();
        int TransparentPixel = 0;
        int MaxX = Integer.MIN_VALUE;
        int MinX = Integer.MAX_VALUE;
        int MaxY = Integer.MIN_VALUE;
        int MinY = Integer.MAX_VALUE;
        int i = 0;
        while (i <= this.Height - 1) {
            int j = 0;
            while (j <= this.Width - 1) {
                if (Mask[i * this.Width + j] == 1) {
                    if (MaxX < j) {
                        MaxX = j;
                    }
                    if (MinX > j) {
                        MinX = j;
                    }
                    if (MaxY < i) {
                        MaxY = i;
                    }
                    if (MinY > i) {
                        MinY = i;
                    }
                }
                ++j;
            }
            ++i;
        }
        Canvas C = new Canvas();
        int SelectionHeight = MaxY - MinY + 1;
        int SelectionWidth = MaxX - MinX + 1;
        int[] SelectionData = new int[SelectionHeight * SelectionWidth];
        int[] NewLayersData = new int[this.Width * this.Height];
        try {
            PixelGrabber Grabber = new PixelGrabber(this.LayersData, 0, 0, this.Width, this.Height, NewLayersData, 0, this.Width);
            Grabber.grabPixels();
        }
        catch (InterruptedException Grabber) {
            // empty catch block
        }
        int i2 = MinY;
        while (i2 <= MinY + SelectionHeight - 1) {
            int j = MinX;
            while (j <= MinX + SelectionWidth - 1) {
                if (Mask[i2 * this.Width + j] == 1) {
                    SelectionData[(i2 - MinY) * SelectionWidth + j - MinX] = NewLayersData[i2 * this.Width + j];
                    NewLayersData[i2 * this.Width + j] = TransparentPixel;
                }
                ++j;
            }
            ++i2;
        }
        Image Img = C.createImage(new MemoryImageSource(this.Width, this.Height, NewLayersData, 0, this.Width));
        this.LayersData = this.ImageToBufferedImage(Img);
        Img = C.createImage(new MemoryImageSource(SelectionWidth, SelectionHeight, SelectionData, 0, SelectionWidth));
        return Img;
    }

    public Image CutFromLayer(Rectangle CutRect) {
        int NewLayersY;
        int RealCutY1;
        int NewLayersX;
        int RealCutX1;
        int CutAreaX1 = (int)CutRect.getX();
        int CutAreaY1 = (int)CutRect.getY();
        int CutAreaX2 = (int)CutRect.getX() + (int)CutRect.getWidth() - 1;
        int CutAreaY2 = (int)CutRect.getY() + (int)CutRect.getHeight() - 1;
        int LayersX1 = this.LayersX;
        int LayersY1 = this.LayersY;
        int LayersX2 = this.LayersX + this.Width - 1;
        int LayersY2 = this.LayersY + this.Height - 1;
        if (LayersX1 < CutAreaX1) {
            RealCutX1 = CutAreaX1;
            NewLayersX = 0;
        } else {
            NewLayersX = this.LayersX - CutAreaX1;
            RealCutX1 = LayersX1;
        }
        if (LayersY1 > CutAreaY1) {
            RealCutY1 = LayersY1;
            NewLayersY = this.LayersY - CutAreaY1;
        } else {
            NewLayersY = 0;
            RealCutY1 = CutAreaY1;
        }
        int RealCutX2 = LayersX2 < CutAreaX2 ? LayersX2 : CutAreaX2;
        int RealCutY2 = LayersY2 > CutAreaY2 ? CutAreaY2 : LayersY2;
        int NewWidth = (RealCutX2 -= this.LayersX) - (RealCutX1 -= this.LayersX) + 1;
        int NewHeight = (RealCutY2 -= this.LayersY) - (RealCutY1 -= this.LayersY) + 1;
        if (NewWidth > 0 && NewHeight > 0) {
            int[] DstData = new int[NewWidth * NewHeight];
            try {
                PixelGrabber Grabber = new PixelGrabber(this.LayersData, RealCutX1, RealCutY1, NewWidth, NewHeight, DstData, 0, NewWidth);
                Grabber.grabPixels();
            }
            catch (InterruptedException Grabber) {
                // empty catch block
            }
            Canvas C = new Canvas();
            Image CopyImg = C.createImage(new MemoryImageSource(NewWidth, NewHeight, DstData, 0, NewWidth));
            int[] CutData = new int[this.Width * this.Height];
            try {
                PixelGrabber Grabber = new PixelGrabber(this.LayersData, 0, 0, this.Width, this.Height, CutData, 0, this.Width);
                Grabber.grabPixels();
            }
            catch (InterruptedException Grabber) {
                // empty catch block
            }
            int i = RealCutY1;
            while (i <= RealCutY2) {
                int j = RealCutX1;
                while (j <= RealCutX2) {
                    CutData[i * this.Width + j] = 0;
                    ++j;
                }
                ++i;
            }
            Image Img = C.createImage(new MemoryImageSource(this.Width, this.Height, CutData, 0, this.Width));
            this.LayersData = this.ImageToBufferedImage(Img);
            return CopyImg;
        }
        return null;
    }

    public void Resize(double ScaleX, double ScaleY, int InterpolationType, boolean oneLayer) {
        if (this.isShape()) {
            this.Width = (int)((double)this.Width * (ScaleX / 100.0));
            this.Height = (int)((double)this.Height * (ScaleY / 100.0));
            this.ChangeShapeParam();
        } else {
            BufferedImage bi = new BufferedImage(this.Width, this.Height, 2);
            Graphics2D graphics = bi.createGraphics();
            graphics.drawImage((Image)this.LayersData, 0, 0, null);
            AffineTransform AffineTrans = new AffineTransform();
            AffineTrans.scale(ScaleX / 100.0, ScaleY / 100.0);
            this.Width = (int)((double)this.Width * (ScaleX / 100.0));
            this.Height = (int)((double)this.Height * (ScaleY / 100.0));
            BufferedImage bimg = new BufferedImage(this.Width, this.Height, 2);
            AffineTransformOp biop = new AffineTransformOp(AffineTrans, InterpolationType);
            biop.filter(bi, bimg);
            this.LayersData = bimg;
        }
        if (!oneLayer) {
            this.LayersX = (int)((double)this.LayersX * (ScaleX / 100.0));
            this.LayersY = (int)((double)this.LayersY * (ScaleY / 100.0));
        }
    }

    public void Rotate(int RotateAngle, int RotateDirection) {
        double Alfa = RotateDirection == 2 ? Math.toRadians(RotateAngle) : Math.toRadians(-RotateAngle);
        BufferedImage bi = new BufferedImage(this.Width, this.Height, 2);
        Graphics2D graphics = bi.createGraphics();
        graphics.drawImage((Image)this.LayersData, 0, 0, null);
        double NewWidth = Math.abs((double)this.Height * Math.sin(Alfa)) + Math.abs((double)this.Width * Math.cos(Alfa)) + 2.0;
        double NewHeight = Math.abs((double)this.Height * Math.cos(Alfa)) + Math.abs((double)this.Width * Math.sin(Alfa)) + 2.0;
        AffineTransform AffineTrans = new AffineTransform();
        AffineTrans.preConcatenate(new AffineTransform(1.0, 0.0, 0.0, 1.0, (NewWidth - (double)this.Width) / 2.0, (NewHeight - (double)this.Height) / 2.0));
        AffineTrans.rotate(Alfa, this.Width / 2, this.Height / 2);
        BufferedImage bimg = new BufferedImage((int)NewWidth, (int)NewHeight, 2);
        AffineTransformOp biop = new AffineTransformOp(AffineTrans, 1);
        biop.filter(bi, bimg);
        this.LayersData = bimg;
        this.Height = (int)NewHeight;
        this.Width = (int)NewWidth;
    }

    public void RotateIntoCanvas(int RotateAngle, int RotateDirection, int oldImageWidth, int oldImageHeight, int newImageWidth, int newImageHeight) {
        double Alfa = RotateDirection == 2 ? Math.toRadians(RotateAngle) : Math.toRadians(-RotateAngle);
        BufferedImage bi = new BufferedImage(oldImageWidth, oldImageHeight, 2);
        Graphics2D graphics = bi.createGraphics();
        graphics.drawImage((Image)this.LayersData, this.LayersX, this.LayersY, null);
        AffineTransform AffineTrans = new AffineTransform();
        AffineTrans.preConcatenate(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, (newImageWidth - oldImageWidth) / 2, (newImageHeight - oldImageHeight) / 2));
        AffineTrans.rotate(Alfa, oldImageWidth / 2, oldImageHeight / 2);
        BufferedImage bimg = new BufferedImage(newImageWidth, newImageHeight, 2);
        AffineTransformOp biop = new AffineTransformOp(AffineTrans, 1);
        biop.filter(bi, bimg);
        int[] DstData = new int[newImageWidth * newImageHeight];
        try {
            PixelGrabber Grabber = new PixelGrabber(bimg, 0, 0, newImageWidth, newImageHeight, DstData, 0, newImageWidth);
            Grabber.grabPixels();
        }
        catch (InterruptedException Grabber) {
            // empty catch block
        }
        int TransparentPixel = 0;
        int MaxX = Integer.MIN_VALUE;
        int MinX = Integer.MAX_VALUE;
        int MaxY = Integer.MIN_VALUE;
        int MinY = Integer.MAX_VALUE;
        int i = 0;
        while (i <= newImageHeight - 1) {
            int j = 0;
            while (j <= newImageWidth - 1) {
                if (DstData[i * newImageWidth + j] != TransparentPixel) {
                    if (MaxX < j) {
                        MaxX = j;
                    }
                    if (MinX > j) {
                        MinX = j;
                    }
                    if (MaxY < i) {
                        MaxY = i;
                    }
                    if (MinY > i) {
                        MinY = i;
                    }
                }
                ++j;
            }
            ++i;
        }
        Canvas C = new Canvas();
        this.Height = MaxY - MinY + 1;
        this.Width = MaxX - MinX + 1;
        try {
            PixelGrabber Grabber = new PixelGrabber(bimg, MinX, MinY, this.Width, this.Height, DstData, 0, this.Width);
            Grabber.grabPixels();
        }
        catch (InterruptedException Grabber) {
            // empty catch block
        }
        Image Img = C.createImage(new MemoryImageSource(this.Width, this.Height, DstData, 0, this.Width));
        this.LayersData = this.ImageToBufferedImage(Img);
        this.LayersX = MinX;
        this.LayersY = MinY;
    }

    public void Flip(int FlipType) {
        ImageProducer source = this.LayersData.getSource();
        Flip filter = new Flip(source, FlipType);
        FilteredImageSource fis = new FilteredImageSource(source, filter);
        this.Width = this.LayersData.getWidth(null);
        this.Height = this.LayersData.getHeight(null);
        this.LayersData = this.ImageToBufferedImage(new Canvas().createImage(fis));
    }

    public void toGrayscale() {
        BufferedImage bi = new BufferedImage(this.Width, this.Height, 2);
        Graphics2D G2 = bi.createGraphics();
        G2.drawImage((Image)this.LayersData, 0, 0, null);
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        this.LayersData = op.filter(bi, null);
    }

    public void StopResizing() {
        if (this.LayersData != null) {
            int oldWidth = this.LayersData.getWidth();
            int oldHeight = this.LayersData.getHeight();
            if (oldWidth != this.Width || oldHeight != this.Height) {
                if (this.LayersType == 4 || this.LayersType == 3 || this.LayersType == 5) {
                    this.ChangeShapeParam();
                } else {
                    float ScaleX = (float)this.Width / (float)oldWidth * 100.0f;
                    float ScaleY = (float)this.Height / (float)oldHeight * 100.0f;
                    this.Width = oldWidth;
                    this.Height = oldHeight;
                    this.Resize(ScaleX, ScaleY, 2, true);
                }
            }
        }
    }

    public void Brush(int x, int y, int BrushSize, int BrushMode, Color BrushColor) {
        Graphics2D G2 = this.LayersData.createGraphics();
        if (BrushColor.getAlpha() == 0) {
            int rule = 1;
            G2.setComposite(AlphaComposite.getInstance(rule, 0.0f));
            G2.setPaint(BrushColor);
        } else {
            G2.setColor(BrushColor);
        }
        if (BrushMode == 1) {
            G2.fillRect(x - BrushSize / 2, y - BrushSize / 2, BrushSize, BrushSize);
        }
        if (BrushMode == 0) {
            G2.fillArc(x - BrushSize / 2, y - BrushSize / 2, BrushSize, BrushSize, 0, 360);
            G2.clipRect(x - BrushSize / 2, y - BrushSize / 2, BrushSize, BrushSize);
        }
        G2.dispose();
    }

    public void Rasterize() {
        this.LayerTextPane = null;
        this.LayersType = 2;
    }

    public void ChangeShapeParam() {
        BufferedImage bi = new BufferedImage(this.Width, this.Height, 2);
        Graphics2D G2 = bi.createGraphics();
        this.PaintShapeXY(G2, 0, 0);
        this.LayersData = bi;
        G2.dispose();
    }

    public boolean isShape() {
        return this.LayersType == 3 || this.LayersType == 4 || this.LayersType == 5;
    }

    public boolean isRaster() {
        return this.LayersType == 2;
    }

    public String GetTitle() {
        return this.Title;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int[] ImageBuf = new int[this.Width * this.Height];
        out.defaultWriteObject();
        try {
            PixelGrabber Grabber = new PixelGrabber(this.LayersData, 0, 0, this.Width, this.Height, ImageBuf, 0, this.Width);
            Grabber.grabPixels();
        }
        catch (InterruptedException ee) {
            ee.printStackTrace();
        }
        out.writeInt(this.Width);
        out.writeInt(this.Height);
        out.writeObject(ImageBuf);
        out.flush();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.Width = in.readInt();
        this.Height = in.readInt();
        int[] ImageBuf = (int[])in.readObject();
        Canvas C = new Canvas();
        this.LayersData = this.ImageToBufferedImage(C.createImage(new MemoryImageSource(this.Width, this.Height, ImageBuf, 0, this.Width)));
    }

    void AutoSizeTextPane(boolean addOffsets) {
        int preferredWidth;
        int preferredHeight;
        View v = this.LayerTextPane.getUI().getRootView(this.LayerTextPane);
        v.setSize(5000.0f, 5000.0f);
        Graphics2D G2 = (Graphics2D)this.LayerTextPane.getGraphics();
        FontRenderContext context = G2.getFontRenderContext();
        Rectangle2D bound = this.LayerTextPane.getFont().getStringBounds("W", context);
        int dw = (int)bound.getWidth();
        bound = this.LayerTextPane.getFont().getStringBounds("TWygpg", context);
        int dh = (int)bound.getHeight();
        if (addOffsets) {
            preferredHeight = (int)(v.getPreferredSpan(1) + (float)(dh * 2));
            preferredWidth = (int)(v.getPreferredSpan(0) + (float)(dw * 2));
        } else {
            preferredHeight = (int)(v.getPreferredSpan(1) + (float)dh);
            preferredWidth = (int)(v.getPreferredSpan(0) + (float)dw);
        }
        this.Width = preferredWidth;
        this.Height = preferredHeight;
        this.LayerTextPane.setSize(preferredWidth, preferredHeight);
    }

    void AutoSizeScaledTextPane(boolean addOffsets) {
        int preferredWidth;
        View v = this.scaledTextPane.getUI().getRootView(this.scaledTextPane);
        v.setSize(5000.0f, 5000.0f);
        Graphics2D G2 = (Graphics2D)this.scaledTextPane.getGraphics();
        FontRenderContext context = G2.getFontRenderContext();
        Rectangle2D bound = this.scaledTextPane.getFont().getStringBounds("W", context);
        int dw = (int)bound.getWidth();
        bound = this.scaledTextPane.getFont().getStringBounds("TWygpg", context);
        int dh = (int)bound.getHeight();
        int preferredHeight = (int)(v.getPreferredSpan(1) + (float)dh);
        this.Width = preferredWidth = (int)(v.getPreferredSpan(0) + (float)dw);
        this.Height = preferredHeight;
        this.scaledTextPane.setSize(preferredWidth, preferredHeight);
    }

    public void blur(int blur_Size) {
        ImageProducer source = this.LayersData.getSource();
        Smooth filter = new Smooth(source, blur_Size);
        FilteredImageSource fis = new FilteredImageSource(source, filter);
        this.LayersData = this.ImageToBufferedImage(this.createImage(fis));
    }

    public BufferedImage shadowImage(int transparency_size) {
        BufferedImage bi = new BufferedImage(this.Width, this.Height, 2);
        Graphics2D G2 = bi.createGraphics();
        float ScaleX = (float)this.Width / (float)this.LayersData.getWidth();
        float ScaleY = (float)this.Height / (float)this.LayersData.getHeight();
        G2.setColor(this.ShadowColor);
        int offset = this.LineWidth / 2;
        if (this.LayersType == 1) {
            return this.LayersData;
        }
        if (this.LayersType == 2) {
            G2.fillRect(0, 0, this.LayersData.getWidth(), this.LayersData.getHeight());
        }
        if (this.LayersType == 4) {
            if (this.FillShape) {
                G2.fillRect(0, 0, this.LayersData.getWidth(), this.LayersData.getHeight());
            } else {
                G2.drawRect(0, 0, this.LayersData.getWidth() - 1, this.LayersData.getHeight() - 1);
            }
        }
        if (this.LayersType == 5) {
            if (this.FillShape) {
                G2.fillOval(0, 0, this.Width - 1 - offset * 2, this.Height - 1 - offset * 2);
            }
            if (this.LineWidth > 0) {
                G2.drawOval(0, 0, this.Width - 1 - offset * 2, this.Height - 1 - offset * 2);
            }
        }
        if (this.LayersType == 3 && this.LineWidth > 0) {
            if (this.LineType == 6) {
                G2.drawLine(0, 0, this.Width - 1 - offset * 2, this.Height - 1 + offset * 2);
            } else {
                G2.drawLine(0 + offset, this.Height - 1 - offset * 2, this.Width - 1 - offset * 2, 0 + offset);
            }
        }
        BufferedImage srcLayer = new BufferedImage(this.Width, this.Height, 2);
        WritableRaster srcLayerRaster = null;
        try {
            srcLayerRaster = bi.copyData(srcLayer.getRaster());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (srcLayerRaster != null) {
            int[] srcData = new int[4];
            int i = 0;
            while (i <= this.Height - 1) {
                int j = 0;
                while (j <= this.Width - 1) {
                    if ((srcData = srcLayerRaster.getPixel(j, i, srcData))[3] != 0) {
                        srcData[3] = transparency_size;
                        srcLayerRaster.setPixel(j, i, srcData);
                    }
                    ++j;
                }
                ++i;
            }
        }
        G2.dispose();
        return srcLayer;
    }

    public void transparency(int transparency_size) {
        if (this.isTransparency) {
            BufferedImage srcLayer = new BufferedImage(this.LayersData.getWidth(), this.LayersData.getHeight(), 2);
            srcLayer.setData(this.LayersData.getData());
            int LayerWidth = this.LayersData.getWidth();
            int LayerHeight = this.LayersData.getHeight();
            WritableRaster srcLayerRaster = null;
            try {
                srcLayerRaster = this.LayersData.copyData(srcLayer.getRaster());
                if (srcLayerRaster != null) {
                    int[] srcData = new int[4];
                    int i = 0;
                    while (i <= LayerHeight - 1) {
                        int j = 0;
                        while (j <= LayerWidth - 1) {
                            if ((srcData = srcLayerRaster.getPixel(j, i, srcData))[3] != 0) {
                                srcData[3] = transparency_size;
                                srcLayerRaster.setPixel(j, i, srcData);
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.LayersData = srcLayer;
        }
    }

    private class TextPaneKeyListener
    implements KeyListener {
        private TextPaneKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            Layer.this.AutoSizeTextPane(true);
        }

        public void keyTyped(KeyEvent e) {
            Layer.this.AutoSizeTextPane(true);
        }

        public void keyReleased(KeyEvent e) {
            Layer.this.AutoSizeTextPane(true);
        }
    }

    private class TextScalePaneKeyListener
    implements KeyListener {
        private TextScalePaneKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            Layer.this.AutoSizeScaledTextPane(true);
        }

        public void keyTyped(KeyEvent e) {
            Layer.this.AutoSizeScaledTextPane(true);
        }

        public void keyReleased(KeyEvent e) {
            Layer.this.AutoSizeScaledTextPane(true);
        }
    }
}

