/*
 * Decompiled with CFR 0.152.
 */
package netimager;

import java.awt.AWTEventMulticaster;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import netimager.JLayerTextPane;
import netimager.Layer;
import netimager.ScaledTextPane;

public class Layers_Repository
implements Serializable {
    public Layer[] Layers;
    public int LayersCount;
    public int ImageWidth;
    public int ImageHeight;
    public Color Background;
    public int SelectedLayer;
    protected transient ActionListener ChangeSelectedLayerListener;
    public float ImageZoom;

    public Layers_Repository() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Layers_Repository(int LayersNum, int Width, int Height) {
        this.Layers = new Layer[LayersNum];
        this.LayersCount = 0;
        this.ImageHeight = Height;
        this.ImageWidth = Width;
        this.Background = new Color(0, 0, 0, 0);
        this.SetSelectedLayer(-1);
        this.ImageZoom = 1.0f;
    }

    public void PaintAll(Graphics G, ImageObserver IOS, float Scale, boolean DrawSelection, boolean DrawTransGround) {
        Graphics2D G2 = (Graphics2D)G.create();
        G2.scale(Scale, Scale);
        if (DrawTransGround) {
            int SquareSize = 10;
            int SquareCountX = this.ImageWidth / SquareSize;
            int SquareCountY = this.ImageHeight / SquareSize;
            G2.setColor(Color.white);
            G2.fillRect(0, 0, this.ImageWidth, this.ImageHeight);
            G2.setColor(new Color(230, 230, 230));
            int i = 0;
            while (i <= SquareCountX) {
                int j = 0;
                while (j <= SquareCountY) {
                    if (i % 2 == 0 && j % 2 == 1 || i % 2 == 1 && j % 2 == 0) {
                        G2.fillRect(i * SquareSize, j * SquareSize, SquareSize, SquareSize);
                    }
                    ++j;
                }
                ++i;
            }
        }
        G2.setColor(this.Background);
        G2.fillRect(0, 0, this.ImageWidth, this.ImageHeight);
        int i = 0;
        while (i <= this.LayersCount - 1) {
            if (!this.Layers[i].EditingText) {
                this.Layers[i].PaintLayer(G2, IOS, 1.0f);
            }
            ++i;
        }
        if (this.SelectedLayer != -1 && DrawSelection) {
            int x1 = this.Layers[this.SelectedLayer].LayersX;
            int y1 = this.Layers[this.SelectedLayer].LayersY;
            this.DrawExternalFrame(x1, y1, G2);
        }
        G2.dispose();
    }

    public void DrawExternalFrame(int x1, int y1, Graphics2D G2) {
        int Width = this.Layers[this.SelectedLayer].Width;
        int Height = this.Layers[this.SelectedLayer].Height;
        int x2 = x1 + Width - 2;
        int y2 = y1 + Height - 2;
        G2.setStroke(new BasicStroke(1.0f, 2, 0, 1.0f, new float[]{0.0f, 2.0f}, 1.0f));
        G2.setColor(Color.black);
        G2.drawRect(x1, y1, Width - 1, Height - 1);
        if (!this.Layers[this.SelectedLayer].EditingText) {
            int smallRectSize = 5;
            int smallRectOffset = 3;
            G2.setStroke(new BasicStroke(1.0f, 2, 0, 1.0f, new float[]{1.0f, 1.0f}, 1.0f));
            G2.setPaint(Color.white);
            G2.fillRect(x1 - smallRectOffset, y1 - smallRectOffset, smallRectSize, smallRectSize);
            G2.setPaint(Color.black);
            G2.drawRect(x1 - smallRectOffset, y1 - smallRectOffset, smallRectSize, smallRectSize);
            G2.setPaint(Color.white);
            G2.fillRect(x2 - (smallRectSize - smallRectOffset) + 1, y1 - smallRectOffset, smallRectSize, smallRectSize);
            G2.setPaint(Color.black);
            G2.drawRect(x2 - (smallRectSize - smallRectOffset) + 1, y1 - smallRectOffset, smallRectSize, smallRectSize);
            G2.setPaint(Color.white);
            G2.fillRect(x2 - (smallRectSize - smallRectOffset) + 1, y2 - (smallRectSize - smallRectOffset) + 1, smallRectSize, smallRectSize);
            G2.setPaint(Color.black);
            G2.drawRect(x2 - (smallRectSize - smallRectOffset) + 1, y2 - (smallRectSize - smallRectOffset) + 1, smallRectSize, smallRectSize);
            G2.setPaint(Color.white);
            G2.fillRect(x1 - smallRectOffset, y2 - (smallRectSize - smallRectOffset) + 1, smallRectSize, smallRectSize);
            G2.setPaint(Color.black);
            G2.drawRect(x1 - smallRectOffset, y2 - (smallRectSize - smallRectOffset) + 1, smallRectSize, smallRectSize);
            int centerX = Width / 2 + smallRectSize / 2;
            int centerY = Height / 2 + smallRectSize / 2;
            G2.setPaint(Color.white);
            G2.fillRect(x1 + centerX - smallRectOffset, y1 - smallRectOffset, smallRectSize, smallRectSize);
            G2.setPaint(Color.black);
            G2.drawRect(x1 + centerX - smallRectOffset, y1 - smallRectOffset, smallRectSize, smallRectSize);
            G2.setPaint(Color.white);
            G2.fillRect(x2 - (smallRectSize - smallRectOffset) + 1, y1 + centerY - smallRectOffset, smallRectSize, smallRectSize);
            G2.setPaint(Color.black);
            G2.drawRect(x2 - (smallRectSize - smallRectOffset) + 1, y1 + centerY - smallRectOffset, smallRectSize, smallRectSize);
            G2.setPaint(Color.white);
            G2.fillRect(x1 + centerX - smallRectOffset, y2 - (smallRectSize - smallRectOffset) + 1, smallRectSize, smallRectSize);
            G2.setPaint(Color.black);
            G2.drawRect(x1 + centerX - smallRectOffset, y2 - (smallRectSize - smallRectOffset) + 1, smallRectSize, smallRectSize);
            G2.setPaint(Color.white);
            G2.fillRect(x1 - smallRectOffset, y1 + centerY - smallRectOffset, smallRectSize, smallRectSize);
            G2.setPaint(Color.black);
            G2.drawRect(x1 - smallRectOffset, y1 + centerY - smallRectOffset, smallRectSize, smallRectSize);
        }
    }

    public void AddLayer(Image LayerImage, int x, int y, String Title) {
        this.Layers[this.LayersCount++] = new Layer(LayerImage, x, y, Title);
    }

    public void AddLayer(Image LayerImage, int x, int y, String Title, boolean enabled) {
        this.Layers[this.LayersCount++] = new Layer(LayerImage, x, y, Title, enabled);
    }

    public void AddTextLayer(JLayerTextPane LayerTextPane, int x, int y, String Title) {
        this.Layers[this.LayersCount++] = new Layer(LayerTextPane, x, y, Title);
        this.SetSelectedLayer(this.LayersCount - 1);
    }

    public void AddScaledTextLayer(ScaledTextPane scaledTextPane, int x, int y, String Title) {
        this.Layers[this.LayersCount++] = new Layer(scaledTextPane, x, y, Title);
        this.SetSelectedLayer(this.LayersCount - 1);
    }

    public void AddShapeLayer(int ShapeType, int x, int y, int ShapeWidth, int ShapeHeight, int LineType, int lineWidth, Color LineColor, Color FillColor, int DashType, int CornerRadius, boolean Fillshape, String Title) {
        this.Layers[this.LayersCount++] = new Layer(ShapeType, x, y, ShapeWidth, ShapeHeight, LineType, lineWidth, LineColor, FillColor, DashType, CornerRadius, Fillshape, Title);
        this.SetSelectedLayer(this.LayersCount - 1);
    }

    public int GetLayersCount() {
        return this.LayersCount;
    }

    public String[] GetTitles() {
        String[] Titles = new String[this.LayersCount];
        int i = 0;
        while (i <= this.LayersCount - 1) {
            Titles[this.LayersCount - 1 - i] = this.Layers[i].GetTitle();
            ++i;
        }
        return Titles;
    }

    public void MoveToFront(int Index) {
        int currentIndex = Index;
        if (Index >= 0 && Index <= this.LayersCount) {
            while (currentIndex < this.LayersCount) {
                this.MoveUp(currentIndex);
                ++currentIndex;
            }
            if (currentIndex >= 0 && currentIndex < this.LayersCount) {
                this.SetSelectedLayer(currentIndex);
            }
        }
    }

    public void MoveToBack(int Index) {
        int currentIndex = Index;
        if (Index >= 0 && Index <= this.LayersCount && this.LayersCount > Index) {
            while (currentIndex > 0) {
                this.MoveDown(currentIndex);
                --currentIndex;
            }
            if (currentIndex >= 0 && currentIndex < this.LayersCount) {
                this.SetSelectedLayer(currentIndex);
            }
        }
    }

    public void MoveUp(int Index) {
        if (this.LayersCount > 1 && Index < this.LayersCount - 1 && Index >= 0) {
            Layer tmp = this.Layers[Index];
            this.Layers[Index] = this.Layers[Index + 1];
            this.Layers[Index + 1] = tmp;
            this.SetSelectedLayer(Index + 1);
        }
    }

    public int MoveDown(int Index) {
        if (this.LayersCount > 1 && Index > 0 && Index <= this.LayersCount - 1) {
            Layer tmp = this.Layers[Index];
            this.Layers[Index] = this.Layers[Index - 1];
            this.Layers[Index - 1] = tmp;
            this.SetSelectedLayer(Index - 1);
        }
        return Index - 1;
    }

    public void Delete(int Index) {
        int nextEnabledLayer = -1;
        if (this.LayersCount == 1 && Index == 0) {
            this.Layers[0] = null;
            this.LayersCount = 0;
            this.SetSelectedLayer(-1);
        } else if (this.LayersCount > 1 && Index >= 0 && Index <= this.LayersCount - 1) {
            int i = Index;
            while (i <= this.LayersCount - 2) {
                this.Layers[i] = this.Layers[i + 1];
                ++i;
            }
            this.Layers[--this.LayersCount] = null;
            nextEnabledLayer = this.LayersCount - 1;
            while (!this.Layers[nextEnabledLayer].Enabled && nextEnabledLayer > 0) {
                --nextEnabledLayer;
            }
            if (nextEnabledLayer == 0 && !this.Layers[nextEnabledLayer].Enabled) {
                nextEnabledLayer = -1;
            }
            if (Index == this.LayersCount) {
                this.SetSelectedLayer(nextEnabledLayer);
            } else {
                this.SetSelectedLayer(Index);
            }
        }
    }

    public void DeleteAll() {
        int i = 0;
        while (i <= this.LayersCount - 1) {
            this.Delete(i);
            ++i;
        }
        this.LayersCount = 0;
        this.ImageWidth = 100;
        this.ImageHeight = 100;
        this.SetSelectedLayer(-1);
        this.Background = new Color(0, 0, 0, 0);
    }

    public void CropAll(Rectangle CropRect) {
        boolean layerSkipped = false;
        int i = 0;
        while (i <= this.LayersCount - 1) {
            if (this.Layers[i].Enabled) {
                if (!this.Layers[i].CropLayer(CropRect)) {
                    this.Delete(i--);
                }
            } else {
                layerSkipped = true;
            }
            ++i;
        }
        if (!layerSkipped) {
            this.ImageWidth = (int)CropRect.getWidth();
            this.ImageHeight = (int)CropRect.getHeight();
        }
    }

    public void ResizeAll(double ScaleX, double ScaleY, int InterpolationType) {
        int i = 0;
        while (i <= this.LayersCount - 1) {
            this.Layers[i].Resize(ScaleX, ScaleY, InterpolationType, false);
            ++i;
        }
    }

    public void RotateAll(int RotateAngle, int RotateDirection) {
        double Alfa = RotateDirection == 2 ? Math.toRadians(RotateAngle) : Math.toRadians(-RotateAngle);
        int NewImageWidth = (int)(Math.abs((double)this.ImageHeight * Math.sin(Alfa)) + Math.abs((double)this.ImageWidth * Math.cos(Alfa)));
        int NewImageHeight = (int)(Math.abs((double)this.ImageHeight * Math.cos(Alfa)) + Math.abs((double)this.ImageWidth * Math.sin(Alfa)));
        int i = 0;
        while (i <= this.LayersCount - 1) {
            this.Layers[i].RotateIntoCanvas(RotateAngle, RotateDirection, this.ImageWidth, this.ImageHeight, NewImageWidth, NewImageHeight);
            ++i;
        }
        this.ImageWidth = NewImageWidth;
        this.ImageHeight = NewImageHeight;
    }

    public void ResizeCanvas(int NewCanvasWidth, int NewCanvasHeight, int ChangeX, int ChangeY) {
        int i = 0;
        while (i <= this.LayersCount - 1) {
            Point OldPoint = this.Layers[i].GetPoint();
            Point NewPoint = new Point((int)OldPoint.getX() + ChangeX, (int)OldPoint.getY() + ChangeY);
            this.Layers[i].SetPoint(NewPoint);
            ++i;
        }
        this.ImageHeight = NewCanvasHeight;
        this.ImageWidth = NewCanvasWidth;
    }

    public void FitCanvas() {
        if (this.LayersCount > 0) {
            int MaxX = Integer.MIN_VALUE;
            int MinX = Integer.MAX_VALUE;
            int MaxY = Integer.MIN_VALUE;
            int MinY = Integer.MAX_VALUE;
            int i = 0;
            while (i <= this.LayersCount - 1) {
                if ((double)MaxX < this.Layers[i].GetPoint().getX() + (double)this.Layers[i].Width - 1.0) {
                    MaxX = (int)this.Layers[i].GetPoint().getX() + this.Layers[i].Width - 1;
                }
                if ((double)MaxY < this.Layers[i].GetPoint().getY() + (double)this.Layers[i].Height - 1.0) {
                    MaxY = (int)this.Layers[i].GetPoint().getY() + this.Layers[i].Height - 1;
                }
                if ((double)MinX > this.Layers[i].GetPoint().getX()) {
                    MinX = (int)this.Layers[i].GetPoint().getX();
                }
                if ((double)MinY > this.Layers[i].GetPoint().getY()) {
                    MinY = (int)this.Layers[i].GetPoint().getY();
                }
                ++i;
            }
            this.ResizeCanvas(MaxX - MinX + 1, MaxY - MinY + 1, -MinX, -MinY);
        }
    }

    public void SetImageHeight(int Height) {
        this.ImageHeight = Height;
    }

    public void SetImageWidth(int Width) {
        this.ImageWidth = Width;
    }

    public int GetImageHeight() {
        return this.ImageHeight;
    }

    public int GetImageWidth() {
        return this.ImageWidth;
    }

    public int GetSelectedLayer() {
        return this.SelectedLayer;
    }

    public void SetSelectedLayer(int selectedLayer) {
        if (selectedLayer >= 0) {
            if (this.Layers[selectedLayer].Enabled) {
                this.SelectedLayer = selectedLayer;
                this.ChangeSelectedLayer();
            } else {
                this.SelectedLayer = -1;
                this.ChangeSelectedLayer();
            }
        } else {
            this.SelectedLayer = selectedLayer;
            this.ChangeSelectedLayer();
        }
    }

    public void setBackground(Color background) {
        this.Background = background;
    }

    private void ChangeSelectedLayer() {
        if (this.ChangeSelectedLayerListener != null) {
            this.ChangeSelectedLayerListener.actionPerformed(new ActionEvent(this, 2000, "Change"));
        }
    }

    public void addChangeSelectedLayerActionListener(ActionListener listener) {
        this.ChangeSelectedLayerListener = AWTEventMulticaster.add(this.ChangeSelectedLayerListener, listener);
    }

    public void removeChangeSelectedLayerActionListener(ActionListener listener) {
        this.ChangeSelectedLayerListener = AWTEventMulticaster.remove(this.ChangeSelectedLayerListener, listener);
    }

    private void jbInit() throws Exception {
    }
}

