/*
 * Decompiled with CFR 0.152.
 */
package netimager;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import javax.swing.JComponent;
import netimager.Layer;

public class ManualSelection_Area
extends JComponent {
    public static final int COLOR_SELECTION = 1;
    public float ImageZoom;
    int CurrentLine;
    int LineCount;
    Point CurrentPoint;
    Point LastPoint;
    int[] Mask;
    int AreaWidth;
    int AreaHeight;
    Component Parent;
    public Layer SelectedLayer;
    public BufferedImage b_image;
    Line[] Lines = new Line[500];

    public BufferedImage resize(BufferedImage image) {
        int Width = image.getWidth();
        int Height = image.getHeight();
        BufferedImage bi = new BufferedImage(Width, Height, 2);
        Graphics2D graphics = bi.createGraphics();
        graphics.drawImage((Image)image, 0, 0, null);
        AffineTransform AffineTrans = new AffineTransform();
        AffineTrans.scale(this.ImageZoom, this.ImageZoom);
        Width = (int)((float)Width * this.ImageZoom);
        Height = (int)((float)Height * this.ImageZoom);
        BufferedImage b_image = new BufferedImage(Width, Height, 2);
        AffineTransformOp biop = new AffineTransformOp(AffineTrans, 2);
        biop.filter(bi, b_image);
        return b_image;
    }

    public BufferedImage div(BufferedImage image) {
        int Width = image.getWidth();
        int Height = image.getHeight();
        float RevImZoom = 1.0f / this.ImageZoom;
        BufferedImage bi = new BufferedImage(Width, Height, 2);
        Graphics2D graphics = bi.createGraphics();
        graphics.drawImage((Image)image, 0, 0, null);
        AffineTransform AffineTrans = new AffineTransform();
        AffineTrans.scale(RevImZoom, RevImZoom);
        Width = (int)((float)Width * this.ImageZoom);
        Height = (int)((float)Height * this.ImageZoom);
        BufferedImage bimage = new BufferedImage(Width, Height, 2);
        AffineTransformOp biop = new AffineTransformOp(AffineTrans, 2);
        biop.filter(bi, bimage);
        return bimage;
    }

    public ManualSelection_Area(int StartX, int StartY, int Width, int Height, float Scale) {
        this.ImageZoom = Scale;
        this.setOpaque(false);
        int newStartX = (int)((float)StartX * this.ImageZoom);
        int newStartY = (int)((float)StartY * this.ImageZoom);
        int newWidth = (int)((float)Width * this.ImageZoom);
        int newHeight = (int)((float)Height * this.ImageZoom);
        this.addMouseMotionListener(new MouseMotionHandler());
        this.addMouseListener(new MouseHandler());
        this.setBounds(newStartX, newStartY, newWidth, newHeight);
        this.LastPoint = new Point(-1, -1);
        this.CurrentLine = 0;
        this.LineCount = 0;
        this.Parent = this.getParent();
    }

    public ManualSelection_Area(Layer selectedLayer, float Scale) {
        this.ImageZoom = Scale;
        this.setOpaque(false);
        int boundUpX = (int)((float)selectedLayer.LayersX * this.ImageZoom);
        int boundDX = (int)((float)selectedLayer.LayersY * this.ImageZoom);
        int boundX = (int)((float)selectedLayer.Width * this.ImageZoom);
        int boundY = (int)((float)selectedLayer.Height * this.ImageZoom);
        this.setBounds(boundUpX, boundDX, boundX + 1, boundY + 1);
        this.addMouseMotionListener(new MouseMotionHandler());
        this.addMouseListener(new MouseHandler());
        this.LastPoint = new Point(-1, -1);
        this.CurrentLine = 0;
        this.LineCount = 0;
        this.Parent = this.getParent();
        this.SelectedLayer = selectedLayer;
    }

    public void paintComponent(Graphics g) {
        Graphics2D G2 = (Graphics2D)g;
        int i = 0;
        while (i <= this.LineCount - 1) {
            G2.setColor(new Color(0, 0, 0, 255));
            G2.drawLine((int)this.Lines[i].getPoint1().getX(), (int)this.Lines[i].getPoint1().getY(), (int)this.Lines[i].getPoint2().getX(), (int)this.Lines[i].getPoint2().getY());
            ++i;
        }
        if (this.LastPoint.getX() != -1.0) {
            G2.setColor(new Color(0, 0, 0, 255));
            G2.drawLine((int)this.LastPoint.getX(), (int)this.LastPoint.getY(), (int)this.CurrentPoint.getX(), (int)this.CurrentPoint.getY());
        }
    }

    private void CreateMasktSelection() {
        int j;
        int i;
        int Width = this.getWidth();
        int Height = this.getHeight();
        this.Mask = new int[Width * Height];
        BufferedImage BorderStorage = new BufferedImage(Width, Height, 2);
        Graphics2D G2 = BorderStorage.createGraphics();
        int i2 = 0;
        while (i2 <= this.LineCount - 1) {
            G2.setColor(new Color(0, 0, 0, 255));
            G2.drawLine((int)this.Lines[i2].getPoint1().getX(), (int)this.Lines[i2].getPoint1().getY(), (int)this.Lines[i2].getPoint2().getX(), (int)this.Lines[i2].getPoint2().getY());
            ++i2;
        }
        try {
            PixelGrabber Grabber = new PixelGrabber(BorderStorage, 0, 0, Width, Height, this.Mask, 0, Width);
            Grabber.grabPixels();
        }
        catch (InterruptedException Grabber) {
            // empty catch block
        }
        int TransparentPixel = 0;
        int NotSelectionColor = 1;
        int SelectionColor = 0;
        int i3 = 0;
        while (i3 <= Width - 1) {
            if (this.Mask[i3] == TransparentPixel) {
                this.Mask[i3] = NotSelectionColor;
            }
            if (this.Mask[(Height - 1) * Width + i3] == TransparentPixel) {
                this.Mask[(Height - 1) * Width + i3] = NotSelectionColor;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 <= Height - 1) {
            if (this.Mask[i3 * Width] == TransparentPixel) {
                this.Mask[i3 * Width] = NotSelectionColor;
            }
            if (this.Mask[(i3 + 1) * Width - 1] == TransparentPixel) {
                this.Mask[(i3 + 1) * Width - 1] = NotSelectionColor;
            }
            ++i3;
        }
        boolean Processing = true;
        while (Processing) {
            Processing = false;
            i = 0;
            while (i <= Height - 1) {
                j = 0;
                while (j <= Width - 1) {
                    if (this.Mask[i * Width + j] == NotSelectionColor) {
                        if (i > 0 && this.Mask[(i - 1) * Width + j] == TransparentPixel) {
                            this.Mask[(i - 1) * Width + j] = NotSelectionColor;
                            Processing = true;
                        }
                        if (i < Height - 2 && this.Mask[(i + 1) * Width + j] == TransparentPixel) {
                            this.Mask[(i + 1) * Width + j] = NotSelectionColor;
                            Processing = true;
                        }
                        if (j < Width - 2 && this.Mask[i * Width + j + 1] == TransparentPixel) {
                            this.Mask[i * Width + j + 1] = NotSelectionColor;
                            Processing = true;
                        }
                        if (j > 0 && this.Mask[i * Width + j - 1] == TransparentPixel) {
                            this.Mask[i * Width + j - 1] = NotSelectionColor;
                            Processing = true;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        i = 0;
        while (i <= Height - 1) {
            j = 0;
            while (j <= Width - 1) {
                this.Mask[i * Width + j] = this.Mask[i * Width + j] == NotSelectionColor ? SelectionColor : NotSelectionColor;
                ++j;
            }
            ++i;
        }
        Canvas C = new Canvas();
        Image Img = C.createImage(new MemoryImageSource(Width, Height, this.Mask, 0, Width));
        G2.drawImage(Img, 0, 0, null);
    }

    public int[] getMask() {
        return this.Mask;
    }

    public int getAreaWidth() {
        return this.getWidth();
    }

    public int getAreaHeight() {
        return this.getHeight();
    }

    class Line {
        private Point Point1;
        private Point Point2;

        public Line(Point point1, Point point2) {
            this.Point1 = point1;
            this.Point2 = point2;
        }

        public Point getPoint1() {
            return this.Point1;
        }

        public Point getPoint2() {
            return this.Point2;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mousePressed(MouseEvent event) {
            if (ManualSelection_Area.this.LastPoint.getX() != -1.0) {
                Point point = new Point(event.getX(), event.getY());
                ManualSelection_Area.this.Lines[ManualSelection_Area.this.CurrentLine++] = new Line(new Point(ManualSelection_Area.this.LastPoint), new Point(event.getX(), event.getY()));
                ++ManualSelection_Area.this.LineCount;
            } else {
                ManualSelection_Area.this.CurrentLine = 0;
                ManualSelection_Area.this.LineCount = 0;
            }
            ManualSelection_Area.this.LastPoint = event.getPoint();
            ManualSelection_Area.this.CurrentPoint = event.getPoint();
            ManualSelection_Area.this.repaint();
        }

        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() >= 2 && ManualSelection_Area.this.LastPoint.getX() != -1.0) {
                ManualSelection_Area.this.Lines[ManualSelection_Area.this.CurrentLine] = new Line(new Point(ManualSelection_Area.this.LastPoint), new Point(ManualSelection_Area.this.Lines[0].getPoint1()));
                ++ManualSelection_Area.this.LineCount;
                ManualSelection_Area.this.LastPoint = new Point(-1, -1);
                ManualSelection_Area.this.CreateMasktSelection();
                ManualSelection_Area.this.repaint();
            }
        }
    }

    private class MouseMotionHandler
    extends MouseMotionAdapter {
        private MouseMotionHandler() {
        }

        public void mouseDragged(MouseEvent event) {
        }

        public void mouseMoved(MouseEvent event) {
            if (ManualSelection_Area.this.LastPoint.getX() != -1.0) {
                ManualSelection_Area.this.CurrentPoint = event.getPoint();
                ManualSelection_Area.this.repaint();
            }
        }
    }
}

