/*
 * Decompiled with CFR 0.152.
 */
package netimager;

import com.sun.jimi.core.Jimi;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import netimager.ExtensionFileFilter;
import netimager.Layers_Repository;
import netimager.Main_Panel;
import netimager.editor_applet;
import sun.misc.BASE64Decoder;

public class OpenProject_Dialog
extends JDialog {
    JPanel contentPane = new JPanel();
    public Layers_Repository OpenLayers;
    JComboBox jComboBox_Formats = new JComboBox<String>(new String[]{"GIF", "JPG", "BMP", "PNG", "ELIF"});
    JButton jButton_Cancel = new JButton();
    JButton jButton_OK = new JButton();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JTextField jTextField_ImagePath = new JTextField();
    boolean OK;
    Main_Panel MainPanel;
    boolean autoDetectMimeType = false;

    public OpenProject_Dialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public OpenProject_Dialog() {
        this((Frame)null, "", false);
    }

    void jbInit() throws Exception {
        this.contentPane.setLayout(null);
        this.contentPane.setMinimumSize(new Dimension(350, 150));
        this.contentPane.setPreferredSize(new Dimension(350, 150));
        this.jComboBox_Formats.setBounds(new Rectangle(135, 14, 188, 21));
        this.jButton_Cancel.setBounds(new Rectangle(145, 95, 86, 27));
        this.jButton_Cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OpenProject_Dialog.this.jButton_Cancel_actionPerformed(e);
            }
        });
        this.jButton_Cancel.setText("Cancel");
        this.jButton_OK.setBounds(new Rectangle(241, 94, 79, 27));
        this.jButton_OK.setText("OK");
        this.jButton_OK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OpenProject_Dialog.this.jButton_OK_actionPerformed(e);
            }
        });
        this.jLabel3.setText("Open as:");
        this.jLabel3.setBounds(new Rectangle(16, 55, 116, 17));
        this.jLabel3.setHorizontalAlignment(2);
        this.jLabel2.setBounds(new Rectangle(17, 16, 61, 17));
        this.jLabel2.setToolTipText("");
        this.jLabel2.setText("Format:");
        this.jTextField_ImagePath.setHorizontalAlignment(2);
        this.jTextField_ImagePath.setBounds(new Rectangle(136, 52, 183, 21));
        this.jTextField_ImagePath.setText("c:/load.jpg");
        this.jTextField_ImagePath.setPreferredSize(new Dimension(183, 21));
        this.jTextField_ImagePath.setMinimumSize(new Dimension(20, 21));
        this.getContentPane().add(this.contentPane);
        this.contentPane.add((Component)this.jComboBox_Formats, null);
        this.contentPane.add((Component)this.jLabel2, null);
        this.contentPane.add((Component)this.jTextField_ImagePath, null);
        this.contentPane.add((Component)this.jLabel3, null);
        this.contentPane.add((Component)this.jButton_Cancel, null);
        this.contentPane.add((Component)this.jButton_OK, null);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException exc) {
            System.err.println("Unsupported Look And Feel");
        }
        SwingUtilities.updateComponentTreeUI(this.contentPane);
    }

    public boolean ShowDialog(Layers_Repository Layers, Main_Panel mainPanel, editor_applet ParentApplet) {
        this.MainPanel = mainPanel;
        this.OpenLayers = Layers;
        this.OK = false;
        JFileChooser PathChooser = new JFileChooser();
        PathChooser.setSize(200, 200);
        PathChooser.setAcceptAllFileFilterUsed(false);
        ExtensionFileFilter jpgFilter = new ExtensionFileFilter();
        jpgFilter.addExtension(".jpg");
        jpgFilter.addExtension(".jpeg");
        jpgFilter.setDescription("JPEG (*.jpg, *.jpeg)");
        ExtensionFileFilter gifFilter = new ExtensionFileFilter();
        gifFilter.addExtension(".gif");
        gifFilter.setDescription("GIF (*.gif)");
        ExtensionFileFilter pngFilter = new ExtensionFileFilter();
        pngFilter.addExtension(".png");
        pngFilter.setDescription("PNG (*.png)");
        ExtensionFileFilter bmpFilter = new ExtensionFileFilter();
        bmpFilter.addExtension(".bmp");
        bmpFilter.setDescription("BMP (*.bmp)");
        ExtensionFileFilter jedFilter = new ExtensionFileFilter();
        jedFilter.addExtension(".elif");
        jedFilter.setDescription("ELIF (*.elif)");
        ExtensionFileFilter allFormatsFilter = new ExtensionFileFilter();
        allFormatsFilter.addExtension(".gif");
        allFormatsFilter.addExtension(".jpg");
        allFormatsFilter.addExtension(".jpeg");
        allFormatsFilter.addExtension(".bmp");
        allFormatsFilter.addExtension(".elif");
        allFormatsFilter.addExtension(".png");
        allFormatsFilter.setDescription("All image formats");
        PathChooser.addChoosableFileFilter(bmpFilter);
        PathChooser.addChoosableFileFilter(pngFilter);
        PathChooser.addChoosableFileFilter(gifFilter);
        PathChooser.addChoosableFileFilter(jpgFilter);
        PathChooser.addChoosableFileFilter(jedFilter);
        PathChooser.addChoosableFileFilter(allFormatsFilter);
        int returnVal = PathChooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.ReadImage(PathChooser.getSelectedFile().getAbsolutePath());
            if (this.OK) {
                ParentApplet.FileName = PathChooser.getSelectedFile().getAbsolutePath();
            }
        }
        return this.OK;
    }

    void jButton_Cancel_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    public void OnImageOpen() {
        try {
            if (this.MainPanel.fitToWindowOnload) {
                this.MainPanel.runFitToWindow();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void ReadImage(String FileName) {
        try {
            File inFile = new File(FileName);
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(inFile));
            this.OpenLayers = (Layers_Repository)in.readObject();
            in.close();
            this.OK = true;
            this.OpenLayers.addChangeSelectedLayerActionListener(this.MainPanel.ChangeSelectedLayerActionListener);
        }
        catch (Exception inFile) {
            // empty catch block
        }
        if (!this.OK) {
            try {
                Image Img = Jimi.getImage(FileName);
                int origImageWidth = Img.getWidth(null);
                int origImageHeight = Img.getHeight(null);
                int newImageHeight = Img.getHeight(null);
                int newImageWidth = Img.getWidth(null);
                boolean scaleOnLoad = false;
                if (Img.getWidth(null) > 1000) {
                    newImageWidth = 1000;
                    newImageHeight = (int)((double)Img.getHeight(null) * ((double)newImageWidth / (double)Img.getWidth(null)));
                    scaleOnLoad = true;
                }
                int tmpImageHeight = newImageHeight;
                int tmpImageWidth = newImageWidth;
                if (tmpImageHeight > 1000) {
                    newImageHeight = 1000;
                    newImageWidth = (int)((double)tmpImageWidth * ((double)newImageHeight / (double)tmpImageHeight));
                    scaleOnLoad = true;
                }
                if (scaleOnLoad && this.MainPanel.reduceLargeImages) {
                    Img = Img.getScaledInstance(newImageWidth, newImageHeight, 2);
                }
                MediaTracker tracker = new MediaTracker(this);
                tracker.addImage(Img, 1);
                tracker.waitForAll();
                if (Img.getWidth(null) == -1) {
                    throw new Exception();
                }
                this.OpenLayers.DeleteAll();
                this.OpenLayers.AddLayer(Img, 0, 0, "Image " + FileName);
                this.OpenLayers.SetImageWidth(Img.getWidth(null));
                this.OpenLayers.SetImageHeight(Img.getHeight(null));
                this.OnImageOpen();
                this.OK = true;
            }
            catch (Exception ee) {
                ee.printStackTrace();
                JOptionPane.showConfirmDialog(this, "Can't read file " + FileName, "Error", -1, 0);
            }
        }
    }

    public Layers_Repository JsReadImage(String FileName, Layers_Repository OpenLayers, Main_Panel MainPanel) {
        Layers_Repository result = null;
        try {
            File inFile = new File(FileName);
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(inFile));
            OpenLayers = (Layers_Repository)in.readObject();
            in.close();
            this.OK = true;
            OpenLayers.addChangeSelectedLayerActionListener(MainPanel.ChangeSelectedLayerActionListener);
            result = OpenLayers;
        }
        catch (Exception inFile) {
            // empty catch block
        }
        if (!this.OK) {
            try {
                Image Img = Jimi.getImage(FileName);
                MediaTracker tracker = new MediaTracker(this);
                tracker.addImage(Img, 1);
                tracker.waitForAll();
                if (Img.getWidth(null) == -1) {
                    throw new Exception();
                }
                OpenLayers.DeleteAll();
                OpenLayers.AddLayer(Img, 0, 0, "Image " + FileName);
                OpenLayers.SetImageWidth(Img.getWidth(null));
                OpenLayers.SetImageHeight(Img.getHeight(null));
                result = OpenLayers;
                this.OnImageOpen();
                this.OK = true;
            }
            catch (Exception ee) {
                ee.printStackTrace();
                JOptionPane.showConfirmDialog(this, "Can't read file " + FileName, "Error", -1, 0);
            }
        }
        return result;
    }

    public Layers_Repository JsReadURL(String FileName, Layers_Repository OpenLayers, Main_Panel MainPanel, String LayerTitle, boolean enabled) {
        if (LayerTitle == "") {
            LayerTitle = FileName;
        }
        Layers_Repository result = null;
        try {
            File inFile = new File(FileName);
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(inFile));
            OpenLayers = (Layers_Repository)in.readObject();
            in.close();
            this.OK = true;
            OpenLayers.addChangeSelectedLayerActionListener(MainPanel.ChangeSelectedLayerActionListener);
            result = OpenLayers;
        }
        catch (Exception inFile) {
            // empty catch block
        }
        if (!this.OK) {
            String type = "";
            try {
                Image Img;
                URL ImageURL = new URL(FileName);
                if (this.autoDetectMimeType) {
                    InputStream openStream = ImageURL.openStream();
                    byte[] signature = new byte[8];
                    openStream.read(signature);
                    openStream.close();
                    byte[] pngIdBytes = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
                    byte[] bmpIdBytes = new byte[]{66, 77};
                    byte[] gifIdBytes = new byte[]{47, 49, 46};
                    type = signature[1] == pngIdBytes[1] && signature[2] == pngIdBytes[2] && signature[3] == pngIdBytes[3] ? "image/png" : (signature[0] == bmpIdBytes[0] && signature[1] == bmpIdBytes[1] ? "image/bmp" : (signature[0] == gifIdBytes[0] && signature[1] == gifIdBytes[1] && signature[2] == gifIdBytes[2] ? "image/gif" : "image/jpeg"));
                    Img = Jimi.getImage(ImageURL, type);
                } else {
                    Img = Jimi.getImage(ImageURL);
                }
                MediaTracker tracker = new MediaTracker(this);
                tracker.addImage(Img, 1);
                tracker.waitForAll();
                if (Img.getWidth(null) == -1) {
                    throw new Exception();
                }
                OpenLayers.DeleteAll();
                OpenLayers.AddLayer(Img, 0, 0, LayerTitle, enabled);
                OpenLayers.SetImageWidth(Img.getWidth(null));
                OpenLayers.SetImageHeight(Img.getHeight(null));
                result = OpenLayers;
                this.OK = true;
                this.OnImageOpen();
            }
            catch (Exception ee) {
                ee.printStackTrace();
                JOptionPane.showConfirmDialog(this, "Unable to read image from URL: " + FileName, "Error", -1, 0);
            }
        }
        this.OK = false;
        return result;
    }

    public Layers_Repository loadBase64(String Data, String FileName, Layers_Repository OpenLayers, Main_Panel MainPanel, String LayerTitle, boolean enabled) {
        Layers_Repository result;
        block10: {
            if (LayerTitle == "") {
                LayerTitle = FileName;
            }
            result = null;
            try {
                ByteArrayInputStream ByteStream2;
                byte[] buf = new BASE64Decoder().decodeBuffer(Data);
                try {
                    ByteStream2 = new ByteArrayInputStream(buf);
                    ObjectInputStream in = new ObjectInputStream(ByteStream2);
                    OpenLayers = (Layers_Repository)in.readObject();
                    in.close();
                    result = OpenLayers;
                }
                catch (Exception ByteStream2) {
                    // empty catch block
                }
                if (result != null) break block10;
                try {
                    ByteStream2 = new ByteArrayInputStream(buf);
                    Image Img = Jimi.getImage(ByteStream2);
                    MediaTracker tracker = new MediaTracker(this);
                    tracker.addImage(Img, 1);
                    try {
                        tracker.waitForAll();
                        OpenLayers.DeleteAll();
                        OpenLayers.AddLayer(Img, 0, 0, LayerTitle, enabled);
                        OpenLayers.SetImageWidth(Img.getWidth(null));
                        OpenLayers.SetImageHeight(Img.getHeight(null));
                        result = OpenLayers;
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                }
                catch (Exception Ex) {
                    Ex.printStackTrace();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        if (result != null) {
            result.addChangeSelectedLayerActionListener(MainPanel.ChangeSelectedLayerActionListener);
            this.OnImageOpen();
        }
        return result;
    }

    void jButton_OK_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }
}

