/*
 * Decompiled with CFR 0.152.
 */
package netimager;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiWriter;
import com.sun.jimi.core.encoder.png.PNGEncoder;
import com.sun.jimi.core.options.JPGOptions;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import netimager.Base64Encoder;
import netimager.ExtensionFileFilter;
import netimager.GIFEncoder;
import netimager.IndexImage;
import netimager.JPG_Options_Dialog;
import netimager.Layers_Repository;

public class SaveImg_Dialog
extends JDialog {
    Layers_Repository SaveLayers;
    int SaveImageWidth;
    int SaveImageHeight;
    int saveJpegQuality = 80;

    public SaveImg_Dialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public SaveImg_Dialog() {
        this((Frame)null, "", false);
    }

    void jbInit() throws Exception {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException exc) {
            System.err.println("Unsupported Look And Feel");
        }
    }

    public boolean ShowDialog(Layers_Repository Layers) {
        this.SaveLayers = Layers;
        boolean OK = true;
        JFileChooser PathChooser = new JFileChooser();
        PathChooser.setSize(200, 200);
        PathChooser.setAcceptAllFileFilterUsed(false);
        ExtensionFileFilter jpgFilter = new ExtensionFileFilter();
        jpgFilter.addExtension(".jpg");
        jpgFilter.addExtension(".jpeg");
        jpgFilter.setDescription("JPEG (*.jpg, *.jpeg)");
        ExtensionFileFilter gifFilter = new ExtensionFileFilter();
        gifFilter.addExtension(".gif");
        gifFilter.setDescription("GIF (*.gif)");
        ExtensionFileFilter pngFilter = new ExtensionFileFilter();
        pngFilter.addExtension(".png");
        pngFilter.setDescription("PNG (*.png)");
        ExtensionFileFilter bmpFilter = new ExtensionFileFilter();
        bmpFilter.addExtension(".bmp");
        bmpFilter.setDescription("BMP (*.bmp)");
        ExtensionFileFilter jedFilter = new ExtensionFileFilter();
        jedFilter.addExtension(".elif");
        jedFilter.setDescription("ELIF (*.elif)");
        PathChooser.addChoosableFileFilter(bmpFilter);
        PathChooser.addChoosableFileFilter(pngFilter);
        PathChooser.addChoosableFileFilter(gifFilter);
        PathChooser.addChoosableFileFilter(jedFilter);
        PathChooser.addChoosableFileFilter(jpgFilter);
        int returnVal = 1;
        boolean confirm = false;
        while (!confirm) {
            int selection;
            confirm = true;
            returnVal = PathChooser.showSaveDialog(this);
            if (returnVal != 0 || !PathChooser.getSelectedFile().exists() || (selection = JOptionPane.showConfirmDialog(this, "File exists. Do you want to replace it?", "Warning", 2, 2)) == 0) continue;
            confirm = false;
        }
        if (returnVal == 0) {
            String FileName = PathChooser.getSelectedFile().getAbsolutePath();
            String FormatTypeName = PathChooser.getFileFilter().getDescription();
            int FormatType = 0;
            if (FormatTypeName == "JPEG (*.jpg, *.jpeg)") {
                FormatType = 0;
            }
            if (FormatTypeName == "BMP (*.bmp)") {
                FormatType = 1;
            }
            if (FormatTypeName == "PNG (*.png)") {
                FormatType = 2;
            }
            if (FormatTypeName == "GIF (*.gif)") {
                FormatType = 3;
            }
            if (FormatTypeName == "ELIF (*.elif)") {
                FormatType = 4;
            }
            String FileNameLowerCase = FileName.toLowerCase();
            switch (FormatType) {
                case 0: {
                    if (FileNameLowerCase.endsWith(".jpg") || FileNameLowerCase.endsWith(".jpeg")) break;
                    FileName = String.valueOf(FileName) + ".jpg";
                    break;
                }
                case 1: {
                    if (FileNameLowerCase.endsWith(".bmp")) break;
                    FileName = String.valueOf(FileName) + ".bmp";
                    break;
                }
                case 2: {
                    if (FileNameLowerCase.endsWith(".png")) break;
                    FileName = String.valueOf(FileName) + ".png";
                    break;
                }
                case 3: {
                    if (FileNameLowerCase.endsWith(".gif")) break;
                    FileName = String.valueOf(FileName) + ".gif";
                    break;
                }
                case 4: {
                    if (FileNameLowerCase.endsWith(".elif")) break;
                    FileName = String.valueOf(FileName) + ".elif";
                }
            }
            int jpgQuality = this.saveJpegQuality;
            if (FormatType == 0) {
                JPG_Options_Dialog Jpg_Options_Dialog = new JPG_Options_Dialog(null, "JPEG Options", true);
                OK = Jpg_Options_Dialog.ShowDialog();
                if (OK) {
                    jpgQuality = Jpg_Options_Dialog.jSlider_Quality.getValue();
                }
                Jpg_Options_Dialog.dispose();
            }
            if (OK) {
                this.SaveImage(FormatType, jpgQuality, FileName, this.SaveLayers);
            }
        }
        return OK;
    }

    boolean SaveImage(int FormatType, int jpgQuality, String FileName, Layers_Repository SaveLayers) {
        BufferedImage bi;
        this.SaveImageWidth = SaveLayers.ImageWidth;
        this.SaveImageHeight = SaveLayers.ImageHeight;
        BufferedImage srcImage = new BufferedImage(this.SaveImageWidth, this.SaveImageHeight, 2);
        Graphics2D graphics = srcImage.createGraphics();
        Graphics2D G_2 = srcImage.createGraphics();
        if (FormatType != 3 && FormatType != 2) {
            graphics.setColor(new Color(255, 255, 255));
            graphics.fillRect(0, 0, this.SaveImageWidth, this.SaveImageHeight);
        } else if (FormatType == 2) {
            G_2.setColor(new Color(0, 0, 0, 0));
            G_2.fillRect(0, 0, this.SaveImageWidth, this.SaveImageHeight);
        }
        try {
            if (FormatType == 2) {
                SaveLayers.PaintAll(G_2, null, 1.0f, false, false);
            } else {
                SaveLayers.PaintAll(graphics, null, 1.0f, false, false);
            }
        }
        catch (Exception ee) {
            return false;
        }
        if (FormatType == 3) {
            new IndexImage();
            BufferedImage indexImage = IndexImage.getIndexedImage(srcImage, 255);
            IndexColorModel icm = (IndexColorModel)indexImage.getColorModel();
            byte[] reds = new byte[256];
            byte[] greens = new byte[256];
            byte[] blues = new byte[256];
            int i = 0;
            while (i <= icm.getMapSize()) {
                reds[i] = (byte)icm.getRed(i);
                greens[i] = (byte)icm.getGreen(i);
                blues[i] = (byte)icm.getBlue(i);
                ++i;
            }
            reds[255] = -1;
            greens[255] = -1;
            blues[255] = -1;
            IndexColorModel ticm = new IndexColorModel(8, 256, reds, greens, blues, 255);
            bi = new BufferedImage(this.SaveImageWidth, this.SaveImageHeight, 13, ticm);
            Graphics2D G2 = bi.createGraphics();
            G2.drawImage((Image)indexImage, 0, 0, null);
            WritableRaster indexImageRaster = bi.getRaster();
            WritableRaster srcImageRaster = srcImage.getRaster();
            int[] srcData = new int[4];
            int[] dstData = new int[]{255};
            int i2 = 0;
            while (i2 <= this.SaveImageHeight - 1) {
                int j = 0;
                while (j <= this.SaveImageWidth - 1) {
                    if ((srcData = srcImageRaster.getPixel(j, i2, srcData))[3] == 0) {
                        indexImageRaster.setPixel(j, i2, dstData);
                    }
                    ++j;
                }
                ++i2;
            }
        } else {
            bi = srcImage;
        }
        switch (FormatType) {
            case 0: {
                try {
                    JPGOptions options = new JPGOptions();
                    options.setQuality(jpgQuality);
                    JimiWriter writer = Jimi.createJimiWriter(".jpg");
                    writer.setSource(bi);
                    writer.setOptions(options);
                    writer.putImage(FileName);
                    break;
                }
                catch (JimiException je) {
                    return false;
                }
            }
            case 1: {
                try {
                    JimiWriter writer = Jimi.createJimiWriter(".bmp");
                    writer.setSource(bi);
                    writer.putImage(FileName);
                    break;
                }
                catch (JimiException je) {
                    return false;
                }
            }
            case 2: {
                try {
                    try {
                        FileOutputStream pngFile = null;
                        pngFile = new FileOutputStream(FileName);
                        PNGEncoder png1 = new PNGEncoder();
                        png1.setAlpha(true);
                        png1.encodeImage(Jimi.createRasterImage(((Image)bi).getSource()), pngFile);
                        pngFile.close();
                    }
                    catch (IOException pngFile) {}
                    break;
                }
                catch (JimiException je) {
                    return false;
                }
            }
            case 4: {
                OutputStream out;
                File outFile;
                try {
                    outFile = new File(FileName);
                    out = new ObjectOutputStream(new FileOutputStream(outFile));
                    ((ObjectOutputStream)out).writeObject(SaveLayers);
                    ((ObjectOutputStream)out).close();
                    break;
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    return false;
                }
            }
            case 3: {
                OutputStream out;
                File outFile;
                try {
                    outFile = new File(FileName);
                    out = new FileOutputStream(outFile);
                    GIFEncoder GifEncoder = new GIFEncoder(bi);
                    GifEncoder.write(out);
                    ((FileOutputStream)out).close();
                    break;
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    return false;
                }
            }
        }
        return true;
    }

    public String getBase64(String FileName, Layers_Repository SaveLayers, int thisJpegQuality) {
        this.saveJpegQuality = thisJpegQuality;
        String result = "";
        int FileType = (FileName = FileName.toLowerCase()).endsWith(".jpg") ? 0 : (FileName.endsWith(".jpeg") ? 0 : (FileName.endsWith(".bmp") ? 1 : (FileName.endsWith(".png") ? 2 : (FileName.endsWith(".gif") ? 3 : (FileName.endsWith(".elif") ? 4 : -1)))));
        if (FileType != -1) {
            BufferedImage bi;
            int SaveImageWidth = SaveLayers.GetImageWidth();
            int SaveImageHeight = SaveLayers.GetImageHeight();
            BufferedImage srcImage = new BufferedImage(SaveImageWidth, SaveImageHeight, 2);
            Graphics2D graphics = srcImage.createGraphics();
            Graphics2D G_2 = srcImage.createGraphics();
            if (FileType != 3 && FileType != 2) {
                graphics.setColor(new Color(255, 255, 255));
                graphics.fillRect(0, 0, SaveImageWidth, SaveImageHeight);
            } else if (FileType == 2) {
                G_2.setColor(new Color(0, 0, 0, 0));
                G_2.fillRect(0, 0, SaveImageWidth, SaveImageHeight);
            }
            try {
                if (FileType == 2) {
                    SaveLayers.PaintAll(G_2, null, 1.0f, false, false);
                } else {
                    SaveLayers.PaintAll(graphics, null, 1.0f, false, false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (FileType == 3) {
                new IndexImage();
                BufferedImage indexImage = IndexImage.getIndexedImage(srcImage, 255);
                IndexColorModel icm = (IndexColorModel)indexImage.getColorModel();
                byte[] reds = new byte[256];
                byte[] greens = new byte[256];
                byte[] blues = new byte[256];
                int i = 0;
                while (i <= icm.getMapSize()) {
                    reds[i] = (byte)icm.getRed(i);
                    greens[i] = (byte)icm.getGreen(i);
                    blues[i] = (byte)icm.getBlue(i);
                    ++i;
                }
                reds[255] = -1;
                greens[255] = -1;
                blues[255] = -1;
                IndexColorModel ticm = new IndexColorModel(8, 256, reds, greens, blues, 255);
                bi = new BufferedImage(SaveImageWidth, SaveImageHeight, 13, ticm);
                Graphics2D G2 = bi.createGraphics();
                G2.drawImage((Image)indexImage, 0, 0, null);
                WritableRaster indexImageRaster = bi.getRaster();
                WritableRaster srcImageRaster = srcImage.getRaster();
                int[] srcData = new int[4];
                int[] dstData = new int[]{255};
                int i2 = 0;
                while (i2 <= SaveImageHeight - 1) {
                    int j = 0;
                    while (j <= SaveImageWidth - 1) {
                        if ((srcData = srcImageRaster.getPixel(j, i2, srcData))[3] < 200) {
                            indexImageRaster.setPixel(j, i2, dstData);
                        }
                        ++j;
                    }
                    ++i2;
                }
            } else {
                bi = srcImage;
            }
            ByteArrayOutputStream ByteStream = new ByteArrayOutputStream();
            byte[] buf = new byte[1];
            switch (FileType) {
                case 0: {
                    try {
                        JPGOptions options = new JPGOptions();
                        options.setQuality(this.saveJpegQuality);
                        JimiWriter writer = Jimi.createJimiWriter(".jpg");
                        writer.setSource(bi);
                        writer.setOptions(options);
                        writer.putImage(ByteStream);
                        buf = ByteStream.toByteArray();
                    }
                    catch (JimiException options) {}
                    break;
                }
                case 1: {
                    try {
                        JimiWriter writer = Jimi.createJimiWriter(".bmp");
                        writer.setSource(bi);
                        writer.putImage(ByteStream);
                        buf = ByteStream.toByteArray();
                    }
                    catch (JimiException writer) {}
                    break;
                }
                case 2: {
                    try {
                        PNGEncoder png1 = new PNGEncoder();
                        png1.setAlpha(true);
                        png1.encodeImage(Jimi.createRasterImage(((Image)bi).getSource()), ByteStream);
                        buf = ByteStream.toByteArray();
                    }
                    catch (JimiException je) {
                        je.printStackTrace();
                    }
                    break;
                }
                case 4: {
                    try {
                        ObjectOutputStream out = new ObjectOutputStream(ByteStream);
                        out.writeObject(SaveLayers);
                        out.close();
                        buf = ByteStream.toByteArray();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    break;
                }
                case 3: {
                    try {
                        GIFEncoder GifEncoder = new GIFEncoder(bi);
                        GifEncoder.write(ByteStream);
                        buf = ByteStream.toByteArray();
                        break;
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
            if (buf.length != 1) {
                result = new String(new Base64Encoder(buf).processString().toByteArray());
            }
        }
        return result;
    }
}

