/*
 * Decompiled with CFR 0.152.
 */
package netimager;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.Position;

class ScaledView2
extends BoxView {
    public boolean toRaster;

    public ScaledView2(Element elem, int axis, boolean toRaster) {
        super(elem, axis);
        this.toRaster = toRaster;
    }

    public double getZoomFactor() {
        Double scale = (Double)this.getDocument().getProperty("ZOOM_FACTOR");
        if (scale != null) {
            return scale;
        }
        return 1.0;
    }

    public void paint(Graphics g, Shape allocation) {
        Graphics2D G2 = (Graphics2D)g;
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        double zoomFactor = this.getZoomFactor();
        AffineTransform old = G2.getTransform();
        G2.scale(zoomFactor, zoomFactor);
        super.paint(G2, allocation);
        G2.setTransform(old);
    }

    public float getMinimumSpan(int axis) {
        float f = super.getMinimumSpan(axis);
        f = (float)((double)f * this.getZoomFactor());
        return f;
    }

    public float getMaximumSpan(int axis) {
        float f = super.getMaximumSpan(axis);
        f = (float)((double)f * this.getZoomFactor());
        return f;
    }

    public float getPreferredSpan(int axis) {
        float f = super.getPreferredSpan(axis);
        if (this.getZoomFactor() > 1.0) {
            f = (float)((double)f * this.getZoomFactor());
        }
        return f;
    }

    protected void layout(int width, int height) {
        super.layout(new Double((double)width / this.getZoomFactor()).intValue(), new Double((double)height * this.getZoomFactor()).intValue());
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        double zoomFactor = this.getZoomFactor();
        Rectangle alloc = a.getBounds();
        Shape s = super.modelToView(pos, alloc, b);
        alloc = s.getBounds();
        alloc.x = (int)((double)alloc.x * zoomFactor);
        alloc.y = (int)((double)alloc.y * zoomFactor);
        alloc.width = (int)((double)alloc.width * zoomFactor);
        alloc.height = (int)((double)alloc.height * zoomFactor);
        return alloc;
    }

    public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
        double zoomFactor = this.getZoomFactor();
        Rectangle alloc = a.getBounds();
        x = (float)((double)x / zoomFactor);
        y = (float)((double)y / zoomFactor);
        alloc.x = (int)((double)alloc.x / zoomFactor);
        alloc.y = (int)((double)alloc.y / zoomFactor);
        alloc.width = (int)((double)alloc.width / zoomFactor);
        alloc.height = (int)((double)alloc.height / zoomFactor);
        return super.viewToModel(x, y, alloc, bias);
    }
}

