/*
 * Decompiled with CFR 0.152.
 */
package netimager;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import netimager.Layers_Repository;

public class SetTransparency_Dialog
extends JDialog {
    JPanel contentPane = new JPanel();
    JSlider jSlider_Transparency = new JSlider(1, 255, 255);
    JLabel jLabel1 = new JLabel();
    JButton jButton_Cancel = new JButton();
    JCheckBox jCheckBox_Preview = new JCheckBox();
    JButton jButton_OK = new JButton();
    boolean OK;
    Layers_Repository LayersForChange;
    Layers_Repository SrcLayers;
    JPanel ImagePanel;
    int SelectedLayer;

    public SetTransparency_Dialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public SetTransparency_Dialog() {
        this((Frame)null, "", false);
    }

    void jbInit() throws Exception {
        this.contentPane.setLayout(null);
        this.contentPane.setMinimumSize(new Dimension(270, 170));
        this.contentPane.setPreferredSize(new Dimension(270, 170));
        this.jSlider_Transparency.setMinimum(1);
        this.jSlider_Transparency.setBounds(new Rectangle(5, 32, 255, 24));
        this.jSlider_Transparency.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SetTransparency_Dialog.this.jSlider_Transparency_stateChanged(e);
            }
        });
        this.jLabel1.setText("Transparency:");
        this.jLabel1.setBounds(new Rectangle(9, 10, 142, 17));
        this.jButton_Cancel.setText("Cancel");
        this.jButton_Cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SetTransparency_Dialog.this.jButton_Cancel_actionPerformed(e);
            }
        });
        this.jButton_Cancel.setBounds(new Rectangle(171, 76, 86, 27));
        this.jCheckBox_Preview.setSelected(true);
        this.jCheckBox_Preview.setText("Preview");
        this.jCheckBox_Preview.setBounds(new Rectangle(5, 81, 73, 25));
        this.jCheckBox_Preview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SetTransparency_Dialog.this.jCheckBox_Preview_actionPerformed(e);
            }
        });
        this.jButton_OK.setBounds(new Rectangle(83, 76, 79, 27));
        this.jButton_OK.setText("OK");
        this.jButton_OK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SetTransparency_Dialog.this.jButton_OK_actionPerformed(e);
            }
        });
        this.getContentPane().add(this.contentPane);
        this.contentPane.add((Component)this.jSlider_Transparency, null);
        this.contentPane.add((Component)this.jLabel1, null);
        this.contentPane.add((Component)this.jButton_OK, null);
        this.contentPane.add((Component)this.jButton_Cancel, null);
        this.contentPane.add((Component)this.jCheckBox_Preview, null);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException exc) {
            System.err.println("Unsupported Look And Feel");
        }
        SwingUtilities.updateComponentTreeUI(this.contentPane);
    }

    public boolean ShowDialog(Layers_Repository Layers, JPanel imagePanel) {
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension screenSize = kit.getScreenSize();
        int screenWidth = screenSize.width;
        int screenHeight = screenSize.height;
        this.setLocation((screenWidth - this.getWidth()) / 2, (screenHeight - this.getHeight()) / 2);
        this.LayersForChange = Layers;
        try {
            ByteArrayOutputStream ByteStream = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(ByteStream);
            out.writeObject(Layers);
            out.close();
            byte[] buf = ByteStream.toByteArray();
            ByteStream.close();
            ByteArrayInputStream ByteStream1 = new ByteArrayInputStream(buf, 0, ByteStream.size());
            ObjectInputStream in = new ObjectInputStream(ByteStream1);
            this.SrcLayers = (Layers_Repository)in.readObject();
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
        this.ImagePanel = imagePanel;
        this.SelectedLayer = this.SrcLayers.SelectedLayer;
        this.jSlider_Transparency.setValue(255);
        this.OK = false;
        this.show();
        this.ImagePanel = null;
        this.LayersForChange = null;
        this.SrcLayers = null;
        return this.OK;
    }

    void jSlider_Transparency_stateChanged(ChangeEvent e) {
        if (this.SelectedLayer >= 0) {
            BufferedImage srcLayer = this.SrcLayers.Layers[this.SelectedLayer].LayersData;
            int LayerWidth = this.SrcLayers.Layers[this.SelectedLayer].Width;
            int LayerHeight = this.SrcLayers.Layers[this.SelectedLayer].Height;
            WritableRaster srcLayerRaster = srcLayer.getRaster();
            int[] srcData = new int[4];
            int i = 0;
            while (i <= LayerHeight - 1) {
                int j = 0;
                while (j <= LayerWidth - 1) {
                    if ((srcData = srcLayerRaster.getPixel(j, i, srcData))[3] != 0) {
                        srcData[3] = this.jSlider_Transparency.getValue();
                        srcLayerRaster.setPixel(j, i, srcData);
                    }
                    ++j;
                }
                ++i;
            }
            this.LayersForChange.Layers[this.SelectedLayer].LayersData = srcLayer;
            if (this.jCheckBox_Preview.isSelected()) {
                this.ImagePanel.repaint();
            }
        }
    }

    void jButton_Cancel_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    void jCheckBox_Preview_actionPerformed(ActionEvent e) {
        if (this.jCheckBox_Preview.isSelected()) {
            this.ImagePanel.paint(this.ImagePanel.getGraphics());
        }
    }

    void jButton_OK_actionPerformed(ActionEvent e) {
        this.OK = true;
        this.setVisible(false);
    }
}

