/*
 * Decompiled with CFR 0.152.
 */
package netimager;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import netimager.Layers_Repository;

public class Sharp_Dialog
extends JDialog {
    JPanel contentPane = new JPanel();
    JSlider jSlider_Size = new JSlider(0, 40, 0);
    JLabel jLabel1 = new JLabel();
    JCheckBox jCheckBox_Preview = new JCheckBox();
    JButton jButton_Cancel = new JButton();
    JButton jButton_OK = new JButton();
    boolean OK;
    Layers_Repository LayersForChange;
    Layers_Repository SrcLayers;
    JPanel ImagePanel;
    int SelectedLayer;
    boolean Run = false;

    public Sharp_Dialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Sharp_Dialog() {
        this((Frame)null, "", false);
    }

    void jbInit() throws Exception {
        this.contentPane.setLayout(null);
        this.jSlider_Size.setBounds(new Rectangle(13, 29, 255, 24));
        this.jSlider_Size.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Sharp_Dialog.this.jSlider_Size_stateChanged(e);
            }
        });
        this.jLabel1.setText("Size:");
        this.jLabel1.setBounds(new Rectangle(17, 7, 142, 17));
        this.jCheckBox_Preview.setSelected(true);
        this.jCheckBox_Preview.setText("Preview");
        this.jCheckBox_Preview.setBounds(new Rectangle(12, 77, 73, 25));
        this.jCheckBox_Preview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Sharp_Dialog.this.jCheckBox_Preview_actionPerformed(e);
            }
        });
        this.jButton_Cancel.setText("Cancel");
        this.jButton_Cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Sharp_Dialog.this.jButton_Cancel_actionPerformed(e);
            }
        });
        this.jButton_Cancel.setBounds(new Rectangle(179, 73, 86, 27));
        this.jButton_OK.setBounds(new Rectangle(91, 73, 79, 27));
        this.jButton_OK.setText("OK");
        this.jButton_OK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Sharp_Dialog.this.jButton_OK_actionPerformed(e);
            }
        });
        this.contentPane.setMinimumSize(new Dimension(270, 120));
        this.contentPane.setPreferredSize(new Dimension(270, 120));
        this.getContentPane().add(this.contentPane);
        this.contentPane.add((Component)this.jSlider_Size, null);
        this.contentPane.add((Component)this.jLabel1, null);
        this.contentPane.add((Component)this.jCheckBox_Preview, null);
        this.contentPane.add((Component)this.jButton_OK, null);
        this.contentPane.add((Component)this.jButton_Cancel, null);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException exc) {
            System.err.println("Unsupported Look And Feel");
        }
        SwingUtilities.updateComponentTreeUI(this.contentPane);
    }

    public boolean ShowDialog(Layers_Repository Layers, int selectedLayer, JPanel imagePanel) {
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension screenSize = kit.getScreenSize();
        int screenWidth = screenSize.width;
        int screenHeight = screenSize.height;
        this.setLocation((screenWidth - this.getWidth()) / 2, (screenHeight - this.getHeight()) / 2);
        this.LayersForChange = Layers;
        try {
            ByteArrayOutputStream ByteStream = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(ByteStream);
            out.writeObject(Layers);
            out.close();
            byte[] buf = ByteStream.toByteArray();
            ByteStream.close();
            ByteArrayInputStream ByteStream1 = new ByteArrayInputStream(buf, 0, ByteStream.size());
            ObjectInputStream in = new ObjectInputStream(ByteStream1);
            this.SrcLayers = (Layers_Repository)in.readObject();
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
        this.ImagePanel = imagePanel;
        this.SelectedLayer = selectedLayer;
        this.OK = false;
        this.show();
        this.ImagePanel = null;
        this.LayersForChange = null;
        this.SrcLayers = null;
        return this.OK;
    }

    void jButton_Cancel_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    void jButton_OK_actionPerformed(ActionEvent e) {
        this.OK = true;
        this.setVisible(false);
    }

    void jSlider_Size_stateChanged(ChangeEvent e) {
        if (!this.Run) {
            this.Run = true;
            if (this.SelectedLayer >= 0) {
                int Sharp_Size = this.jSlider_Size.getValue();
                BufferedImage Img = this.SrcLayers.Layers[this.SelectedLayer].LayersData;
                BufferedImage bimg = new BufferedImage(((Image)Img).getWidth(this), ((Image)Img).getHeight(this), 2);
                BufferedImage bi = new BufferedImage(((Image)Img).getWidth(this), ((Image)Img).getHeight(this), 2);
                Graphics2D big = bi.createGraphics();
                big.drawImage((Image)Img, 0, 0, this);
                float el = -((float)Sharp_Size / 10.0f);
                float[] elements = new float[]{0.0f, el, 0.0f, el, -el * 4.0f + 1.0f, el, 0.0f, el, 0.0f};
                Kernel kernel = new Kernel(3, 3, elements);
                ConvolveOp cop = new ConvolveOp(kernel, 1, null);
                cop.filter(bi, bimg);
                this.LayersForChange.Layers[this.SelectedLayer].LayersData = bimg;
                if (this.jCheckBox_Preview.isSelected()) {
                    this.ImagePanel.repaint();
                }
            }
            this.Run = false;
        }
    }

    void jCheckBox_Preview_actionPerformed(ActionEvent e) {
        if (this.jCheckBox_Preview.isSelected()) {
            this.ImagePanel.paint(this.ImagePanel.getGraphics());
        }
    }
}

