/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.sftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import jfileupload.transfer.client.sftp.SFTPFile;
import jfileupload.transfer.client.util.PBE;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

public class SFTPClient
extends FTPClient {
    private static final Log log = LogFactory.getLog((Class)(class$jfileupload$transfer$client$sftp$SFTPClient == null ? (class$jfileupload$transfer$client$sftp$SFTPClient = SFTPClient.class$("jfileupload.transfer.client.sftp.SFTPClient")) : class$jfileupload$transfer$client$sftp$SFTPClient));
    public static final int DEFAULT_PORT = 22;
    public static final int CODE_220 = 220;
    public static final String SUCCESS = "OK";
    protected static final int S_IRUSR = 256;
    protected static final int S_IWUSR = 128;
    protected static final int S_IXUSR = 64;
    protected static final int S_IRGRP = 32;
    protected static final int S_IWGRP = 16;
    protected static final int S_IXGRP = 8;
    protected static final int S_IROTH = 4;
    protected static final int S_IWOTH = 2;
    protected static final int S_IXOTH = 1;
    protected static final String CHMOD_COMMAND = "chmod";
    private List listeners = null;
    private JSch jsch = null;
    private String host = null;
    private int port = 22;
    private int timeout = -1;
    private int buffersize = -1;
    private long resume = -1L;
    private String encoding = null;
    private ChannelSftp sftpChannel = null;
    private Session session = null;
    private String replyString = null;
    private PMonitor progress = null;
    static /* synthetic */ Class class$jfileupload$transfer$client$sftp$SFTPClient;

    public SFTPClient() {
        log.info((Object)"SFTP 2.7");
        String string = PBE.ENCODING;
        this.listeners = new ArrayList();
        this.jsch = new JSch();
        JSch.setLogger((Logger)new Logger(){

            public boolean isEnabled(int n) {
                return true;
            }

            public void log(int n, String string) {
                log.debug((Object)string);
            }
        });
    }

    public void addProtocolCommandListener(ProtocolCommandListener protocolCommandListener) {
        if (protocolCommandListener != null && !this.listeners.contains(protocolCommandListener)) {
            this.listeners.add(protocolCommandListener);
        }
    }

    public void removeProtocolCommandListener(ProtocolCommandListener protocolCommandListener) {
        if (protocolCommandListener != null) {
            this.listeners.remove(protocolCommandListener);
        }
    }

    protected void notifyCommandSent(ProtocolCommandEvent protocolCommandEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ProtocolCommandListener protocolCommandListener = (ProtocolCommandListener)iterator.next();
            protocolCommandListener.protocolCommandSent(protocolCommandEvent);
        }
    }

    protected void notifyReplyReceived(ProtocolCommandEvent protocolCommandEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ProtocolCommandListener protocolCommandListener = (ProtocolCommandListener)iterator.next();
            protocolCommandListener.protocolReplyReceived(protocolCommandEvent);
        }
    }

    public void setDefaultTimeout(int n) {
        this.timeout = n;
    }

    public void setControlEncoding(String string) {
        this.encoding = string;
    }

    public void setBufferSize(int n) {
        this.buffersize = n;
    }

    public void enterLocalPassiveMode() {
    }

    public void enterLocalActiveMode() {
    }

    public boolean completePendingCommand() {
        return true;
    }

    public void setRemoteVerificationEnabled(boolean bl) {
    }

    public boolean setFileType(int n) {
        this.replyString = null;
        return true;
    }

    public String getReplyString() {
        if (this.replyString == null) {
            return SUCCESS;
        }
        return this.replyString;
    }

    public String[] getReplyStrings() {
        if (this.replyString == null) {
            return new String[]{SUCCESS};
        }
        return new String[]{this.replyString};
    }

    public int getReplyCode() {
        return 220;
    }

    public void connect(String string, int n) {
        this.replyString = null;
        this.host = string;
        this.port = n;
    }

    public void connect(String string) {
        this.connect(string, 22);
    }

    public boolean isConnected() {
        boolean bl = true;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login(String string, String string2, String string3) {
        boolean bl = false;
        this.replyString = null;
        this.notifyCommandSent(new ProtocolCommandEvent((Object)this, "CONNECT", "CONNECT " + this.host));
        try {
            Properties properties = new Properties();
            byte[] byArray = null;
            if (string3 != null && string3.startsWith("file://")) {
                this.jsch.removeAllIdentity();
                File file = new File(URI.create(string3));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    byte[] byArray2 = new byte[4096];
                    int n = 0;
                    while ((n = fileInputStream.read(byArray2)) != -1) {
                        byteArrayOutputStream.write(byArray2, 0, n);
                    }
                    byArray = byteArrayOutputStream.toByteArray();
                }
                catch (Exception exception) {
                    log.error((Object)exception.getMessage(), (Throwable)exception);
                }
                finally {
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        log.error((Object)iOException.getMessage(), (Throwable)iOException);
                    }
                }
                if (string2 != null && string2.length() > 0) {
                    this.jsch.addIdentity(string, byArray, null, string2.getBytes());
                } else {
                    this.jsch.addIdentity(string, byArray, null, new byte[0]);
                }
                properties.put("PreferredAuthentications", "publickey");
            }
            this.setSession(this.jsch.getSession(string, this.host, this.port));
            properties.put("StrictHostKeyChecking", "no");
            this.getSession().setConfig(properties);
            if (byArray == null) {
                this.getSession().setPassword(string2);
            }
            if (this.timeout > 0) {
                this.getSession().connect(this.timeout);
            } else {
                this.getSession().connect();
            }
            this.setSFTPChannel(this.openSFTPChannel());
            bl = true;
        }
        catch (JSchException jSchException) {
            log.error((Object)jSchException.getMessage(), (Throwable)jSchException);
            this.replyString = jSchException.getMessage();
        }
        catch (SftpException sftpException) {
            log.error((Object)sftpException.getMessage(), (Throwable)sftpException);
            this.replyString = this.getError(sftpException.id) + " " + sftpException.getMessage();
        }
        this.notifyReplyReceived(new ProtocolCommandEvent((Object)this, this.getReplyCode(), this.getReplyString()));
        return bl;
    }

    protected ChannelSftp openSFTPChannel() throws JSchException, SftpException {
        Channel channel = this.getSession().openChannel("sftp");
        if (this.timeout > 0) {
            channel.connect(this.timeout);
        } else {
            channel.connect();
        }
        if (this.encoding != null) {
            ((ChannelSftp)channel).setFilenameEncoding(this.encoding);
        }
        return (ChannelSftp)channel;
    }

    public int noop() {
        if (this.getSFTPChannel() != null) {
            this.notifyCommandSent(new ProtocolCommandEvent((Object)this, "NOOP", "NOOP "));
            try {
                this.getSFTPChannel().getServerVersion();
            }
            catch (SftpException sftpException) {
                log.error((Object)sftpException.getMessage(), (Throwable)sftpException);
                log.debug((Object)this.getError(sftpException.id), (Throwable)sftpException);
                this.replyString = this.getError(sftpException.id) + " " + sftpException.getMessage();
            }
            this.notifyReplyReceived(new ProtocolCommandEvent((Object)this, this.getReplyCode(), this.getReplyString()));
        }
        return 220;
    }

    public String printWorkingDirectory() {
        this.replyString = null;
        String string = null;
        if (this.getSFTPChannel() != null) {
            this.notifyCommandSent(new ProtocolCommandEvent((Object)this, "PWD", "PWD "));
            try {
                string = this.getSFTPChannel().pwd();
            }
            catch (SftpException sftpException) {
                log.error((Object)sftpException.getMessage(), (Throwable)sftpException);
                log.debug((Object)this.getError(sftpException.id), (Throwable)sftpException);
                this.replyString = this.getError(sftpException.id) + " " + sftpException.getMessage();
            }
            this.notifyReplyReceived(new ProtocolCommandEvent((Object)this, this.getReplyCode(), this.getReplyString()));
        }
        return string;
    }

    public boolean changeWorkingDirectory(String string) {
        this.replyString = null;
        boolean bl = false;
        if (this.getSFTPChannel() != null) {
            this.notifyCommandSent(new ProtocolCommandEvent((Object)this, "CD", "CD " + string));
            try {
                this.getSFTPChannel().cd(string);
                bl = true;
            }
            catch (SftpException sftpException) {
                log.error((Object)sftpException.getMessage(), (Throwable)sftpException);
                log.debug((Object)this.getError(sftpException.id), (Throwable)sftpException);
                this.replyString = this.getError(sftpException.id) + " " + sftpException.getMessage();
            }
            this.notifyReplyReceived(new ProtocolCommandEvent((Object)this, this.getReplyCode(), this.getReplyString()));
        }
        return bl;
    }

    public boolean makeDirectory(String string) {
        this.replyString = null;
        boolean bl = false;
        if (this.getSFTPChannel() != null) {
            this.notifyCommandSent(new ProtocolCommandEvent((Object)this, "MKDIR", "MKDIR " + string));
            try {
                this.getSFTPChannel().mkdir(string);
                bl = true;
            }
            catch (SftpException sftpException) {
                log.error((Object)sftpException.getMessage(), (Throwable)sftpException);
                this.replyString = this.getError(sftpException.id) + " " + sftpException.getMessage();
            }
            this.notifyReplyReceived(new ProtocolCommandEvent((Object)this, this.getReplyCode(), this.getReplyString()));
        }
        return bl;
    }

    public boolean deleteFile(String string) {
        this.replyString = null;
        boolean bl = false;
        if (this.getSFTPChannel() != null) {
            this.notifyCommandSent(new ProtocolCommandEvent((Object)this, "RM", "RM " + string));
            try {
                this.getSFTPChannel().rm(string);
                bl = true;
            }
            catch (SftpException sftpException) {
                log.error((Object)sftpException.getMessage(), (Throwable)sftpException);
                this.replyString = this.getError(sftpException.id) + " " + sftpException.getMessage();
            }
            this.notifyReplyReceived(new ProtocolCommandEvent((Object)this, this.getReplyCode(), this.getReplyString()));
        }
        return bl;
    }

    public boolean removeDirectory(String string) {
        this.replyString = null;
        boolean bl = false;
        if (this.getSFTPChannel() != null) {
            this.notifyCommandSent(new ProtocolCommandEvent((Object)this, "RMDIR", "RMDIR " + string));
            try {
                this.getSFTPChannel().rmdir(string);
                bl = true;
            }
            catch (SftpException sftpException) {
                log.error((Object)sftpException.getMessage(), (Throwable)sftpException);
                this.replyString = this.getError(sftpException.id) + " " + sftpException.getMessage();
            }
            this.notifyReplyReceived(new ProtocolCommandEvent((Object)this, this.getReplyCode(), this.getReplyString()));
        }
        return bl;
    }

    public boolean rename(String string, String string2) {
        this.replyString = null;
        boolean bl = false;
        if (this.getSFTPChannel() != null) {
            this.notifyCommandSent(new ProtocolCommandEvent((Object)this, "RENAME", "RENAME " + string + " INTO " + string2));
            try {
                this.getSFTPChannel().rename(string, string2);
                bl = true;
            }
            catch (SftpException sftpException) {
                log.error((Object)sftpException.getMessage(), (Throwable)sftpException);
                this.replyString = this.getError(sftpException.id) + " " + sftpException.getMessage();
            }
            this.notifyReplyReceived(new ProtocolCommandEvent((Object)this, this.getReplyCode(), this.getReplyString()));
        }
        return bl;
    }

    public boolean abort() {
        this.replyString = null;
        if (this.progress != null) {
            this.notifyCommandSent(new ProtocolCommandEvent((Object)this, "ABORT", "ABORT"));
            this.progress.setCancelled(true);
            this.notifyReplyReceived(new ProtocolCommandEvent((Object)this, this.getReplyCode(), this.getReplyString()));
        }
        return true;
    }

    public boolean sendSiteCommand(String string) {
        this.replyString = null;
        boolean bl = false;
        if (this.getSFTPChannel() != null && string != null) {
            this.notifyCommandSent(new ProtocolCommandEvent((Object)this, string, string));
            try {
                String string2;
                int n;
                if (string.toLowerCase().startsWith(CHMOD_COMMAND) && (n = (string2 = string.substring(CHMOD_COMMAND.length() + 1, string.length())).indexOf(" ")) > 0) {
                    int n2 = Integer.parseInt(string2.substring(0, n), 8);
                    String string3 = string2.substring(n + 1, string2.length());
                    this.getSFTPChannel().chmod(n2, string3);
                    bl = true;
                }
            }
            catch (SftpException sftpException) {
                log.error((Object)sftpException.getMessage(), (Throwable)sftpException);
                this.replyString = this.getError(sftpException.id) + " " + sftpException.getMessage();
            }
            this.notifyReplyReceived(new ProtocolCommandEvent((Object)this, this.getReplyCode(), this.getReplyString()));
        }
        return bl;
    }

    public FTPFile[] listFiles() {
        return this.listFiles(".");
    }

    public FTPFile[] listFiles(String string) {
        this.replyString = null;
        SFTPFile[] sFTPFileArray = null;
        Vector vector = null;
        if (this.getSFTPChannel() != null) {
            this.notifyCommandSent(new ProtocolCommandEvent((Object)this, "LS", "LS " + string));
            try {
                vector = this.getSFTPChannel().ls(string);
            }
            catch (SftpException sftpException) {
                log.error((Object)sftpException.getMessage(), (Throwable)sftpException);
                this.replyString = this.getError(sftpException.id) + " " + sftpException.getMessage();
            }
            this.notifyReplyReceived(new ProtocolCommandEvent((Object)this, this.getReplyCode(), this.getReplyString()));
        }
        if (vector != null) {
            sFTPFileArray = new SFTPFile[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.elementAt(i);
                if (!(e instanceof ChannelSftp.LsEntry)) continue;
                ChannelSftp.LsEntry lsEntry = (ChannelSftp.LsEntry)e;
                SFTPFile sFTPFile = new SFTPFile();
                sFTPFile.setName(lsEntry.getFilename());
                SftpATTRS sftpATTRS = lsEntry.getAttrs();
                if (sftpATTRS != null) {
                    sFTPFile.setDirectory(sftpATTRS.isDir());
                    sFTPFile.setSymbolicLink(sftpATTRS.isLink());
                    sFTPFile.setSize(sftpATTRS.getSize());
                    int n = sftpATTRS.getPermissions();
                    if ((n & 0x100) != 0) {
                        sFTPFile.setPermission(0, 0, true);
                    }
                    if ((n & 0x80) != 0) {
                        sFTPFile.setPermission(0, 1, true);
                    }
                    if ((n & 0x40) != 0) {
                        sFTPFile.setPermission(0, 2, true);
                    }
                    if ((n & 0x20) != 0) {
                        sFTPFile.setPermission(1, 0, true);
                    }
                    if ((n & 0x10) != 0) {
                        sFTPFile.setPermission(1, 1, true);
                    }
                    if ((n & 8) != 0) {
                        sFTPFile.setPermission(1, 2, true);
                    }
                    if ((n & 4) != 0) {
                        sFTPFile.setPermission(2, 0, true);
                    }
                    if ((n & 2) != 0) {
                        sFTPFile.setPermission(2, 1, true);
                    }
                    if ((n & 1) != 0) {
                        sFTPFile.setPermission(2, 2, true);
                    }
                    sFTPFile.setLastModified((long)sftpATTRS.getMTime() * 1000L);
                }
                sFTPFileArray[i] = sFTPFile;
            }
        }
        return sFTPFileArray;
    }

    public String[] listNames(String string) {
        this.replyString = null;
        FTPFile[] fTPFileArray = this.listFiles(string);
        String[] stringArray = null;
        if (fTPFileArray != null) {
            stringArray = new String[fTPFileArray.length];
            for (int i = 0; i < fTPFileArray.length; ++i) {
                FTPFile fTPFile = fTPFileArray[i];
                stringArray[i] = new String(fTPFile.getName());
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeFile(String string, InputStream inputStream, int n) {
        this.replyString = null;
        boolean bl = false;
        if (this.getSFTPChannel() != null) {
            this.notifyCommandSent(new ProtocolCommandEvent((Object)this, "PUT", "PUT " + string));
            try {
                if (this.resume > 0L) {
                    n = 2;
                    this.resume = -1L;
                }
                this.progress = new PMonitor();
                this.getSFTPChannel().put(inputStream, string, (SftpProgressMonitor)this.progress, n);
                bl = true;
            }
            catch (SftpException sftpException) {
                log.error((Object)sftpException.getMessage(), (Throwable)sftpException);
                this.replyString = this.getError(sftpException.id) + " " + sftpException.getMessage();
            }
            finally {
                this.progress = null;
            }
            this.notifyReplyReceived(new ProtocolCommandEvent((Object)this, this.getReplyCode(), this.getReplyString()));
        }
        return bl;
    }

    public boolean appendFile(String string, InputStream inputStream) {
        return this.storeFile(string, inputStream, 2);
    }

    public boolean storeFile(String string, InputStream inputStream) {
        return this.storeFile(string, inputStream, 0);
    }

    public InputStream retrieveFileStream(String string) {
        this.replyString = null;
        InputStream inputStream = null;
        if (this.getSFTPChannel() != null) {
            this.notifyCommandSent(new ProtocolCommandEvent((Object)this, "GET", "GET " + string));
            try {
                long l = -1L;
                this.progress = new PMonitor();
                if (this.resume > 0L) {
                    l = this.resume;
                    this.resume = -1L;
                    inputStream = this.getSFTPChannel().get(string, (SftpProgressMonitor)this.progress, l);
                } else {
                    inputStream = this.getSFTPChannel().get(string, (SftpProgressMonitor)this.progress);
                }
            }
            catch (SftpException sftpException) {
                log.error((Object)sftpException.getMessage(), (Throwable)sftpException);
                this.replyString = this.getError(sftpException.id) + " " + sftpException.getMessage();
            }
            this.notifyReplyReceived(new ProtocolCommandEvent((Object)this, this.getReplyCode(), this.getReplyString()));
        }
        return inputStream;
    }

    public int rest(String string) {
        this.replyString = null;
        if (string != null) {
            this.notifyCommandSent(new ProtocolCommandEvent((Object)this, "REST", "REST " + string));
            this.resume = Long.parseLong(string);
            this.notifyReplyReceived(new ProtocolCommandEvent((Object)this, this.getReplyCode(), this.getReplyString()));
        }
        return 220;
    }

    public void disconnect() {
        this.replyString = null;
        this.notifyCommandSent(new ProtocolCommandEvent((Object)this, "DISCONNECT", "DISCONNECT " + this.host));
        if (this.getSFTPChannel() != null) {
            this.getSFTPChannel().disconnect();
            this.setSFTPChannel(null);
        }
        if (this.getSession() != null) {
            this.getSession().disconnect();
            this.setSession(null);
        }
        this.notifyReplyReceived(new ProtocolCommandEvent((Object)this, this.getReplyCode(), this.getReplyString()));
    }

    protected ChannelSftp getSFTPChannel() {
        return this.sftpChannel;
    }

    protected void setSFTPChannel(ChannelSftp channelSftp) {
        this.sftpChannel = channelSftp;
    }

    protected Session getSession() {
        return this.session;
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    public String getError(int n) {
        String string = "UNKNOWN";
        if (n == 5) {
            string = "BAD MESSAGE";
        } else if (n == 7) {
            string = "CONNECTION LOST";
        } else if (n == 1) {
            string = "EOF";
        } else if (n == 4) {
            string = "FAILURE";
        } else if (n == 6) {
            string = "NO_CONNECTION";
        } else if (n == 2) {
            string = "NO SUCH FILE";
        } else if (n == 0) {
            string = SUCCESS;
        } else if (n == 8) {
            string = "OP UNSUPPORTED";
        } else if (n == 3) {
            string = "PERMISSION DENIED";
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PMonitor
    implements SftpProgressMonitor {
        boolean cancelled = false;

        public boolean count(long l) {
            return !this.cancelled;
        }

        public void end() {
        }

        public void init(int n, String string, String string2, long l) {
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public void setCancelled(boolean bl) {
            this.cancelled = bl;
        }
    }
}

