/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.categorymgmt.authorization;

import com.ericsson.cms.categorymgmt.authorization.Messages;
import com.ericsson.cms.categorymgmt.util.CategoryLicenseProvider;
import com.tandbergtv.neptune.authorization.entity.BasicModule;
import com.tandbergtv.neptune.authorization.entity.BasicPermission;
import com.tandbergtv.neptune.authorization.entity.IModule;
import com.tandbergtv.neptune.authorization.service.IModuleProvider;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class CategoryManagerModuleProvider
implements IModuleProvider {
    private static final Logger logger = Logger.getLogger(CategoryManagerModuleProvider.class);
    private final CategoryLicenseProvider categoryModule = new CategoryLicenseProvider();

    public Collection<IModule> getModules() {
        ArrayList<IModule> modules = new ArrayList<IModule>();
        try {
            if (!this.categoryModule.isRCSOnlyDeployment() && this.categoryModule.isLicensed()) {
                modules.add(this.buildCategoryManagerModule());
            }
        }
        catch (InvalidLicenseException e) {
            logger.error((Object)("Error in obtaining the license for Category Manager " + e.getLocalizedMessage()));
        }
        return modules;
    }

    private IModule buildCategoryManagerModule() {
        String moduleName = "CategoryManager";
        String displayName = Messages.getString("CategoryManagerModule.DisplayName");
        BasicModule module = new BasicModule(moduleName, displayName);
        List permissions = module.getPermissions();
        displayName = Messages.getString("CategoryManagerModule.Permissions.View");
        permissions.add(new BasicPermission("View", displayName, moduleName));
        displayName = Messages.getString("CategoryManagerModule.Permissions.Create");
        permissions.add(new BasicPermission("Create", displayName, moduleName));
        displayName = Messages.getString("CategoryManagerModule.Permissions.Modify");
        permissions.add(new BasicPermission("Modify", displayName, moduleName));
        displayName = Messages.getString("CategoryManagerModule.Permissions.Delete");
        permissions.add(new BasicPermission("Delete", displayName, moduleName));
        displayName = Messages.getString("CategoryManagerModule.Permissions.Target");
        permissions.add(new BasicPermission("TargetCategoryTitle", displayName, moduleName));
        return module;
    }
}

