/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.categorymgmt.callback;

import com.ericsson.cms.categorymgmt.exception.DuplicateCategoryException;
import com.ericsson.cms.categorymgmt.service.ICategoryManager;
import com.ericsson.cms.categorymgmt.util.CategoryLicenseProvider;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistCallback;
import com.tandbergtv.watchpoint.pmm.title.TitlePersistException;
import java.util.List;
import org.apache.log4j.Logger;

public class TitlePersistCallback
implements ITitlePersistCallback {
    private static final Logger logger = Logger.getLogger(TitlePersistCallback.class);
    private final CategoryLicenseProvider categoryModule = new CategoryLicenseProvider();
    private final ICategoryManager categoryManager = this.getCategoryManager();

    public void onBeforePersist(Title title) throws TitlePersistException {
    }

    public void onPersist(Title title) throws TitlePersistException {
        if (title.getStatus() != TitleStatus.DRAFT) {
            long t0 = System.currentTimeMillis();
            List<Field> fields = this.getCategoryPath(title);
            long t1 = System.currentTimeMillis();
            logger.debug((Object)("Time taken to getCategoryPath - time:" + (t1 - t0) + " ms" + " titleID = " + title.getId()));
            for (Field field : fields) {
                String path = field.getValue();
                if (path == null || path.trim().length() < 1) {
                    return;
                }
                try {
                    if (this.categoryManager.createCategory(path.trim()) == null) continue;
                    logger.debug((Object)("Saved category " + path));
                }
                catch (DuplicateCategoryException ex) {
                    logger.debug((Object)("The category already exist for " + path));
                }
                catch (Exception ex) {
                    logger.error((Object)("Could not save category " + path + " from title " + title.getId()), (Throwable)ex);
                }
            }
        }
    }

    private List<Field> getCategoryPath(Title title) {
        List assets = title.getAssets("TITLE");
        if (assets == null || assets.isEmpty()) {
            return null;
        }
        Asset titleAsset = (Asset)assets.get(0);
        return titleAsset.getFields("/Fields/Categories/Category/Text");
    }

    private ICategoryManager getCategoryManager() {
        String jndiName = "cms/CategoryManager/local";
        return (ICategoryManager)InjectionUtil.injectInstance((String)jndiName, ICategoryManager.class);
    }
}

