/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.categorymgmt.entitymanager;

import com.ericsson.cms.categorymgmt.authorization.Messages;
import com.ericsson.cms.categorymgmt.entity.CatCategory;
import com.ericsson.cms.categorymgmt.entity.CatCategoryMetadata;
import com.ericsson.cms.categorymgmt.entity.CatCategoryView;
import com.ericsson.cms.categorymgmt.entity.CatFieldDefault;
import com.ericsson.cms.categorymgmt.entity.CatFieldSchema;
import com.ericsson.cms.categorymgmt.exception.AssociateFailedCategoryException;
import com.ericsson.cms.categorymgmt.exception.CategoryManagerException;
import com.ericsson.cms.categorymgmt.exception.CreateFailedCategoryException;
import com.ericsson.cms.categorymgmt.exception.DeleteCategoryException;
import com.ericsson.cms.categorymgmt.exception.DuplicateCategoryException;
import com.ericsson.cms.categorymgmt.exception.InvalidPathCategoryException;
import com.ericsson.cms.categorymgmt.exception.ValidationFailedCategoryException;
import com.ericsson.cms.categorymgmt.service.ICategoryFieldSchemaManagerLocal;
import com.ericsson.cms.categorymgmt.service.ICategoryManagerLocal;
import com.ericsson.cms.categorymgmt.service.ICategoryManagerRemote;
import com.ericsson.cms.categorymgmt.util.CategoryConfigurationProvider;
import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.log4j.Logger;

@Remote(value={ICategoryManagerRemote.class})
@Local(value={ICategoryManagerLocal.class})
@Stateless
@TransactionAttribute
public class CategoryManager
implements ICategoryManagerRemote {
    private static final Logger logger = Logger.getLogger(CategoryManager.class);
    @EJB
    private IConfigurationService configurationService;
    private static final String PATH_DELIMITER = "/";
    private static final Object BOOLEAN_TRUE = "T";
    private static final String ERR_NULL_CATEGORY = Messages.getString("CategoryManagerModule.Validation.nullCategory");
    private static final String ERR_CATEGORY = Messages.getString("CategoryManagerModule.Validation.category");
    private static final String ERR_MISSING_SCHEMA = Messages.getString("CategoryManagerModule.Validation.missingSchema");
    private static final String ERR_MISSING_METADATA = Messages.getString("CategoryManagerModule.Validation.missingMetadata");
    private static final String ERR_MISSING_REQUIRED_FIELD = Messages.getString("CategoryManagerModule.Validation.missingRequiredField");
    private static final String ERR_INSUFFICIENT_OCCURRENCES = Messages.getString("CategoryManagerModule.Validation.insufficientOccurrences");
    private static final String ERR_EXCESSIVE_OCCURRENCES = Messages.getString("CategoryManagerModule.Validation.excessiveOccurrences");
    private static final String ERR_VALUE_TOO_SHORT = Messages.getString("CategoryManagerModule.Validation.valueTooShort");
    private static final String ERR_VALUE_TOO_LONG = Messages.getString("CategoryManagerModule.Validation.valueTooLong");
    private static final String ERR_INVALID_FORMAT = Messages.getString("CategoryManagerModule.Validation.invalidFormat");
    private static final String ERR_NON_UNIQUE = Messages.getString("CategoryManagerModule.Validation.nonUnique");
    private static final String ERR_BAD_STRING_CHOICE = Messages.getString("CategoryManagerModule.Validation.badStringChoice");
    private static final String ERR_BAD_INTEGER = Messages.getString("CategoryManagerModule.Validation.badInteger");
    private static final String ERR_BAD_DECIMAL = Messages.getString("CategoryManagerModule.Validation.badDecimal");
    private static final String ERR_BAD_NUMBER_CHOICE = Messages.getString("CategoryManagerModule.Validation.badNumberChoice");
    private static final String ERR_UNDEFINED_CHOICES = Messages.getString("CategoryManagerModule.Validation.undefinedChoices");
    private static final String ERR_NO_INTERNAL_VERSION = Messages.getString("CategoryManagerModule.Validation.noInternalVersion");
    private static final String ERR_NO_NAME = Messages.getString("CategoryManagerModule.Validation.noName");
    private static final String ERR_NO_PARENT_ID = Messages.getString("CategoryManagerModule.Validation.noParentId");
    private static final String ERR_NO_PARENT = Messages.getString("CategoryManagerModule.Validation.noParent");
    private static final int CATEGORYNAME_MAX_LENGTH = 1024;
    @EJB
    private ICategoryFieldSchemaManagerLocal sMgr;
    @EJB
    private ITitleSearchService searchService;
    @EJB
    private IContentClassService contentClassService;
    @EJB(name="cms/TitleManagerProxy/local")
    private ITitleManager titleManager;
    @PersistenceContext(unitName="CategoryManagerRealm")
    private EntityManager entityManager;

    private CatCategoryView findCategoryViewByPath(String path) {
        CatCategoryView result = null;
        try {
            Query query = this.entityManager.createQuery("select c from CatCategoryView c where c.path=:path");
            query.setParameter("path", (Object)path);
            result = (CatCategoryView)query.getSingleResult();
            return result;
        }
        catch (NoResultException noResultException) {
            return result;
        }
    }

    public List<String> getCategoryPathList() {
        Query query = this.entityManager.createQuery("select c.path from CatCategoryView c order by c.path");
        List results = query.getResultList();
        logger.debug((Object)("getCategoryPathList() size=" + results.size()));
        return results;
    }

    public CatCategory createCategory(String path) throws DuplicateCategoryException, InvalidPathCategoryException, CreateFailedCategoryException, ValidationFailedCategoryException {
        CategoryConfigurationProvider config = new CategoryConfigurationProvider(this.configurationService);
        if (config.allowAutoCategoryCreation()) {
            return this.createCategory(path, false);
        }
        logger.info((Object)("Could not save category '" + path + "' , automatic category creation is not enabled"));
        return null;
    }

    public CatCategory createCategory(String rawPath, boolean withDefaults) throws DuplicateCategoryException, InvalidPathCategoryException, ValidationFailedCategoryException {
        logger.debug((Object)("createCategory(" + rawPath + "):"));
        CatCategory result = null;
        String path = this.getCategoryPathStartWithoutDelimiter(rawPath);
        this.validatePath(path);
        String testPath = new String(path);
        CatCategoryView view = this.findCategoryViewByPath(testPath);
        if (view != null) {
            throw new DuplicateCategoryException(path + " category already exists");
        }
        CatCategory category = null;
        while (view == null) {
            logger.debug((Object)("testPath=" + testPath));
            int i = testPath.lastIndexOf(PATH_DELIMITER);
            String name = testPath.substring(i + 1);
            if (name.length() > 1024) {
                throw new ValidationFailedCategoryException("Category Name '" + name + "' too long, it should be less than '" + 1024 + "' characters");
            }
            category = withDefaults ? this.getDefaultCategory() : new CatCategory();
            category.setName(name);
            category.setInternalVersion(new Long(1L));
            if (result != null) {
                result.setParent(category);
                if (category.getChildren() == null) {
                    category.setChildren(new TreeSet());
                }
                category.getChildren().add(result);
            }
            result = category;
            if (i < 0) break;
            testPath = testPath.substring(0, i);
            view = this.findCategoryViewByPath(testPath);
            logger.debug((Object)("view=" + view));
        }
        if (view != null) {
            category = this.getCategory(view.getId());
            result.setParent(category);
            if (category.getChildren() == null) {
                category.setChildren(new TreeSet());
            }
            category.getChildren().add(result);
            logger.debug((Object)("createCategory() category=" + category));
            logger.debug((Object)("createCategory() result=" + result));
            this.persist(category);
        } else {
            CatCategory root = (CatCategory)this.entityManager.find(CatCategory.class, (Object)new Long(0L));
            result.setParent(root);
            if (category.getChildren() == null) {
                category.setChildren(new TreeSet());
            }
            root.getChildren().add(result);
            logger.debug((Object)("createCategory() root=" + root));
            logger.debug((Object)("createCategory() result=" + result));
            this.persist(root);
        }
        return category;
    }

    private void persist(CatCategory category) {
        try {
            this.entityManager.persist((Object)category);
            this.entityManager.flush();
            this.entityManager.refresh((Object)category);
        }
        catch (RuntimeException ex) {
            logger.error((Object)"Error occured while persisting category", (Throwable)ex);
            throw ex;
        }
        logger.debug((Object)(category.getName() + " Category created Successfully"));
    }

    public CatCategory getCategory(String path) throws InvalidPathCategoryException {
        CatCategory result = null;
        CatCategoryView view = null;
        this.validatePath(path);
        view = this.findCategoryViewByPath(path);
        if (view != null) {
            result = this.getCategory(view.getId());
        }
        return result;
    }

    public boolean isCategoryExists(String path) {
        Query query = this.entityManager.createQuery("select count(*) from CatCategoryView c where c.path=:path");
        query.setParameter("path", (Object)path);
        Long count = (Long)query.getSingleResult();
        return count > 0L;
    }

    private void validatePath(String path) throws InvalidPathCategoryException {
        boolean isInvalidPath;
        boolean bl = isInvalidPath = path.startsWith(PATH_DELIMITER) || path.indexOf("//") > 0 || path.endsWith(PATH_DELIMITER);
        if (isInvalidPath) {
            throw new InvalidPathCategoryException("Invalid path " + path);
        }
    }

    public List<CatCategory> getCategoryTree() {
        return this.getCategoryTree(this.listCategories());
    }

    public Map<Long, CatCategory> getCategoryHash() {
        return this.getCategoryHash(this.listCategories());
    }

    public List<CatCategory> getCategories() {
        return new ArrayList<CatCategory>(this.getCategoryHash().values());
    }

    public CatCategory getCategory(Long id) {
        return this.getCategoryHash().get(id);
    }

    public List<CatCategory> listCategories() {
        Query query = this.entityManager.createQuery("select c from CatCategory c");
        List results = query.getResultList();
        logger.debug((Object)("listCategories() size=" + results.size()));
        Collections.sort(results);
        return results;
    }

    public CatCategory getRootCategory() {
        CatCategory result = (CatCategory)this.entityManager.find(CatCategory.class, (Object)new Long(0L));
        return result;
    }

    private Map<Long, CatCategory> getCategoryHash(List<CatCategory> lazyCategories) {
        HashMap<Long, CatCategory> map = new HashMap<Long, CatCategory>();
        for (CatCategory category : lazyCategories) {
            category.setChildren(new TreeSet());
            map.put(category.getId(), category);
        }
        for (CatCategory category : lazyCategories) {
            Long pid = category.getParentId();
            CatCategory parent = (CatCategory)map.get(pid);
            if (parent == null) {
                parent = new CatCategory();
                parent.setName("?" + pid + "?");
                parent.setChildren(new TreeSet());
                map.put(pid, parent);
            }
            parent.getChildren().add(category);
        }
        return map;
    }

    private List<CatCategory> getCategoryTree(List<CatCategory> lazyCategories) {
        ArrayList<CatCategory> result = new ArrayList<CatCategory>();
        this.getCategoryHash(lazyCategories);
        for (CatCategory category : lazyCategories) {
            if (category.getParentId() == null || category.getParentId() != 0L || category == null || category.getId() == 0L) continue;
            result.add(category);
        }
        return result;
    }

    public void disassociateCategoryPackage(long titleId) throws CategoryManagerException {
        List<CatCategory> results = this.findAssociatedCategoryPackage(titleId);
        if (results == null || results.size() == 0) {
            throw new CategoryManagerException("'" + titleId + "' is not associated with any category");
        }
        for (CatCategory c : results) {
            c.setAssociatedCategoryPackage(null);
            this.persist(c);
        }
    }

    private List<CatCategory> findAssociatedCategoryPackage(long titleId) {
        Query query = this.entityManager.createQuery("select c from CatCategory c where c.associatedCategoryPackage=:titleId");
        query.setParameter("titleId", (Object)titleId);
        List results = query.getResultList();
        return results;
    }

    public boolean isCategoryAssociated(long titleId) {
        List<CatCategory> result = this.findAssociatedCategoryPackage(titleId);
        return result.size() > 0;
    }

    public void associateCategoryPackage(long titleId, String categoryPath, boolean enforceCategory, boolean enforceAssociation) throws AssociateFailedCategoryException, DuplicateCategoryException, InvalidPathCategoryException, CreateFailedCategoryException, ValidationFailedCategoryException {
        String categoryPathStartWithDelimiter = this.getCategoryPathStartWithDelimiter(categoryPath);
        boolean categoryExist = this.isCategoryExists(categoryPathStartWithDelimiter);
        boolean categoryAssociated = this.isCategoryAssociated(titleId);
        if (!enforceCategory && !categoryExist) {
            throw new AssociateFailedCategoryException("Unable to associate category package - reason: '" + categoryPath + "' category doesn't exist");
        }
        if (!enforceAssociation && categoryAssociated) {
            throw new AssociateFailedCategoryException("Unable to associate category package - reason: '" + titleId + "' category already associated");
        }
        logger.debug((Object)("creating association for category package:" + titleId));
        if (!categoryExist && this.createCategory(categoryPath) == null) {
            return;
        }
        try {
            if (categoryAssociated) {
                this.disassociateCategoryPackage(titleId);
            }
            this.associateCategoryPackage(titleId, categoryPathStartWithDelimiter);
        }
        catch (CategoryManagerException cme) {
            throw new AssociateFailedCategoryException("Unable to associate category package", (Throwable)cme);
        }
    }

    private String getCategoryPathStartWithDelimiter(String categoryPath) {
        if (categoryPath == null || categoryPath.isEmpty()) {
            return "";
        }
        if (categoryPath.startsWith(PATH_DELIMITER)) {
            return categoryPath;
        }
        return PATH_DELIMITER + categoryPath;
    }

    private String getCategoryPathStartWithoutDelimiter(String categoryPath) {
        if (categoryPath == null || categoryPath.isEmpty()) {
            return "";
        }
        if (categoryPath.startsWith(PATH_DELIMITER)) {
            return categoryPath.substring(1);
        }
        return categoryPath;
    }

    private void associateCategoryPackage(long titleId, String categoryPath) {
        CatCategoryView view = this.findCategoryViewByPath(categoryPath);
        if (view == null) {
            new AssociateFailedCategoryException("Unable to associate category package - reason: '" + categoryPath + "' category doesn't exist");
        } else {
            CatCategory category = (CatCategory)this.entityManager.find(CatCategory.class, (Object)view.getId());
            category.setAssociatedCategoryPackage(Long.valueOf(titleId));
            this.persist(category);
            logger.debug((Object)("Successfully associated category '" + categoryPath + "' with title '" + titleId + "'"));
        }
    }

    public void createCategory(CatCategory category) throws ValidationFailedCategoryException {
        this.validate(category);
        this.persist(category);
    }

    public void updateCategory(CatCategory category) throws ValidationFailedCategoryException {
        this.validateCategory(category);
        this.validate(category);
        TreeSet metadataSet = new TreeSet();
        metadataSet.addAll(category.getCatCategoryMetadata());
        category.getCatCategoryMetadata().clear();
        this.merge(category);
        category.getCatCategoryMetadata().addAll(metadataSet);
        category.setInternalVersion(Long.valueOf(category.getInternalVersion() + 1L));
        this.merge(category);
    }

    private void merge(CatCategory category) {
        this.entityManager.merge((Object)category);
        this.entityManager.flush();
        logger.debug((Object)(category.getName() + " Category merged Successfully"));
    }

    public void remove(String categoryPath) throws InvalidPathCategoryException, DeleteCategoryException {
        this.validatePath(categoryPath);
        if (!this.isCategoryExists(categoryPath)) {
            throw new DeleteCategoryException("'" + categoryPath + "' does not exist");
        }
        CatCategoryView view = this.findCategoryViewByPath(categoryPath);
        this.remove(view.getId());
    }

    public void remove(long categoryId) throws DeleteCategoryException {
        CatCategory category = (CatCategory)this.entityManager.find(CatCategory.class, (Object)categoryId);
        if (category == null) {
            throw new DeleteCategoryException("Selected category does not exist. Please refresh the categories page");
        }
        if (category.getAssociatedCategoryPackage() != null && this.isAssociatedTitleStillExists(category.getAssociatedCategoryPackage()).booleanValue()) {
            throw new DeleteCategoryException("'" + category.getPath() + "' can not be removed since it is associated to a category package");
        }
        try {
            if (this.checkExistenceOfCategoryTitle(category.getPath())) {
                throw new DeleteCategoryException("category can not be removed since it is referenced by a title");
            }
        }
        catch (ContentClassPersistenceException e) {
            logger.error((Object)e.getMessage());
            throw new DeleteCategoryException("Unable to remove - Exception while validating the title");
        }
        if (category.getChildren() != null && category.getChildren().size() > 0) {
            throw new DeleteCategoryException("'" + category.getPath() + "' can not be removed as it has sub categories");
        }
        this.remove(category);
    }

    private void remove(CatCategory category) {
        logger.debug((Object)("removing Category instance: " + category.getName()));
        this.entityManager.remove((Object)category);
        logger.debug((Object)"remove successful");
    }

    private boolean checkExistenceOfCategoryTitle(String categoryName) throws ContentClassPersistenceException {
        String categoryXpath = "/Fields/Categories/Category/Text";
        String assetType = "PACKAGE/TITLE";
        Long contentClassId = this.contentClassService.getCategoryContentClassId();
        if (contentClassId == null) {
            return false;
        }
        ExpList condition = new ExpList();
        condition.addItem((ExpNode)new ExpValue((Predicate)new PredicateRightValue(categoryXpath, assetType, FieldType.ASSET, Arrays.asList(categoryName), LogicalOperator.EQUAL, Boolean.valueOf(false))));
        condition.addItem((ExpNode)new ExpValue((Predicate)new PredicateRightValue("contentClassId", "PMM_TITLE", FieldType.PMM_TITLE, Arrays.asList(String.valueOf(contentClassId)), LogicalOperator.EQUAL, Boolean.valueOf(false))));
        return this.searchService.checkExistenceIncludeAllcopies((ExpNode)condition);
    }

    public void validate(CatCategory category) throws ValidationFailedCategoryException {
        ArrayList<ValidationFailedCategoryException> errors = new ArrayList<ValidationFailedCategoryException>();
        if (category != null) {
            List schemas = this.sMgr.getCategoryFieldSchema();
            Set metadata = category.getCatCategoryMetadata();
            if (schemas == null) {
                errors.add(new ValidationFailedCategoryException("Schema", ERR_MISSING_SCHEMA));
            }
            if (category.getName() == null) {
                errors.add(new ValidationFailedCategoryException("Name", ERR_NO_NAME));
            }
            if (category.getParentId() == null) {
                errors.add(new ValidationFailedCategoryException("Parent ID", ERR_NO_PARENT_ID));
            }
            if (category.getParent() == null) {
                errors.add(new ValidationFailedCategoryException("Parent", ERR_NO_PARENT));
            }
            if (category.getInternalVersion() == null) {
                errors.add(new ValidationFailedCategoryException("Internal Version", ERR_NO_INTERNAL_VERSION));
            }
            Map<Long, List<CatCategoryMetadata>> fieldHash = this.hashFields(metadata);
            for (CatFieldSchema schema : schemas) {
                List<ValidationFailedCategoryException> errs = this.validate(schema, fieldHash);
                if (errs == null || errs.size() <= 0) continue;
                errors.addAll(errs);
            }
        } else {
            errors.add(new ValidationFailedCategoryException("Category", ERR_NULL_CATEGORY));
        }
        if (errors.size() > 0) {
            ValidationFailedCategoryException fail = new ValidationFailedCategoryException(ERR_CATEGORY, category == null ? null : category.getName());
            fail.setChildren(errors);
            logger.warn((Object)("validate(" + (category == null ? null : category.toString()) + ")=" + fail.toString()));
            throw fail;
        }
    }

    private List<ValidationFailedCategoryException> validate(CatFieldSchema schema, Map<Long, List<CatCategoryMetadata>> fieldHash) {
        ArrayList<ValidationFailedCategoryException> errors;
        block35: {
            long size;
            List<CatCategoryMetadata> metadata;
            String regExp;
            boolean isUnique;
            boolean isRequired;
            long maxLen;
            long minLen;
            long maxOcc;
            long minOcc;
            String dataType;
            String fieldName;
            block36: {
                errors = new ArrayList<ValidationFailedCategoryException>();
                fieldName = schema.getName();
                Long fieldId = schema.getId();
                dataType = schema.getDataType();
                minOcc = schema.getMinOcc() == null ? 0L : schema.getMinOcc();
                maxOcc = schema.getMaxOcc() == null ? 0L : schema.getMaxOcc();
                minLen = schema.getMinLen() == null ? 0L : schema.getMinLen();
                maxLen = schema.getMaxLen() == null ? 0L : schema.getMaxLen();
                isRequired = BOOLEAN_TRUE.equals(schema.getRequiredCreate());
                boolean isEnabled = BOOLEAN_TRUE.equals(schema.getIsEnabled());
                isUnique = BOOLEAN_TRUE.equals(schema.getIsUnique());
                regExp = schema.getValidationRegex();
                metadata = null;
                if (fieldHash != null) {
                    metadata = fieldHash.get(fieldId);
                }
                long l = size = metadata != null ? (long)metadata.size() : 0L;
                if (!isEnabled) break block35;
                if (!"Set".equals(dataType)) break block36;
                if (schema.getChildren() == null) break block35;
                for (CatFieldSchema s : schema.getChildren()) {
                    List<ValidationFailedCategoryException> errs = this.validate(s, fieldHash);
                    if (errs == null || errs.size() <= 0) continue;
                    ValidationFailedCategoryException fail = new ValidationFailedCategoryException(schema.getName(), "");
                    fail.setChildren(errs);
                    errors.add(fail);
                }
                break block35;
            }
            if (isRequired && size < 1L) {
                errors.add(new ValidationFailedCategoryException(fieldName, ERR_MISSING_REQUIRED_FIELD));
            }
            if (minOcc > 0L && size < minOcc) {
                errors.add(new ValidationFailedCategoryException(fieldName, String.format(ERR_INSUFFICIENT_OCCURRENCES, size, minOcc)));
            }
            if (maxOcc > 0L && size > maxOcc) {
                errors.add(new ValidationFailedCategoryException(fieldName, String.format(ERR_EXCESSIVE_OCCURRENCES, size, maxOcc)));
            }
            if (isUnique && size > 1L) {
                HashSet<String> values = new HashSet<String>();
                for (CatCategoryMetadata md : metadata) {
                    values.add("" + md.getStringValue() + ":" + md.getNumberValue() + ":" + md.getDateValue() + ":" + md.getImageValue());
                }
                if ((long)values.size() < size) {
                    errors.add(new ValidationFailedCategoryException(fieldName, String.format(ERR_NON_UNIQUE, new Object[0])));
                }
            }
            if (size > 0L) {
                Object value;
                if ("String".equals(dataType)) {
                    for (CatCategoryMetadata element : metadata) {
                        value = element.getStringValue();
                        Object object = value = value == null ? "" : value;
                        if (minLen > 0L && (long)((String)value).length() < minLen) {
                            errors.add(new ValidationFailedCategoryException(fieldName, String.format(ERR_VALUE_TOO_SHORT, ((String)value).length(), minLen, value)));
                        }
                        if (maxLen > 0L && (long)((String)value).length() > maxLen) {
                            errors.add(new ValidationFailedCategoryException(fieldName, String.format(ERR_VALUE_TOO_LONG, ((String)value).length(), maxLen, value)));
                        }
                        if (regExp == null || regExp.trim().length() <= 0 || ((String)value).matches(regExp)) continue;
                        errors.add(new ValidationFailedCategoryException(fieldName, String.format(ERR_INVALID_FORMAT, regExp, value)));
                    }
                } else if ("String Choice".equals(dataType)) {
                    if (schema.getCatFieldDefaults() != null) {
                        for (CatCategoryMetadata element : metadata) {
                            value = element.getStringValue();
                            Object object = value = value == null ? "" : value;
                            if (this.contains((List<CatFieldDefault>)schema.getCatFieldDefaults(), (String)value)) continue;
                            errors.add(new ValidationFailedCategoryException(fieldName, String.format(ERR_BAD_STRING_CHOICE, value)));
                        }
                    } else {
                        errors.add(new ValidationFailedCategoryException(fieldName, String.format(ERR_UNDEFINED_CHOICES, new Object[0])));
                    }
                } else if ("Integer".equals(dataType)) {
                    for (CatCategoryMetadata element : metadata) {
                        try {
                            element.getNumberValue().longValueExact();
                        }
                        catch (ArithmeticException e) {
                            errors.add(new ValidationFailedCategoryException(fieldName, String.format(ERR_BAD_INTEGER, element.getNumberValue())));
                        }
                    }
                } else if ("Number Choice".equals(dataType)) {
                    if (schema.getCatFieldDefaults() != null) {
                        for (CatCategoryMetadata element : metadata) {
                            try {
                                value = element.getNumberValue().longValueExact();
                                if (this.contains((List<CatFieldDefault>)schema.getCatFieldDefaults(), (Long)value)) continue;
                                errors.add(new ValidationFailedCategoryException(fieldName, String.format(ERR_BAD_NUMBER_CHOICE, element.getNumberValue())));
                            }
                            catch (ArithmeticException e) {
                                errors.add(new ValidationFailedCategoryException(fieldName, String.format(ERR_BAD_INTEGER, element.getNumberValue())));
                            }
                        }
                    } else {
                        errors.add(new ValidationFailedCategoryException(fieldName, String.format(ERR_UNDEFINED_CHOICES, new Object[0])));
                    }
                } else if ("Decimal".equals(dataType)) {
                    for (CatCategoryMetadata element : metadata) {
                        try {
                            element.getNumberValue().doubleValue();
                        }
                        catch (Exception e) {
                            errors.add(new ValidationFailedCategoryException(fieldName, String.format(ERR_BAD_DECIMAL, element.getNumberValue())));
                        }
                    }
                }
            }
        }
        return errors;
    }

    private boolean contains(List<CatFieldDefault> defaults, String value) {
        if (defaults != null) {
            for (CatFieldDefault s : defaults) {
                if ((value != null || s.getStringValue() != null) && (s.getStringValue() == null || !s.getStringValue().equals(value))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean contains(List<CatFieldDefault> defaults, Long value) {
        if (defaults != null) {
            for (CatFieldDefault s : defaults) {
                if ((value != null || s.getNumberValue() != null) && (s.getNumberValue() == null || !Long.valueOf(s.getNumberValue().longValueExact()).equals(value))) continue;
                return true;
            }
        }
        return false;
    }

    private Map<Long, List<CatCategoryMetadata>> hashFields(Set<CatCategoryMetadata> set) throws ValidationFailedCategoryException {
        HashMap<Long, List<CatCategoryMetadata>> result = new HashMap<Long, List<CatCategoryMetadata>>();
        if (set != null) {
            for (CatCategoryMetadata s : set) {
                Long fieldId = s.getFieldId();
                ArrayList<CatCategoryMetadata> list = (ArrayList<CatCategoryMetadata>)result.get(fieldId);
                if (list == null) {
                    list = new ArrayList<CatCategoryMetadata>();
                    result.put(fieldId, list);
                }
                list.add(s);
            }
        }
        return result;
    }

    public CatCategory getDefaultCategory() {
        List schemaNodes = this.sMgr.getCategoryFieldSchema();
        CatCategory result = new CatCategory();
        TreeSet<CatCategoryMetadata> metadata = new TreeSet<CatCategoryMetadata>();
        result.setCatCategoryMetadata(metadata);
        for (CatFieldSchema s : schemaNodes) {
            metadata.addAll(this.getDefaultMetadata(s));
        }
        for (CatCategoryMetadata m : metadata) {
            m.setCatCategory(result);
        }
        result.setCatCategoryMetadata(metadata);
        logger.debug((Object)("getDefaultCategory()=" + result.toString()));
        return result;
    }

    private Set<CatCategoryMetadata> getDefaultMetadata(CatFieldSchema schema) {
        TreeSet<CatCategoryMetadata> metadata;
        block15: {
            String type;
            block16: {
                metadata = new TreeSet<CatCategoryMetadata>();
                if (schema == null || !BOOLEAN_TRUE.equals(schema.getIsEnabled())) break block15;
                type = schema.getDataType();
                if (!"Set".equals(type)) break block16;
                Set children = schema.getChildren();
                if (children == null) break block15;
                for (CatFieldSchema child : children) {
                    metadata.addAll(this.getDefaultMetadata(child));
                }
                break block15;
            }
            Long minOcc = schema.getMinOcc();
            Boolean isRequired = BOOLEAN_TRUE.equals(schema.getRequiredCreate());
            CatFieldDefault defaultValue = this.getSchemaDefaultValue(schema);
            for (long l = 0L; l == 0L && defaultValue != null || isRequired != false && l == 0L && minOcc == 0L || l < minOcc; ++l) {
                CatCategoryMetadata value = new CatCategoryMetadata();
                value.setFieldId(Long.valueOf(schema.getId()));
                value.setOccNum(Long.valueOf(l + 1L));
                if ("String".equals(type)) {
                    value.setStringValue(defaultValue == null ? null : defaultValue.getStringValue());
                } else if ("String Choice".equals(type)) {
                    value.setStringValue(defaultValue == null ? null : defaultValue.getStringValue());
                } else if ("Integer".equals(type)) {
                    value.setNumberValue(defaultValue == null ? null : defaultValue.getNumberValue());
                } else if ("Number Choice".equals(type)) {
                    value.setNumberValue(defaultValue == null ? null : defaultValue.getNumberValue());
                } else if ("Decimal".equals(type)) {
                    value.setNumberValue(defaultValue == null ? null : defaultValue.getNumberValue());
                } else if ("DateTimeZone".equals(type)) {
                    value.setDateValue(defaultValue == null ? null : defaultValue.getDateValue());
                } else if ("Image".equals(type)) {
                    value.setImageValue(defaultValue == null ? null : defaultValue.getImageValue());
                }
                metadata.add(value);
            }
        }
        return metadata;
    }

    private CatFieldDefault getSchemaDefaultValue(CatFieldSchema schema) {
        if (schema.getCatFieldDefaults() != null) {
            for (CatFieldDefault fieldDefault : schema.getCatFieldDefaults()) {
                if (!BOOLEAN_TRUE.equals(fieldDefault.getIsDefault())) continue;
                return fieldDefault;
            }
        }
        return null;
    }

    private void validateCategory(CatCategory detachedCategory) throws ValidationFailedCategoryException {
        CatCategory persistentCategory = (CatCategory)this.entityManager.find(CatCategory.class, (Object)detachedCategory.getId());
        StringBuilder errors = new StringBuilder();
        if (persistentCategory == null) {
            throw new ValidationFailedCategoryException("Invalid category id provided");
        }
        if (!persistentCategory.getName().equals(detachedCategory.getName())) {
            errors.append("\nName cannot be updated\n");
        }
        if (persistentCategory.getParentId().compareTo(detachedCategory.getParentId()) != 0) {
            errors.append("Parent Id cannot be updated\n");
        }
        if (!persistentCategory.getParent().getPath().equals(detachedCategory.getParent().getPath())) {
            errors.append("Parent cannot be updated\n");
        }
        if (errors.length() > 0) {
            throw new ValidationFailedCategoryException(errors.toString());
        }
    }

    public Boolean isAssociatedTitleStillExists(Long associatedTitleId) {
        return this.titleManager.isActive(associatedTitleId);
    }
}

