/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.categorymgmt.util;

import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import org.apache.log4j.Logger;

public class CategoryConfigurationProvider {
    private static String ALLOW_AUTO_CATEGORY_CREATION = "allowAutoCategoryCreation";
    private static IConfigurationService configurationService;
    private static final Logger logger;
    private static final String settingsPath;

    public CategoryConfigurationProvider(IConfigurationService configService) {
        configurationService = configService;
    }

    public boolean allowAutoCategoryCreation() {
        try {
            String allowCatCreate = (String)configurationService.getProperties(settingsPath).get(ALLOW_AUTO_CATEGORY_CREATION);
            return !"FALSE".equalsIgnoreCase(allowCatCreate);
        }
        catch (Exception ex) {
            logger.error((Object)("Problem reading path setting " + settingsPath + ":" + ALLOW_AUTO_CATEGORY_CREATION + ". Please make sure the configuration file exists with proper settings."), (Throwable)ex);
            return true;
        }
    }

    static {
        logger = Logger.getLogger(CategoryConfigurationProvider.class);
        settingsPath = CategoryConfigurationProvider.class.getPackage().getName();
    }
}

