/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.content_trafficking.authorization;

import com.tandbergtv.cms.content_trafficking.authorization.licensing.PlanningLicenseManager;
import com.tandbergtv.neptune.authorization.entity.BasicModule;
import com.tandbergtv.neptune.authorization.entity.BasicPermission;
import com.tandbergtv.neptune.authorization.entity.IModule;
import com.tandbergtv.neptune.authorization.service.IModuleProvider;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import com.tandbergtv.watchpoint.pmm.util.AuthConfigHelper;
import com.tandbergtv.workflow.auth.AuthorizationConfReader;
import com.tandbergtv.workflow.auth.Module;
import com.tandbergtv.workflow.auth.Permission;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;

public class ContentTraffickingModuleProvider
implements IModuleProvider {
    private static Logger logger = Logger.getLogger(ContentTraffickingModuleProvider.class);
    private static final String[] LICENSED_MODULE_NAMES = new String[]{"Schedules", "Jobs"};

    public Collection<IModule> getModules() {
        ArrayList<IModule> modules = new ArrayList<IModule>();
        try {
            if (PlanningLicenseManager.getInstance().isRCSOnlyDeployment()) {
                return modules;
            }
            boolean isLicensed = PlanningLicenseManager.getInstance().isLicensed();
            File authFile = AuthConfigHelper.getAuthConfigFile();
            Set pmmModules = AuthorizationConfReader.getInstance().read(authFile);
            for (Module module : pmmModules) {
                if (module.isExternal()) continue;
                String moduleName = module.getName();
                if (!isLicensed && ContentTraffickingModuleProvider.isLicenseRequiredForModule(moduleName)) continue;
                BasicModule pmmModule = new BasicModule(moduleName, moduleName);
                Collection authPermissions = module.getPermissions();
                for (Permission authPerm : authPermissions) {
                    if (authPerm.getName().equalsIgnoreCase("UserManagement") && ContentTraffickingModuleProvider.isUserManagementLicensed()) {
                        pmmModule.getPermissions().add(new BasicPermission(authPerm.getName(), authPerm.getDisplayName(), moduleName));
                        continue;
                    }
                    if (authPerm.getName().equalsIgnoreCase("UserManagement")) continue;
                    pmmModule.getPermissions().add(new BasicPermission(authPerm.getName(), authPerm.getDisplayName(), moduleName));
                }
                modules.add((IModule)pmmModule);
            }
        }
        catch (InvalidLicenseException e) {
            logger.error((Object)"Error while obtaining the license.", (Throwable)e);
        }
        return modules;
    }

    public static boolean isLicenseRequiredForModule(String moduleName) {
        boolean requiresLicense = false;
        for (String licensedModule : LICENSED_MODULE_NAMES) {
            if (!licensedModule.equals(moduleName)) continue;
            requiresLicense = true;
            break;
        }
        return requiresLicense;
    }

    private static boolean isUserManagementLicensed() {
        try {
            return PlanningLicenseManager.getInstance().isProviderPortalLicensed();
        }
        catch (InvalidLicenseException e) {
            return false;
        }
    }
}

