/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search;

import com.ericsson.cms.search.IElasticSearchPeriodicTitleSyncCleanupService;
import com.ericsson.cms.search.IElasticSearchTitleSyncCleanupService;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.workflow.core.service.Cluster;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.Timer;
import java.util.TimerTask;
import javax.ejb.EJB;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.log4j.Logger;
import org.jboss.ejb3.annotation.Depends;
import org.jboss.ejb3.annotation.Service;

@Service(objectName="Sites:service=com.ericsson.cms.search.IElasticSearchPeriodicTitleSyncCleanupService")
@Depends(value={"ContentManagement:service=com.tandbergtv.cms.contentmgmt.activation.IServiceActivator"})
public class ElasticSearchPeriodicTitleSyncCleanupService
implements IElasticSearchPeriodicTitleSyncCleanupService {
    private static final Logger logger = Logger.getLogger(ElasticSearchPeriodicTitleSyncCleanupService.class);
    @EJB
    private ITitleManager titleManager;
    private Timer timer = new Timer();
    private TimerTask periodicPollingTask = null;
    private MembershipListener hazelcastListener = new MembershipListener(){

        public void memberAdded(MembershipEvent ignore) {
        }

        public void memberRemoved(MembershipEvent evt) {
            logger.info((Object)("member removed: " + evt.getMember().getInetSocketAddress()));
            if (Cluster.isMaster()) {
                logger.info((Object)"This node is now the Cluster master node. Starting periodic task to poll database for titles that need to be synced to ES...");
                ElasticSearchPeriodicTitleSyncCleanupService.this.startPeriodicPolling();
            }
        }
    };

    @Override
    public void start() {
        try {
            Hazelcast.getCluster().addMembershipListener(this.hazelcastListener);
            if (Cluster.isMaster()) {
                logger.info((Object)"This node is immediately the Cluster master node. Starting periodic task to poll database for titles that need to be synced to ES...");
                this.startPeriodicPolling();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to crash recover the ElasticSearch Periodic Title Sync Cleanup Service");
        }
    }

    @Override
    public void stop() {
        this.stopPeriodicPolling();
    }

    private void startPeriodicPolling() {
        this.periodicPollingTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IElasticSearchTitleSyncCleanupService service = (IElasticSearchTitleSyncCleanupService)ServiceRegistry.getDefault().lookup(IElasticSearchTitleSyncCleanupService.class);
                UserTransaction trans = null;
                boolean flag = false;
                try {
                    trans = (UserTransaction)new InitialContext().lookup("UserTransaction");
                    if (trans.getStatus() == 6) {
                        flag = true;
                        trans.begin();
                        logger.info((Object)"Beginning JTA transaction");
                    } else {
                        logger.info((Object)"JTA transaction already running. No need to start one");
                    }
                    service.syncTitles(100);
                    if (flag) {
                        logger.info((Object)"Committed JTA transaction");
                        trans.commit();
                        flag = false;
                    }
                }
                catch (NamingException ne) {
                    logger.error((Object)"Problem starting a JTA transaction", (Throwable)ne);
                }
                catch (SystemException se) {
                    logger.error((Object)"Problem beginning a new JTA transaction", (Throwable)se);
                }
                catch (NotSupportedException nse) {
                    logger.error((Object)"Problem beginning a new JTA transaction", (Throwable)nse);
                }
                catch (Exception ex) {
                    logger.error((Object)"Unexpected error synching titles", (Throwable)ex);
                }
                finally {
                    if (flag) {
                        try {
                            logger.warn((Object)"Rolling back JTA transaction because of unexpected error");
                            trans.rollback();
                        }
                        catch (SystemException se) {
                            logger.error((Object)"Unexpected problem trying to rollback exception", (Throwable)se);
                        }
                    }
                }
            }
        };
        this.timer.schedule(this.periodicPollingTask, 60000L, 60000L);
    }

    private void stopPeriodicPolling() {
        if (this.periodicPollingTask != null) {
            this.periodicPollingTask.cancel();
            this.periodicPollingTask = null;
        }
    }
}

