/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.contentmgmt.authorization;

import com.tandbergtv.cms.contentmgmt.authorization.Messages;
import com.tandbergtv.neptune.authorization.entity.BasicModule;
import com.tandbergtv.neptune.authorization.entity.BasicPermission;
import com.tandbergtv.neptune.authorization.entity.IModule;
import com.tandbergtv.neptune.authorization.service.IModuleProvider;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ContentManagementModuleProvider
implements IModuleProvider {
    private static final String RCS_ONLY_LICENSE = "IsRCSOnly";
    private ILicenseManager neptuneLicenseManager = (ILicenseManager)InjectionUtil.injectInstance((String)"cms/LicenseManager/local", ILicenseManager.class);

    public Collection<IModule> getModules() {
        ArrayList<IModule> modules = new ArrayList<IModule>();
        if (this.isRCSOnlyDeployment()) {
            return modules;
        }
        modules.add(this.buildAssetModule());
        modules.add(this.buildContentClassModule());
        modules.add(this.buildLookupKeyModule());
        modules.add(this.buildMetadataConfigModule());
        modules.add(this.buildCustomFieldsModule());
        return modules;
    }

    private IModule buildAssetModule() {
        String moduleName = "AssetManagement";
        String displayName = Messages.getString("AssetModule.DisplayName");
        BasicModule module = new BasicModule(moduleName, displayName);
        List permissions = module.getPermissions();
        displayName = Messages.getString("AssetModule.Permissions.View");
        permissions.add(new BasicPermission("View", displayName, moduleName));
        displayName = Messages.getString("AssetModule.Permissions.Create");
        permissions.add(new BasicPermission("Create", displayName, moduleName));
        displayName = Messages.getString("AssetModule.Permissions.Modify");
        permissions.add(new BasicPermission("Modify", displayName, moduleName));
        displayName = Messages.getString("AssetModule.Permissions.Delete");
        permissions.add(new BasicPermission("Delete", displayName, moduleName));
        return module;
    }

    private IModule buildContentClassModule() {
        String moduleName = "ContentClassManagement";
        String displayName = Messages.getString("ContentClassModule.DisplayName");
        BasicModule module = new BasicModule(moduleName, displayName);
        List permissions = module.getPermissions();
        displayName = Messages.getString("ContentClassModule.Permissions.View");
        permissions.add(new BasicPermission("View", displayName, moduleName));
        displayName = Messages.getString("ContentClassModule.Permissions.Create");
        permissions.add(new BasicPermission("Create", displayName, moduleName));
        displayName = Messages.getString("ContentClassModule.Permissions.Modify");
        permissions.add(new BasicPermission("Modify", displayName, moduleName));
        displayName = Messages.getString("ContentClassModule.Permissions.Delete");
        permissions.add(new BasicPermission("Delete", displayName, moduleName));
        return module;
    }

    private IModule buildCustomFieldsModule() {
        String moduleName = "CustomFieldsAdministration";
        String displayName = Messages.getString("CustomFieldsModule.DisplayName");
        BasicModule module = new BasicModule(moduleName, displayName);
        List permissions = module.getPermissions();
        displayName = Messages.getString("CustomFieldsModule.Permissions.View");
        permissions.add(new BasicPermission("View", displayName, moduleName));
        displayName = Messages.getString("CustomFieldsModule.Permissions.Administer");
        permissions.add(new BasicPermission("Administer", displayName, moduleName));
        return module;
    }

    private IModule buildLookupKeyModule() {
        String moduleName = "LookupKeyManagement";
        String displayName = Messages.getString("LookupKeyModule.DisplayName");
        BasicModule module = new BasicModule(moduleName, displayName);
        List permissions = module.getPermissions();
        displayName = Messages.getString("LookupKeyModule.Permissions.View");
        permissions.add(new BasicPermission("View", displayName, moduleName));
        displayName = Messages.getString("LookupKeyModule.Permissions.Create");
        permissions.add(new BasicPermission("Create", displayName, moduleName));
        displayName = Messages.getString("LookupKeyModule.Permissions.Modify");
        permissions.add(new BasicPermission("Modify", displayName, moduleName));
        return module;
    }

    private IModule buildMetadataConfigModule() {
        String moduleName = "MetadataConfiguration";
        String displayName = Messages.getString("MetadataConfigurationModule.DisplayName");
        BasicModule module = new BasicModule(moduleName, displayName);
        List permissions = module.getPermissions();
        displayName = Messages.getString("MetadataConfigurationModule.Permissions.View");
        permissions.add(new BasicPermission("View", displayName, moduleName));
        displayName = Messages.getString("MetadataConfigurationModule.Permissions.Create");
        permissions.add(new BasicPermission("Create", displayName, moduleName));
        displayName = Messages.getString("MetadataConfigurationModule.Permissions.Delete");
        permissions.add(new BasicPermission("Delete", displayName, moduleName));
        return module;
    }

    private boolean isRCSOnlyDeployment() {
        String value = "false";
        try {
            value = this.neptuneLicenseManager.getProperty(RCS_ONLY_LICENSE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value == null || value.trim().isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }
}

