/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.contentmgmt.ejb.contentclass;

import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.content.contentclass.entities.ContentClassPartnerList;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ejb.Local;
import javax.ejb.Stateless;

@Local(value={IContentClassService.class})
@Stateless
public class ContentClassService
implements IContentClassService {
    public List<ContentClass> getAllContentClassesWithoutMetadata() throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.getAllContentClassesWithoutMetadata();
    }

    public ContentClass getContentClassById(long id) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.getContentClassById(id);
    }

    public void saveContentClass(ContentClass contentClass) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        proxy.saveContentClass(contentClass);
    }

    public void deleteContentClassById(long id) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        proxy.deleteContentClassById(id);
    }

    public ContentClassPartner getContentClassPartner(long contentClassId, long partnerId, boolean enforceCCPartnerAssociation) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.getContentClassPartner(contentClassId, partnerId, enforceCCPartnerAssociation);
    }

    public String getServiceName() {
        return "ContentClassService";
    }

    public void start() {
    }

    public void stop() {
    }

    private IContentClassService getProxy() {
        return (IContentClassService)ServiceRegistry.getDefault().lookup(IContentClassService.class);
    }

    public void saveContentClassPartner(ContentClassPartner ccp) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        proxy.saveContentClassPartner(ccp);
    }

    public void deleteContentClassPartner(ContentClassPartner ccp) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        proxy.deleteContentClassPartner(ccp);
    }

    public Map<Long, ContentClassPartnerList> getContentClassPartnerMap(String userName) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.getContentClassPartnerMap(userName);
    }

    public Long getContentClassIdByName(String name) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.getContentClassIdByName(name);
    }

    public Long getDefaultContentClassId() throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.getDefaultContentClassId();
    }

    public ContentClassPartner getMergedContentClassPartnerMetadataForIngest(long contentClassId, long partnerId) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.getMergedContentClassPartnerMetadataForIngest(contentClassId, partnerId);
    }

    public ContentClassPartner getMergedContentClassPartnerMetadataForView(long contentClassId, long partnerId) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.getMergedContentClassPartnerMetadataForView(contentClassId, partnerId);
    }

    public void deleteContentClassesById(Collection<Long> ids) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        proxy.deleteContentClassesById(ids);
    }

    public void applyContentClassMetadataForIngest(Title title) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        proxy.applyContentClassMetadataForIngest(title);
    }

    public void applyContentClassMetadataForView(Title title) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        proxy.applyContentClassMetadataForView(title);
    }

    public List<ContentClass> getPartnerContentClassesWithoutMetadata(long partnerId) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.getPartnerContentClassesWithoutMetadata(partnerId);
    }

    public boolean contentClassNameExists(String name) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.contentClassNameExists(name);
    }

    public boolean contentClassAssociatedWithTitle(long contentClassId) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.contentClassAssociatedWithTitle(contentClassId);
    }

    public boolean contentClassPartnerExists(long contentClassId, long partnerId) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.contentClassPartnerExists(contentClassId, partnerId);
    }

    public List<ContentClassPartner> getContentClassPartnersByContentClassId(long id, boolean fetchMetadata) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.getContentClassPartnersByContentClassId(id, fetchMetadata);
    }

    public String marshalContentClass(ContentClass cc) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.marshalContentClass(cc);
    }

    public ContentClass unmarshalContentClass(String xml) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.unmarshalContentClass(xml);
    }

    public String marshalContentClassWithPartners(ContentClass cc, List<ContentClassPartner> partners) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.marshalContentClassWithPartners(cc, partners);
    }

    public ContentClass unmarshalContentClassWithPartners(String xml, List<ContentClassPartner> partners) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.unmarshalContentClassWithPartners(xml, partners);
    }

    public Long getPartnerIdByName(String name) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.getPartnerIdByName(name);
    }

    public Long getSeriesContentClassId() throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.getSeriesContentClassId();
    }

    public Long getCategoryContentClassId() throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.getCategoryContentClassId();
    }

    public Map<Long, ContentClassPartnerList> getCategoryContentClassPartnerMap(String userName) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.getCategoryContentClassPartnerMap(userName);
    }

    public Map<String, Map<String, String>> getFieldsWithOptions() throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.getFieldsWithOptions();
    }

    public Date getContentClassLastUpdateDate() throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.getContentClassLastUpdateDate();
    }

    public boolean isCategoryPackage(long titleId) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.isCategoryPackage(titleId);
    }

    public List<ContentClassPartner> getAllContentClassPartnersWithoutMetadata() throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.getAllContentClassPartnersWithoutMetadata();
    }

    public ContentClassPartner getContentClassPartnerMetadata(long contentClassId, long partnerId) throws ContentClassPersistenceException {
        IContentClassService proxy = this.getProxy();
        return proxy.getContentClassPartnerMetadata(contentClassId, partnerId);
    }

    public void invalidateContentClassCache(long contentClassId) {
        IContentClassService proxy = this.getProxy();
        proxy.invalidateContentClassCache(contentClassId);
    }
}

