/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.contentmgmt.ejb.specification;

import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.content.lookupkey.entities.LookupKey;
import com.tandbergtv.content.lookupkey.service.ILookupKeyManager;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.util.TableConfigHelper;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.web.table.Table;
import com.tandbergtv.workflow.web.table.TableConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.log4j.Logger;

@Stateless
public class AssetSpecificationManager
implements IAssetSpecificationManager {
    private Logger logger = Logger.getLogger(AssetSpecificationManager.class);
    private static final String SPECIFICATION_NAME_PROPERTY = "specificationName";
    @EJB
    private IConfigurationService configurationService;
    private static final String PMM_FOLDER_NAME = "pmm";
    private static final String TABLE_CONFIG_FILE_NAME = "table-config.xml";
    private static final String SPEC_NAME_TTV = "TTV";
    private ILookupKeyManager lookupKeyManager = (ILookupKeyManager)InjectionUtil.injectInstance((String)"cms/LookupKeyManagerServiceProxy/local", ILookupKeyManager.class);

    public Collection<Specification> getAllSpecifications() {
        ISpecificationManager specificationManager = this.getSpecificationManager();
        Collection allSpecifications = specificationManager.getAllSpecifications();
        Iterator allSpecificationsIterator = allSpecifications.iterator();
        while (allSpecificationsIterator.hasNext()) {
            Specification specification = (Specification)allSpecificationsIterator.next();
            if (!SPEC_NAME_TTV.equals(specification.getName())) continue;
            allSpecificationsIterator.remove();
        }
        return allSpecifications;
    }

    public Collection<Specification> getSpecsWithFromTTVTranslator() {
        ISpecificationManager specificationManager = this.getSpecificationManager();
        Collection specs = specificationManager.getAllSpecifications();
        Iterator itr = specs.iterator();
        while (itr.hasNext()) {
            Specification spec = (Specification)itr.next();
            if (SPEC_NAME_TTV.equals(spec.getName())) {
                itr.remove();
                continue;
            }
            ISpecHandler handler = spec.getSpecHandler();
            if (handler.getFromTTV() != null) continue;
            itr.remove();
        }
        return specs;
    }

    public Specification getSpecification(String name) {
        ISpecificationManager specificationManager = this.getSpecificationManager();
        Specification specification = specificationManager.getSpecificationByName(name);
        if (specification == null) {
            String errorMsg = "No specification with name: " + name + " exists.";
            this.logger.error((Object)errorMsg);
            throw new RuntimeException(errorMsg);
        }
        return specification;
    }

    public Table getTableConfiguration(String tableName) {
        TableConfig configuration = TableConfig.getInstance();
        HashMap<String, String> runtimeProperties = new HashMap<String, String>();
        runtimeProperties.put(SPECIFICATION_NAME_PROPERTY, "UI");
        File tableFile = TableConfigHelper.getTableConfigFile();
        return configuration.getTable(tableName, tableFile, runtimeProperties);
    }

    private ISpecificationManager getSpecificationManager() {
        return (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
    }

    public List<String> getAllLookupKeys() {
        ArrayList<String> lookupKeysStrList = new ArrayList<String>();
        List lookupKeys = this.lookupKeyManager.getLookupKeys();
        for (LookupKey lookupKey : lookupKeys) {
            for (String assetType : lookupKey.getAssetTypes()) {
                lookupKeysStrList.add(assetType + "-" + lookupKey.getName());
            }
        }
        Collections.sort(lookupKeysStrList);
        return lookupKeysStrList;
    }

    public UISpecification getUISpecification(UISpecification.Type type) {
        ISpecificationManager specificationManager = this.getSpecificationManager();
        return specificationManager.getUISpecification(type);
    }
}

