/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.authorization;

import com.ericsson.cms.contractmgmt.authorization.Messages;
import com.tandbergtv.neptune.authorization.entity.BasicModule;
import com.tandbergtv.neptune.authorization.entity.BasicPermission;
import com.tandbergtv.neptune.authorization.entity.IModule;
import com.tandbergtv.neptune.authorization.service.IModuleProvider;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContractManagerModuleProvider
implements IModuleProvider {
    private static final String CM_LICENSE = "ContractMgrLicense";
    private static final String RCS_ONLY_LICENSE = "IsRCSOnly";
    private ILicenseManager neptuneLicenseManager = (ILicenseManager)InjectionUtil.injectInstance((String)"cms/LicenseManager/local", ILicenseManager.class);
    private static final Log log = LogFactory.getLog(ContractManagerModuleProvider.class);

    public Collection<IModule> getModules() {
        ArrayList<IModule> modules = new ArrayList<IModule>();
        try {
            if (!this.isRCSOnlyDeployment() && this.isLicensed()) {
                modules.add(this.buildContractManagerModule());
            }
        }
        catch (InvalidLicenseException e) {
            log.error((Object)("Error in obtaining the license for Contract Manager " + e.getLocalizedMessage()));
        }
        return modules;
    }

    private boolean isLicensed() throws InvalidLicenseException {
        String value = this.neptuneLicenseManager.getProperty(CM_LICENSE);
        if (value == null || value.trim().isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    private IModule buildContractManagerModule() {
        String moduleName = "ContractManager";
        String displayName = Messages.getString("ContractManagerModule.DisplayName");
        BasicModule module = new BasicModule(moduleName, displayName);
        List permissions = module.getPermissions();
        displayName = Messages.getString("ContractManagerModule.Permissions.View");
        permissions.add(new BasicPermission("View", displayName, moduleName));
        displayName = Messages.getString("ContractManagerModule.Permissions.Create");
        permissions.add(new BasicPermission("Create", displayName, moduleName));
        displayName = Messages.getString("ContractManagerModule.Permissions.Modify");
        permissions.add(new BasicPermission("Modify", displayName, moduleName));
        displayName = Messages.getString("ContractManagerModule.Permissions.Delete");
        permissions.add(new BasicPermission("Delete", displayName, moduleName));
        return module;
    }

    private boolean isRCSOnlyDeployment() throws InvalidLicenseException {
        String value = this.neptuneLicenseManager.getProperty(RCS_ONLY_LICENSE);
        if (value == null || value.trim().isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }
}

