/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.scheduler;

import com.ericsson.cms.scheduler.IRecoveryService;
import com.ericsson.cms.scheduler.ISchedulerCallback;
import com.ericsson.ejb.ExpiringDetail;
import com.ericsson.mail.MailUtil;
import com.ericsson.service.IContractManager;
import com.ericsson.service.ICopyrightHolderManager;
import com.ericsson.service.IDealManager;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CMEmailNotificationSchedulerCallback
implements ISchedulerCallback {
    private static final Log logger = LogFactory.getLog(CMEmailNotificationSchedulerCallback.class);
    private IDealManager dealManager = (IDealManager)InjectionUtil.injectInstance((String)"cms/DealManager/local", IDealManager.class);
    private IContractManager contractManager = (IContractManager)InjectionUtil.injectInstance((String)"cms/ContractManager/local", IContractManager.class);
    private ICopyrightHolderManager copyrightHolderManager = (ICopyrightHolderManager)InjectionUtil.injectInstance((String)"cms/CopyrightHolderManager/local", ICopyrightHolderManager.class);

    public void performAction(long jobId, String associatedEntityType, Set<Long> associatedEntityIds, String filterName, Date filterValue, Date execDate, IRecoveryService rs) {
        logger.info((Object)"CMS-ContractManager==> Starting Execution Email notification job ");
        try {
            HashSet<String> recipients = new HashSet<String>();
            String body = new String();
            String dealName = new String();
            HashSet<String> licenseNames = new HashSet<String>();
            for (ExpiringDetail detail : this.dealManager.getAllDealsWithExpiringLicenses()) {
                String licenseName;
                if (!dealName.equals(detail.getTopName())) {
                    if (!recipients.isEmpty()) {
                        MailUtil.sendMail("Licenses about to expire!", body, recipients);
                        recipients.clear();
                    }
                    dealName = detail.getTopName();
                    body = "The following licenses, under the deal (";
                    body = body + dealName + ") are about to expire:\n";
                }
                if (!licenseNames.contains(licenseName = detail.getNextName())) {
                    body = body + licenseName + " expires on " + detail.getExpiryDate() + "\n";
                    licenseNames.add(licenseName);
                }
                recipients.add(detail.getEmail());
            }
            if (!recipients.isEmpty()) {
                MailUtil.sendMail("Licenses about to expire!", body, recipients);
                recipients.clear();
            }
            String contractName = new String();
            HashSet<String> dealNames = new HashSet<String>();
            for (ExpiringDetail detail : this.contractManager.getAllContractsWithExpiringDeals()) {
                String deal;
                if (!contractName.equals(detail.getTopName())) {
                    if (!recipients.isEmpty()) {
                        MailUtil.sendMail("Deals about to expire!", body, recipients);
                        recipients.clear();
                    }
                    contractName = detail.getTopName();
                    body = "The following deals, under the contract (";
                    body = body + contractName + ") are about to expire:\n";
                }
                if (!dealNames.contains(deal = detail.getNextName())) {
                    body = body + deal + " expires on " + detail.getExpiryDate() + "\n";
                    dealNames.add(deal);
                }
                recipients.add(detail.getEmail());
            }
            if (!recipients.isEmpty()) {
                MailUtil.sendMail("Deals about to expire!", body, recipients);
                recipients.clear();
            }
            String copyrightHolderName = new String();
            HashSet<String> contractNames = new HashSet<String>();
            for (ExpiringDetail detail : this.copyrightHolderManager.getAllCopyrightHoldersWithExpiringContracts()) {
                String contract;
                if (!copyrightHolderName.equals(detail.getTopName())) {
                    if (!recipients.isEmpty()) {
                        MailUtil.sendMail("Contracts about to expire!", body, recipients);
                        recipients.clear();
                    }
                    copyrightHolderName = detail.getTopName();
                    body = "The following contracts, under the Copyright Holder (";
                    body = body + copyrightHolderName + ") are about to expire:\n";
                }
                if (!contractNames.contains(contract = detail.getNextName())) {
                    body = body + contract + " expires on " + detail.getExpiryDate() + "\n";
                    contractNames.add(contract);
                }
                recipients.add(detail.getEmail());
            }
            if (!recipients.isEmpty()) {
                MailUtil.sendMail("Contracts about to expire!", body, recipients);
                recipients.clear();
            }
            logger.info((Object)"CMS-ContractManager==> Finishing Execution Email notification job ");
            this.markCompleted(rs);
        }
        catch (Exception e) {
            logger.info((Object)"CMS-ContractManager==> ERROR during execution of Email notification job.", (Throwable)e);
        }
    }

    private void markCompleted(IRecoveryService rs) {
        TransactionManager transactionManager = null;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            transactionManager.begin();
            rs.markDone();
            transactionManager.commit();
        }
        catch (Exception e) {
            logger.warn((Object)"Could not mark the transaction completed, even though email notifications were sent.");
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                logger.error((Object)"Could not rollback transaction: ", (Throwable)e1);
            }
        }
    }
}

