/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.validation;

import com.ericsson.cms.contractmgmt.validation.ContractManagerValidator;
import com.ericsson.cms.contractmgmt.validation.ValidationMessages;
import com.ericsson.cms.contractmgmt.validation.interfaces.ICopyrightHolderValidator;
import com.ericsson.ejb.CopyrightHolder;
import com.ericsson.entitymanager.CopyrightHolderManager;
import com.ericsson.enumeration.ScreenName;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.IFieldManager;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;

public class CopyrightHolderValidator
extends ContractManagerValidator
implements ICopyrightHolderValidator {
    public static final int NAME_MAX_LENGTH = 50;
    public static final int ADDRESS_MAX_LENGTH = 300;
    public static final int AFFILIATION_MAX_LENGTH = 50;

    @Override
    public void validate(CopyrightHolder copyrightHolder, IFieldManager fieldManager, EntityManager entityManager, CopyrightHolderManager chmgr, boolean isUpdate) throws ContractManagerValidationException {
        ArrayList<String> validationMessages = new ArrayList<String>();
        if (copyrightHolder == null) {
            validationMessages.add(ValidationMessages.getString("audit.copyright.null"));
            throw new ContractManagerValidationException(validationMessages);
        }
        this.validateCopyrightFields(copyrightHolder, validationMessages, fieldManager, entityManager, chmgr, isUpdate);
        if (!validationMessages.isEmpty()) {
            throw new ContractManagerValidationException(validationMessages);
        }
    }

    private void validateCopyrightFields(CopyrightHolder copyright, List<String> validationMessages, IFieldManager fieldManager, EntityManager entityManager, CopyrightHolderManager chmgr, boolean isUpdate) throws ContractManagerValidationException {
        super.validateRequired(copyright.getName(), "Name", "", validationMessages);
        super.validateRequired(copyright.getAddress(), "Address", "", validationMessages);
        super.validateRequired(copyright.getAffiliation(), "Affiliation", "", validationMessages);
        super.validateLength(copyright.getName(), "Name", 50, "", validationMessages);
        super.validateLength(copyright.getAddress(), "Address", 300, "", validationMessages);
        super.validateLength(copyright.getAffiliation(), "Affiliation", 50, "", validationMessages);
        super.validateCustomFields(copyright.getCopyHolderCustomLicFieldValues(), ScreenName.COPYRIGHTHOLDER, validationMessages, "", fieldManager, entityManager);
        this.validateUniqueName(copyright, validationMessages, chmgr);
        this.validateUniqueExternalID(copyright, validationMessages, chmgr);
    }

    private void validateUniqueName(CopyrightHolder copyright, List<String> validationMessages, CopyrightHolderManager chmgr) throws ContractManagerValidationException {
        CopyrightHolder sameNameRecord = chmgr.findByName(copyright.getName());
        if (sameNameRecord != null && !this.isSameRecord(copyright, sameNameRecord)) {
            validationMessages.add("The save operation failed. Copyright Holder Name '" + copyright.getName() + "' already exists.");
            throw new ContractManagerValidationException(validationMessages);
        }
    }

    private void validateUniqueExternalID(CopyrightHolder copyright, List<String> validationMessages, CopyrightHolderManager chmgr) throws ContractManagerValidationException {
        if (copyright.getExternalId() == null) {
            return;
        }
        CopyrightHolder sameEIDRecord = chmgr.findByExternalId(copyright.getExternalId());
        if (this.duplicatedEID(copyright, sameEIDRecord)) {
            validationMessages.add("The save operation failed. Copyright Holder External Id '" + copyright.getExternalId() + "' already exists.");
            throw new ContractManagerValidationException(validationMessages);
        }
    }

    private boolean duplicatedEID(CopyrightHolder copyright, CopyrightHolder sameEIDRecord) {
        if (sameEIDRecord == null) {
            return false;
        }
        boolean duplicatedEIDButNotSameRecord = !this.isSameRecord(sameEIDRecord, copyright) && copyright.getExternalId().equals(sameEIDRecord.getExternalId());
        return duplicatedEIDButNotSameRecord;
    }

    private boolean isSameRecord(CopyrightHolder detachedRecord, CopyrightHolder recordInDB) {
        if (recordInDB == null || detachedRecord.getIdCopyrightHolder() == null || recordInDB.getIdCopyrightHolder() == null) {
            return false;
        }
        return recordInDB.getIdCopyrightHolder().equals(detachedRecord.getIdCopyrightHolder());
    }
}

