/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.validation;

import com.ericsson.cms.contractmgmt.validation.ContractManagerValidator;
import com.ericsson.cms.contractmgmt.validation.ValidationMessages;
import com.ericsson.cms.contractmgmt.validation.interfaces.IFieldValidator;
import com.ericsson.ejb.Field;
import com.ericsson.enumeration.FieldType;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.ICurrencyManager;
import com.ericsson.service.IFrequencyManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class FieldValidator
extends ContractManagerValidator
implements IFieldValidator {
    private static final int VALUE_MAX_LENGTH = 50;
    private final ICurrencyManager currencyManager;
    private final IFrequencyManager frequencyManager;

    public FieldValidator(ICurrencyManager currencyManager, IFrequencyManager frequencyManager) {
        this.currencyManager = currencyManager;
        this.frequencyManager = frequencyManager;
    }

    @Override
    public void validate(Field field) throws ContractManagerValidationException {
        ArrayList<String> validationMessages = new ArrayList<String>();
        try {
            if (field == null) {
                validationMessages.add(ValidationMessages.getString("customField.isNull"));
            } else {
                if (field.getName() == null) {
                    validationMessages.add(ValidationMessages.getString("customfield.missingFieldName"));
                } else {
                    this.validateLength(50, field.getName(), "Custom field name", validationMessages);
                }
                if (field.getScreenName() == null) {
                    validationMessages.add(MessageFormat.format(ValidationMessages.getString("customfield.missingResourceType"), field.getName()));
                } else {
                    this.validateLength(50, field.getScreenName().name(), "Custom field screen name", validationMessages);
                }
                if (field.getType() == null) {
                    validationMessages.add(MessageFormat.format(ValidationMessages.getString("customfield.missingDataType"), field.getName()));
                } else {
                    this.validateDefaultValue(field, validationMessages);
                    this.validateRequired(field, validationMessages);
                    switch (field.getType()) {
                        case Alphanumeric: 
                        case Text: {
                            this.validateMinMax(field, validationMessages);
                            break;
                        }
                        case Date: {
                            break;
                        }
                        case Number: {
                            break;
                        }
                        case Percentage: {
                            break;
                        }
                        case Currency: {
                            this.validateCurrency(field, validationMessages);
                            break;
                        }
                        case Frequency: {
                            this.validateFrequency(field, validationMessages);
                            break;
                        }
                        default: {
                            validationMessages.add(MessageFormat.format(ValidationMessages.getString("customfield.invalidDataType"), field.getName()));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            validationMessages.add(MessageFormat.format(ValidationMessages.getString("customfield.unhandledException"), e.getLocalizedMessage()));
        }
        if (!validationMessages.isEmpty()) {
            throw new ContractManagerValidationException(validationMessages);
        }
    }

    private void validateFrequency(Field field, List<String> validationMessages) {
        String defaultValue = field.getDefaultValue();
        if (defaultValue != null) {
            try {
                if (this.frequencyManager.findById(Long.parseLong(defaultValue)) == null) {
                    validationMessages.add(MessageFormat.format(ValidationMessages.getString("customfield.invalidFrequencyDefaultValue"), defaultValue, field.getName()));
                }
            }
            catch (Exception e) {
                validationMessages.add(MessageFormat.format(ValidationMessages.getString("customfield.invalidFrequencyDefaultValue"), defaultValue, field.getName()));
            }
        }
    }

    private void validateCurrency(Field field, List<String> validationMessages) {
        String defaultValue = field.getDefaultValue();
        if (defaultValue != null) {
            try {
                if (this.currencyManager.findById(Long.parseLong(defaultValue)) == null) {
                    validationMessages.add(MessageFormat.format(ValidationMessages.getString("customfield.invalidCurrencyDefaultValue"), defaultValue, field.getName()));
                }
            }
            catch (Exception e) {
                validationMessages.add(MessageFormat.format(ValidationMessages.getString("customfield.invalidCurrencyDefaultValue"), defaultValue, field.getName()));
            }
        }
    }

    private void validateLength(int length, String value, String location, List<String> validationMessages) {
        if (value != null && value.trim().length() > length) {
            validationMessages.add(MessageFormat.format(ValidationMessages.getString("customfield.invalidLength"), location, value, length));
        }
    }

    private void validateDefaultValue(Field field, List<String> validationMessages) {
        String name = field.getName();
        FieldType type = field.getType();
        String value = field.getDefaultValue();
        if (type != null && value != null) {
            switch (type) {
                case Alphanumeric: {
                    this.validateLength(50, value, "Default alphanumeric value", validationMessages);
                    if (value.matches("[a-zA-Z0-9 ]*")) break;
                    validationMessages.add(MessageFormat.format(ValidationMessages.getString("customfield.invalidAlphanumericDefaultValue"), value, name));
                    break;
                }
                case Text: {
                    this.validateLength(50, value, "Default text value", validationMessages);
                    break;
                }
                case Date: {
                    break;
                }
                case Number: {
                    try {
                        Long.parseLong(value);
                    }
                    catch (NumberFormatException nfe) {
                        validationMessages.add(MessageFormat.format(ValidationMessages.getString("customfield.invalidNumberDefaultValue"), value, name));
                    }
                    break;
                }
                case Percentage: {
                    try {
                        Double number = Double.parseDouble(value);
                        if (!(number < 0.0) && !(number > 100.0)) break;
                        validationMessages.add(MessageFormat.format(ValidationMessages.getString("customfield.invalidPercentageDefaultValue"), value, name));
                    }
                    catch (NumberFormatException nfe) {
                        validationMessages.add(MessageFormat.format(ValidationMessages.getString("customfield.invalidPercentageDefaultValue"), value, name));
                    }
                    break;
                }
                case Currency: {
                    break;
                }
                case Frequency: {
                    break;
                }
            }
        }
    }

    private void validateRequired(Field field, List<String> validationMessages) {
        if (Boolean.TRUE.equals(field.getRequired()) && field.getDefaultValue() == null) {
            validationMessages.add(MessageFormat.format(ValidationMessages.getString("customfield.missingDefaultValue"), field.getName()));
        }
    }

    private void validateMinMax(Field field, List<String> validationMessages) {
        Integer min = field.getMinChars();
        Integer max = field.getMaxChars();
        String name = field.getName();
        if (min != null && min < 0) {
            validationMessages.add(MessageFormat.format(ValidationMessages.getString("customfield.invalidMinChars"), min, name));
        }
        if (max != null && max < 0) {
            validationMessages.add(MessageFormat.format(ValidationMessages.getString("customfield.invalidMaxChars"), max, name));
        }
        if (max != null && max > 0 && min != null && max < min) {
            validationMessages.add(MessageFormat.format(ValidationMessages.getString("customfield.maxCharsLessThanMinChars"), max, min, name));
        }
    }
}

