/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.cms.contractmgmt.audit.AuditMessages;
import com.ericsson.cms.contractmgmt.validation.ContractContactsValidator;
import com.ericsson.cms.contractmgmt.validation.ContractValidator;
import com.ericsson.cms.contractmgmt.validation.interfaces.IContractContactsValidator;
import com.ericsson.cms.contractmgmt.validation.interfaces.IContractValidator;
import com.ericsson.ejb.Audit;
import com.ericsson.ejb.Contract;
import com.ericsson.ejb.ContractContacts;
import com.ericsson.ejb.CopyHolderContacts;
import com.ericsson.ejb.CopyrightHolder;
import com.ericsson.ejb.Deal;
import com.ericsson.ejb.ExpiringDetail;
import com.ericsson.enumeration.AuditAction;
import com.ericsson.enumeration.AuditType;
import com.ericsson.mail.MailUtil;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.IAuditManager;
import com.ericsson.service.IContractContactsManager;
import com.ericsson.service.IContractManager;
import com.ericsson.service.IDealManager;
import com.ericsson.service.IFieldManager;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.watchpoint.search.QueryBuilder;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IContractManager.class})
@Stateless
public class ContractManager
implements IContractManager {
    private static final Log log = LogFactory.getLog(ContractManager.class);
    private final IContractValidator validator = new ContractValidator();
    private final IContractContactsValidator contactsValidator = new ContractContactsValidator();
    @EJB
    private IContractContactsManager contactsManager;
    @EJB
    private IDealManager dealManager;
    @EJB
    private IAuditManager auditManager;
    @EJB
    private IFieldManager fieldManager;
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public void persist(Contract transientInstance) throws ContractManagerValidationException {
        log.debug((Object)"persisting Contract instance");
        this.validate(transientInstance);
        this.entityManager.persist((Object)transientInstance);
        log.debug((Object)"persist successful");
        Object[] values = new Object[]{transientInstance.getName(), transientInstance.getIdContract()};
        this.auditManager.logAudit(AuditType.CONTRACT.getValue(), AuditAction.CREATE.getValue(), MessageFormat.format(AuditMessages.getString("audit.contract.create"), values));
        this.sendEmail(transientInstance.getName(), this.getRecipients(transientInstance), "created");
    }

    public void remove(Contract persistentInstance) {
        log.debug((Object)"removing Contract instance");
        Set<String> recipients = this.getRecipients(persistentInstance);
        String name = persistentInstance.getName();
        this.entityManager.remove((Object)persistentInstance);
        log.debug((Object)"remove successful");
        Object[] values = new Object[]{persistentInstance.getName(), persistentInstance.getIdContract()};
        this.auditManager.logAudit(AuditType.CONTRACT.getValue(), AuditAction.DELETE.getValue(), MessageFormat.format(AuditMessages.getString("audit.contract.delete"), values));
        this.sendEmail(name, recipients, "deleted");
    }

    public List<Audit> logAuditDeleteCascade(Set<Deal> deals) {
        return new ArrayList<Audit>();
    }

    public Contract merge(Contract detachedInstance) throws ContractManagerValidationException {
        log.debug((Object)"merging Contract instance");
        this.validate(detachedInstance);
        Contract result = (Contract)this.entityManager.merge((Object)detachedInstance);
        log.debug((Object)"merge successful");
        Object[] values = new Object[]{detachedInstance.getName(), detachedInstance.getIdContract()};
        this.auditManager.logAudit(AuditType.CONTRACT.getValue(), AuditAction.UPDATE.getValue(), MessageFormat.format(AuditMessages.getString("audit.contract.update"), values));
        this.sendEmail(detachedInstance.getName(), this.getRecipients(detachedInstance), "modified");
        return result;
    }

    public Contract findById(long id) {
        log.debug((Object)("getting Contract instance with id: " + id));
        Contract instance = (Contract)this.entityManager.find(Contract.class, (Object)id);
        log.debug((Object)"get successful");
        return instance;
    }

    public Contract getFullContractById(Long id) {
        Contract contract = null;
        Query query = this.entityManager.createQuery("SELECT contract from Contract contract LEFT JOIN FETCH contract.copyrightHolder ch LEFT JOIN FETCH contract.contractContacts cc LEFT JOIN FETCH contract.contractCustomLicFieldValues customLicFieldValues LEFT JOIN FETCH contract.contractDocuments cd LEFT JOIN FETCH contract.contractType ct WHERE contract.idContract = :ID");
        log.debug((Object)"get successful");
        query.setParameter("ID", (Object)id);
        try {
            contract = (Contract)query.getSingleResult();
        }
        catch (NoResultException e) {
            log.error((Object)"the contract is not exist. ", (Throwable)e);
        }
        return contract;
    }

    public Contract getFullContractByExternalId(String id) {
        Query query = this.entityManager.createQuery("SELECT contract from Contract contract LEFT JOIN FETCH contract.copyrightHolder ch LEFT JOIN FETCH contract.contractContacts cc LEFT JOIN FETCH contract.contractCustomLicFieldValues customLicFieldValues LEFT JOIN FETCH contract.contractDocuments cd LEFT JOIN FETCH contract.contractType ct WHERE contract.externalId = :ID");
        log.debug((Object)"get successful");
        query.setParameter("ID", (Object)id);
        return (Contract)query.getSingleResult();
    }

    public Contract getContractByName(String name, String excludeExternalId) {
        Query query = this.entityManager.createQuery("SELECT contract from Contract contract WHERE contract.externalId != :ID and contract.name = :NAME");
        log.debug((Object)"get successful");
        query.setParameter("ID", (Object)excludeExternalId);
        query.setParameter("NAME", (Object)name);
        return (Contract)query.getSingleResult();
    }

    public List<Contract> getAllContracts() {
        Query query = this.entityManager.createQuery("SELECT contract from Contract contract");
        log.debug((Object)"get successful");
        return query.getResultList();
    }

    public List<Contract> findByCopyrightHolder(long copyrightHolderId) {
        Query query = this.entityManager.createQuery("SELECT contract from Contract contract WHERE contract.copyrightHolder.idCopyrightHolder = " + copyrightHolderId);
        log.debug((Object)"get successful");
        return query.getResultList();
    }

    public List<Contract> getContracts(int start, int length, String sortProperty, boolean isAscending) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("Contract", Contract.class, "contract");
        SortingOrder sortOrder = SortingOrder.ASCENDING;
        if (!isAscending) {
            sortOrder = SortingOrder.DESCENDING;
        }
        e.addParameter((SearchParameterBase)new SortParameter(sortProperty, sortOrder));
        criteria.addParameter((SearchParameterBase)e);
        criteria.setStartingRecordNumber(start);
        criteria.setRecordsCount(length);
        String s = this.getQuery(criteria);
        Query query = this.entityManager.createQuery(s);
        query.setFirstResult(start);
        query.setMaxResults(criteria.getRecordsCount() == 0 ? Integer.MAX_VALUE : criteria.getRecordsCount());
        return query.getResultList();
    }

    private String getQuery(SearchCriteria criteria) {
        return QueryBuilder.newInstance().buildQuery(criteria);
    }

    public int count() {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("Contract", Contract.class, "contract");
        criteria.addParameter((SearchParameterBase)e);
        String s = QueryBuilder.newInstance().buildCountQuery(criteria);
        Query query = this.entityManager.createQuery(s);
        long count = (Long)query.getSingleResult();
        return (int)count;
    }

    private void sendEmail(String name, Set<String> recipients, String activity) {
        try {
            String subject = "Contract " + activity;
            String body = "Contract " + name + " was " + activity;
            MailUtil.sendMail(subject, body, recipients);
        }
        catch (Exception e) {
            log.error((Object)("Error sending email to recipients: " + e.getLocalizedMessage()));
        }
    }

    private Set<String> getRecipients(Contract contract) {
        HashSet<String> recipients = new HashSet<String>();
        CopyrightHolder copyrightHolder = (CopyrightHolder)this.entityManager.getReference(CopyrightHolder.class, (Object)contract.getCopyrightHolder().getIdCopyrightHolder());
        for (CopyHolderContacts copyrightHolderContact : copyrightHolder.getCopyHolderContacts()) {
            if (copyrightHolderContact.getNotify() == null || !copyrightHolderContact.getNotify().booleanValue()) continue;
            recipients.add(copyrightHolderContact.getEmail());
        }
        for (ContractContacts contractContact : this.contactsManager.findByContract(contract.getIdContract().longValue())) {
            if (contractContact.getNotify() == null || !contractContact.getNotify().booleanValue()) continue;
            recipients.add(contractContact.getEmail());
        }
        return recipients;
    }

    public List<ExpiringDetail> getAllContractsWithExpiringDeals() {
        Query query = this.entityManager.createQuery("select distinct new com.ericsson.ejb.ExpiringDetail(c.name, d.name, d.expiryDate, cc.email) from Contract c, Deal d, ContractContacts cc inner join c.deals as d inner join c.contractContacts as cc where d.expiryDate between systimestamp and (systimestamp + NVL(c.dealExpiryReminder, 1)) and cc.notify = true order by c.name, d.name");
        return query.getResultList();
    }

    private void validate(Contract instance) throws ContractManagerValidationException {
        this.validator.validate(instance, this.dealManager, this.fieldManager, this.entityManager, this);
        if (!instance.getContractContacts().isEmpty()) {
            ArrayList<ContractContacts> existentContacts = new ArrayList<ContractContacts>(instance.getContractContacts());
            this.contactsValidator.validate(instance.getContractContacts(), existentContacts);
        }
    }
}

