/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.ejb.ContractType;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.IContractTypeManager;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IContractTypeManager.class})
@Stateless
public class ContractTypeManager
implements IContractTypeManager {
    private static final Log log = LogFactory.getLog(ContractTypeManager.class);
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public void persist(ContractType transientInstance) throws ContractManagerValidationException {
        log.debug((Object)"persisting ContractType instance");
        try {
            this.isExists(transientInstance);
            this.entityManager.persist((Object)transientInstance);
            log.debug((Object)"persist successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"persist failed", (Throwable)re);
            throw re;
        }
    }

    private void isExists(ContractType transientInstance) throws ContractManagerValidationException {
        ContractType existing = this.findByName(transientInstance.getType());
        if (existing != null && (transientInstance.getIdType() == null || existing.getIdType().longValue() != transientInstance.getIdType().longValue())) {
            ArrayList<String> validationErrors = new ArrayList<String>();
            validationErrors.add("Contract Type already exists!");
            throw new ContractManagerValidationException(validationErrors);
        }
    }

    public boolean remove(ContractType persistentInstance) {
        log.debug((Object)"removing ContractType instance");
        try {
            this.entityManager.remove((Object)persistentInstance);
            log.debug((Object)"remove successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"remove failed", (Throwable)re);
            throw re;
        }
        return true;
    }

    public ContractType merge(ContractType detachedInstance) throws ContractManagerValidationException {
        log.debug((Object)"merging ContractType instance");
        try {
            this.isExists(detachedInstance);
            ContractType result = (ContractType)this.entityManager.merge((Object)detachedInstance);
            log.debug((Object)"merge successful");
            return result;
        }
        catch (RuntimeException re) {
            log.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public ContractType findById(long id) {
        log.debug((Object)("getting ContractType instance with id: " + id));
        try {
            ContractType instance = (ContractType)this.entityManager.find(ContractType.class, (Object)id);
            log.debug((Object)"get successful");
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List<ContractType> getAllContractTypes() {
        try {
            Query query = this.entityManager.createQuery("SELECT type from ContractType type");
            log.debug((Object)"get successful");
            return query.getResultList();
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public ContractType findByName(String type) {
        try {
            Query query = this.entityManager.createQuery("SELECT type from ContractType type WHERE type.type = :type");
            query.setParameter("type", (Object)type);
            log.debug((Object)"get successful");
            try {
                return (ContractType)query.getSingleResult();
            }
            catch (NoResultException e) {
                return null;
            }
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }
}

