/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.cms.contractmgmt.audit.AuditMessages;
import com.ericsson.ejb.CopyHolderDocuments;
import com.ericsson.enumeration.AuditAction;
import com.ericsson.enumeration.AuditType;
import com.ericsson.service.IAuditManager;
import com.ericsson.service.ICopyHolderDocumentsManager;
import java.text.MessageFormat;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={ICopyHolderDocumentsManager.class})
@Stateless
public class CopyHolderDocumentsManager
implements ICopyHolderDocumentsManager {
    private static final Log log = LogFactory.getLog(CopyHolderDocumentsManager.class);
    @EJB
    private IAuditManager auditManager;
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public void persist(CopyHolderDocuments transientInstance) {
        log.debug((Object)"persisting CopyHolderDocuments instance");
        try {
            this.entityManager.persist((Object)transientInstance);
            this.entityManager.flush();
            log.debug((Object)"persist successful");
            Object[] values = new Object[]{transientInstance.getFileName(), transientInstance.getIdDocument()};
            this.auditManager.logAudit(AuditType.COPYRIGHT.getValue(), AuditAction.CREATE.getValue(), MessageFormat.format(AuditMessages.getString("audit.copyright.document.create"), values));
        }
        catch (RuntimeException re) {
            log.error((Object)"persist failed", (Throwable)re);
            throw re;
        }
    }

    public void remove(CopyHolderDocuments persistentInstance) {
        log.debug((Object)"removing CopyHolderDocuments instance");
        try {
            this.entityManager.remove((Object)persistentInstance);
            log.debug((Object)"remove successful");
            Object[] values = new Object[]{persistentInstance.getFileName(), persistentInstance.getIdDocument()};
            this.auditManager.logAudit(AuditType.COPYRIGHT.getValue(), AuditAction.DELETE.getValue(), MessageFormat.format(AuditMessages.getString("audit.copyright.document.delete"), values));
        }
        catch (RuntimeException re) {
            log.error((Object)"remove failed", (Throwable)re);
            throw re;
        }
    }

    public CopyHolderDocuments merge(CopyHolderDocuments detachedInstance) {
        log.debug((Object)"merging CopyHolderDocuments instance");
        try {
            CopyHolderDocuments result = (CopyHolderDocuments)this.entityManager.merge((Object)detachedInstance);
            this.entityManager.flush();
            log.debug((Object)"merge successful");
            Object[] values = new Object[]{detachedInstance.getFileName(), detachedInstance.getIdDocument()};
            this.auditManager.logAudit(AuditType.COPYRIGHT.getValue(), AuditAction.UPDATE.getValue(), MessageFormat.format(AuditMessages.getString("audit.copyright.document.update"), values));
            return result;
        }
        catch (RuntimeException re) {
            log.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public CopyHolderDocuments findById(long id) {
        log.debug((Object)("getting CopyHolderDocuments instance with id: " + id));
        try {
            CopyHolderDocuments instance = (CopyHolderDocuments)this.entityManager.find(CopyHolderDocuments.class, (Object)id);
            log.debug((Object)"get successful");
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List<CopyHolderDocuments> findByCopyrightHolder(long copyrightHolderId) {
        try {
            Query query = this.entityManager.createQuery("SELECT docs from CopyHolderDocuments docs WHERE docs.copyrightHolder.idCopyrightHolder = " + copyrightHolderId);
            log.debug((Object)"get successful");
            return query.getResultList();
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }
}

