/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.cms.contractmgmt.audit.AuditMessages;
import com.ericsson.cms.contractmgmt.validation.CopyrightHolderContactsValidator;
import com.ericsson.cms.contractmgmt.validation.CopyrightHolderValidator;
import com.ericsson.cms.contractmgmt.validation.interfaces.ICopyrightHolderContactsValidator;
import com.ericsson.cms.contractmgmt.validation.interfaces.ICopyrightHolderValidator;
import com.ericsson.ejb.CopyHolderContacts;
import com.ericsson.ejb.CopyrightHolder;
import com.ericsson.ejb.ExpiringDetail;
import com.ericsson.enumeration.AuditAction;
import com.ericsson.enumeration.AuditType;
import com.ericsson.mail.MailUtil;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.IAuditManager;
import com.ericsson.service.ICopyHolderContactsManager;
import com.ericsson.service.ICopyrightHolderManager;
import com.ericsson.service.IFieldManager;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.watchpoint.search.QueryBuilder;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={ICopyrightHolderManager.class})
@Stateless
public class CopyrightHolderManager
implements ICopyrightHolderManager {
    private static final Log log = LogFactory.getLog(CopyrightHolderManager.class);
    @EJB
    private ICopyHolderContactsManager contactsManager;
    @EJB
    private IAuditManager auditManager;
    private final ICopyrightHolderValidator validator = new CopyrightHolderValidator();
    private final ICopyrightHolderContactsValidator contactsValidator = new CopyrightHolderContactsValidator();
    @EJB
    private IFieldManager fieldManager;
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public void persist(CopyrightHolder transientInstance) throws ContractManagerValidationException {
        log.debug((Object)"persisting CopyrightHolder instance");
        this.validate(transientInstance, false);
        this.entityManager.persist((Object)transientInstance);
        log.debug((Object)"persist successful");
        Object[] values = new Object[]{transientInstance.getName(), transientInstance.getIdCopyrightHolder()};
        this.auditManager.logAudit(AuditType.COPYRIGHT.getValue(), AuditAction.CREATE.getValue(), MessageFormat.format(AuditMessages.getString("audit.copyright.create"), values));
        this.sendEmail(transientInstance.getName(), this.getRecipients(transientInstance), "created");
    }

    public void remove(CopyrightHolder persistentInstance) {
        log.debug((Object)"removing CopyrightHolder instance");
        Set<String> recipients = this.getRecipients(persistentInstance);
        String name = persistentInstance.getName();
        this.entityManager.remove((Object)persistentInstance);
        log.debug((Object)"remove successful");
        Object[] values = new Object[]{persistentInstance.getName(), persistentInstance.getIdCopyrightHolder()};
        this.auditManager.logAudit(AuditType.COPYRIGHT.getValue(), AuditAction.DELETE.getValue(), MessageFormat.format(AuditMessages.getString("audit.copyright.delete"), values));
        this.sendEmail(name, recipients, "deleted");
    }

    public CopyrightHolder merge(CopyrightHolder detachedInstance) throws ContractManagerValidationException {
        log.debug((Object)"merging CopyrightHolder instance");
        this.validate(detachedInstance, true);
        CopyrightHolder result = (CopyrightHolder)this.entityManager.merge((Object)detachedInstance);
        log.debug((Object)"merge successful");
        Object[] values = new Object[]{detachedInstance.getName(), detachedInstance.getIdCopyrightHolder()};
        this.auditManager.logAudit(AuditType.COPYRIGHT.getValue(), AuditAction.UPDATE.getValue(), MessageFormat.format(AuditMessages.getString("audit.copyright.update"), values));
        this.sendEmail(detachedInstance.getName(), this.getRecipients(detachedInstance), "modified");
        return result;
    }

    public CopyrightHolder findById(long id) {
        log.debug((Object)("getting CopyrightHolder instance with id: " + id));
        CopyrightHolder instance = (CopyrightHolder)this.entityManager.find(CopyrightHolder.class, (Object)id);
        log.debug((Object)"get successful");
        return instance;
    }

    public List<CopyrightHolder> getAllCopyrightHolders() {
        Query query = this.entityManager.createQuery("SELECT copyrightholder from CopyrightHolder copyrightholder");
        log.debug((Object)"get successful");
        return query.getResultList();
    }

    public List<CopyrightHolder> getCopyrightHolders(int start, int length, String sortProperty, boolean isAscending) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("CopyrightHolder", CopyrightHolder.class, "copyright");
        SortingOrder sortOrder = SortingOrder.ASCENDING;
        if (!isAscending) {
            sortOrder = SortingOrder.DESCENDING;
        }
        e.addParameter((SearchParameterBase)new SortParameter(sortProperty, sortOrder));
        criteria.addParameter((SearchParameterBase)e);
        criteria.setStartingRecordNumber(start);
        criteria.setRecordsCount(length);
        String s = this.getQuery(criteria);
        Query query = this.entityManager.createQuery(s);
        query.setFirstResult(start);
        query.setMaxResults(criteria.getRecordsCount() == 0 ? Integer.MAX_VALUE : criteria.getRecordsCount());
        return query.getResultList();
    }

    private String getQuery(SearchCriteria criteria) {
        return QueryBuilder.newInstance().buildQuery(criteria);
    }

    public int count() {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("CopyrightHolder", CopyrightHolder.class, "copyright");
        criteria.addParameter((SearchParameterBase)e);
        String s = QueryBuilder.newInstance().buildCountQuery(criteria);
        Query query = this.entityManager.createQuery(s);
        long count = (Long)query.getSingleResult();
        return (int)count;
    }

    private void sendEmail(String name, Set<String> recipients, String activity) {
        try {
            String subject = "Copyright Holder " + activity;
            String body = "Copyright Holder " + name + " was " + activity;
            MailUtil.sendMail(subject, body, recipients);
        }
        catch (Exception e) {
            log.error((Object)("Error sending email to recipients: " + e.getLocalizedMessage()));
        }
    }

    private Set<String> getRecipients(CopyrightHolder copyrightHolder) {
        HashSet<String> recipients = new HashSet<String>();
        for (CopyHolderContacts copyrightHolderContact : this.contactsManager.findByCopyrightHolder(copyrightHolder.getIdCopyrightHolder().longValue())) {
            if (copyrightHolderContact.getNotify() == null || !copyrightHolderContact.getNotify().booleanValue()) continue;
            recipients.add(copyrightHolderContact.getEmail());
        }
        return recipients;
    }

    public List<ExpiringDetail> getAllCopyrightHoldersWithExpiringContracts() {
        Query query = this.entityManager.createQuery("select distinct new com.ericsson.ejb.ExpiringDetail(ch.name, c.name, c.expiryDate, cc.email) from CopyrightHolder ch, Contract c, CopyHolderContacts cc inner join ch.contracts as c inner join ch.copyHolderContacts as cc where c.expiryDate between systimestamp and (systimestamp + 1) and cc.notify = true order by ch.name, c.name");
        return query.getResultList();
    }

    public CopyrightHolder getFullCopyritghHolderForXml(Long key) {
        CopyrightHolder copyrightHolder = null;
        Query query = this.entityManager.createQuery("SELECT DISTINCT ch FROM CopyrightHolder ch LEFT JOIN FETCH ch.copyHolderDocuments  LEFT JOIN FETCH ch.copyHolderContacts  LEFT JOIN FETCH ch.copyHolderCustomLicFieldValues chcf LEFT JOIN FETCH chcf.field fld  LEFT JOIN FETCH fld.customLicFieldValues fldCF  WHERE ch.idCopyrightHolder = :ID");
        query.setParameter("ID", (Object)key);
        log.debug((Object)"get successful");
        try {
            copyrightHolder = (CopyrightHolder)query.getSingleResult();
        }
        catch (NoResultException e) {
            log.error((Object)"the copyright is not exist.", (Throwable)e);
        }
        return copyrightHolder;
    }

    public CopyrightHolder getFullCopyritghHolderForXmlByExternalId(String externalId) {
        Query query = this.entityManager.createQuery("SELECT DISTINCT ch FROM CopyrightHolder ch LEFT JOIN FETCH ch.copyHolderDocuments  LEFT JOIN FETCH ch.copyHolderContacts  LEFT JOIN FETCH ch.copyHolderCustomLicFieldValues chcf LEFT JOIN FETCH chcf.field fld  LEFT JOIN FETCH fld.customLicFieldValues fldCF  WHERE ch.externalId = :ID");
        query.setParameter("ID", (Object)externalId);
        log.debug((Object)"get successful");
        return (CopyrightHolder)query.getSingleResult();
    }

    public CopyrightHolder findByName(String name) {
        log.debug((Object)("getting CopyrightHolder instance with name: " + name));
        try {
            Query query = this.entityManager.createQuery("SELECT DISTINCT ch FROM CopyrightHolder ch WHERE ch.name = :name");
            query.setParameter("name", (Object)name);
            log.debug((Object)"get successful");
            return (CopyrightHolder)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public CopyrightHolder findByExternalId(String externalId) {
        log.debug((Object)("getting CopyrightHolder instance with id: " + externalId));
        Query query = this.entityManager.createQuery("SELECT copyrightholder from CopyrightHolder copyrightholder WHERE copyrightholder.externalId = :externalId");
        query.setParameter("externalId", (Object)externalId);
        List result = query.getResultList();
        return result != null && result.size() > 0 ? (CopyrightHolder)result.get(0) : null;
    }

    private void validate(CopyrightHolder instance, boolean isUpdate) throws ContractManagerValidationException {
        this.validator.validate(instance, this.fieldManager, this.entityManager, this, isUpdate);
        if (!instance.getCopyHolderContacts().isEmpty()) {
            ArrayList<CopyHolderContacts> existentContacts = new ArrayList<CopyHolderContacts>(instance.getCopyHolderContacts());
            this.contactsValidator.validate(instance.getCopyHolderContacts(), existentContacts);
        }
    }
}

