/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.ejb.DeliveryMethod;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.IDeliveryMethodManager;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IDeliveryMethodManager.class})
@Stateless
public class DeliveryMethodManager
implements IDeliveryMethodManager {
    private static final Log log = LogFactory.getLog(DeliveryMethodManager.class);
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public void persist(DeliveryMethod transientInstance) throws ContractManagerValidationException {
        log.debug((Object)"persisting DeliveryMethod instance");
        try {
            this.isExists(transientInstance);
            this.entityManager.persist((Object)transientInstance);
            log.debug((Object)"persist successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"persist failed", (Throwable)re);
            throw re;
        }
    }

    public void remove(DeliveryMethod persistentInstance) {
        log.debug((Object)"removing DeliveryMethod instance");
        try {
            this.entityManager.remove((Object)persistentInstance);
            log.debug((Object)"remove successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"remove failed", (Throwable)re);
            throw re;
        }
    }

    public DeliveryMethod merge(DeliveryMethod detachedInstance) throws ContractManagerValidationException {
        log.debug((Object)"merging DeliveryMethod instance");
        try {
            this.isExists(detachedInstance);
            DeliveryMethod result = (DeliveryMethod)this.entityManager.merge((Object)detachedInstance);
            log.debug((Object)"merge successful");
            return result;
        }
        catch (RuntimeException re) {
            log.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public DeliveryMethod findById(long id) {
        log.debug((Object)("getting DeliveryMethod instance with id: " + id));
        try {
            DeliveryMethod instance = (DeliveryMethod)this.entityManager.find(DeliveryMethod.class, (Object)id);
            log.debug((Object)"get successful");
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List<DeliveryMethod> getAllDeliveryMethods() {
        try {
            Query query = this.entityManager.createQuery("SELECT method from DeliveryMethod method");
            log.debug((Object)"get successful");
            return query.getResultList();
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    private void isExists(DeliveryMethod transientInstance) throws ContractManagerValidationException {
        DeliveryMethod existing = this.findByName(transientInstance.getDeliveryMethod());
        if (existing != null && (transientInstance.getIdDeliveryMethod() == null || existing.getIdDeliveryMethod().longValue() != transientInstance.getIdDeliveryMethod().longValue())) {
            ArrayList<String> validationErrors = new ArrayList<String>();
            validationErrors.add("Delivery Method already exists!");
            throw new ContractManagerValidationException(validationErrors);
        }
    }

    public DeliveryMethod findByName(String name) {
        try {
            Query query = this.entityManager.createQuery("SELECT method from DeliveryMethod method WHERE method.deliveryMethod = :name");
            query.setParameter("name", (Object)name);
            log.debug((Object)"get successful");
            try {
                return (DeliveryMethod)query.getSingleResult();
            }
            catch (NoResultException e) {
                return null;
            }
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }
}

