/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.ejb.Device;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.IDeviceManager;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.watchpoint.search.QueryBuilder;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IDeviceManager.class})
@Stateless
public class DeviceManager
implements IDeviceManager {
    private static final Log log = LogFactory.getLog(DeviceManager.class);
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public void persist(Device transientInstance) throws ContractManagerValidationException {
        log.debug((Object)"persisting Device instance");
        try {
            this.isExists(transientInstance);
            this.entityManager.persist((Object)transientInstance);
            log.debug((Object)"persist successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"persist failed", (Throwable)re);
            throw re;
        }
    }

    public void remove(Device persistentInstance) {
        log.debug((Object)"removing Device instance");
        try {
            this.entityManager.remove((Object)persistentInstance);
            log.debug((Object)"remove successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"remove failed", (Throwable)re);
            throw re;
        }
    }

    public Device merge(Device detachedInstance) throws ContractManagerValidationException {
        log.debug((Object)"merging Device instance");
        try {
            this.isExists(detachedInstance);
            Device result = (Device)this.entityManager.merge((Object)detachedInstance);
            log.debug((Object)"merge successful");
            return result;
        }
        catch (RuntimeException re) {
            log.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public Device findById(long id) {
        log.debug((Object)("getting Device instance with id: " + id));
        try {
            Device instance = (Device)this.entityManager.find(Device.class, (Object)id);
            log.debug((Object)"get successful");
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List<Device> getAllDevices() {
        log.debug((Object)"getting all Device instances");
        try {
            Query query = this.entityManager.createQuery("SELECT device from Device device");
            List devices = query.getResultList();
            log.debug((Object)"get successful");
            return devices;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List<Device> getDevices(int start, int length, String sortProperty, boolean isAscending) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("device", Device.class, "device");
        SortingOrder sortOrder = SortingOrder.ASCENDING;
        if (!isAscending) {
            sortOrder = SortingOrder.DESCENDING;
        }
        sortProperty = sortProperty.equalsIgnoreCase("name") ? "deviceName" : sortProperty;
        e.addParameter((SearchParameterBase)new SortParameter(sortProperty, sortOrder));
        criteria.addParameter((SearchParameterBase)e);
        criteria.setStartingRecordNumber(start);
        criteria.setRecordsCount(length);
        String s = this.getQuery(criteria);
        Query query = this.entityManager.createQuery(s);
        query.setFirstResult(start);
        query.setMaxResults(criteria.getRecordsCount() == 0 ? Integer.MAX_VALUE : criteria.getRecordsCount());
        List devices = query.getResultList();
        log.debug((Object)"get successful");
        return devices;
    }

    private String getQuery(SearchCriteria criteria) {
        return QueryBuilder.newInstance().buildQuery(criteria);
    }

    public int count() {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("device", Device.class, "device");
        criteria.addParameter((SearchParameterBase)e);
        String s = QueryBuilder.newInstance().buildCountQuery(criteria);
        Query query = this.entityManager.createQuery(s);
        long count = (Long)query.getSingleResult();
        return (int)count;
    }

    public List<Device> findByPlatform(long platformId) {
        try {
            Query query = this.entityManager.createQuery("SELECT device from Device device WHERE device.platform.idPlatform = " + platformId);
            List devices = query.getResultList();
            log.debug((Object)"get successful");
            return devices;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    private void isExists(Device transientInstance) throws ContractManagerValidationException {
        Device existing = this.findByNameAndPlatform(transientInstance.getDeviceName(), transientInstance.getPlatform().getIdPlatform());
        if (existing != null && (transientInstance.getIdDevice() == null || existing.getIdDevice().longValue() != transientInstance.getIdDevice().longValue())) {
            ArrayList<String> validationErrors = new ArrayList<String>();
            validationErrors.add("Device already exists!");
            throw new ContractManagerValidationException(validationErrors);
        }
    }

    public Device findByNameAndPlatform(String name, long platformId) {
        try {
            Query query = this.entityManager.createQuery("SELECT device from Device device WHERE device.deviceName = :name AND device.platform.idPlatform = :platformId");
            query.setParameter("platformId", (Object)platformId);
            query.setParameter("name", (Object)name);
            log.debug((Object)"get successful");
            try {
                return (Device)query.getSingleResult();
            }
            catch (NoResultException e) {
                return null;
            }
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }
}

