/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.cms.contractmgmt.scheduler.CMEmailNotificationSchedulerCallback;
import com.ericsson.cms.scheduler.IScheduler;
import com.ericsson.cms.scheduler.entities.Job;
import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.ericsson.service.ContractManagerRuntimeException;
import com.ericsson.service.IContractManagerExpiryTimer;
import java.util.HashSet;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless
public class EmailNotificationManager
implements IContractManagerExpiryTimer {
    private static final Log log = LogFactory.getLog(EmailNotificationManager.class);
    private static final String ASSOCIATED_ENTITY_TYPE_CMEMAILNOTIFICATION = "CMEmailNotification_SCHEDULER";
    private static final String ASSOCIATION_DESCRIPTION_PREFIX_CMEMAILNOTIFICATION = "Contract Manager Email Notifications for expiring contracts, deals and licenses";
    private static final String JOB_PREFIX_CMEMAILNOTIFICATION = "Job for Contract Manager Email Notifications";
    private static final Long SCHEDULER_TAB_INDEX = 8L;
    @EJB
    private IScheduler scheduler;

    public void createUpdateTimer(ScheduleRule scheduleRule) {
        try {
            List jobs = this.scheduler.getJobsByAssociatedEntityType(ASSOCIATED_ENTITY_TYPE_CMEMAILNOTIFICATION);
            Job cmEmailNotificationJob = null;
            if (scheduleRule != null) {
                String associatedEntityType = ASSOCIATED_ENTITY_TYPE_CMEMAILNOTIFICATION;
                HashSet<Long> associatedEntities = new HashSet<Long>();
                associatedEntities.add(SCHEDULER_TAB_INDEX);
                Job job = new Job();
                job.setRule(scheduleRule);
                job.setAssociatedEntityType(associatedEntityType);
                job.setAssociatedEntities(associatedEntities);
                job.setCallbackClass(CMEmailNotificationSchedulerCallback.class);
                cmEmailNotificationJob = job;
                if (jobs.size() > 0) {
                    cmEmailNotificationJob.setId(((Job)jobs.get(0)).getId());
                }
                String jobName = JOB_PREFIX_CMEMAILNOTIFICATION;
                String associationDescription = ASSOCIATION_DESCRIPTION_PREFIX_CMEMAILNOTIFICATION;
                cmEmailNotificationJob.setName(jobName);
                cmEmailNotificationJob.setAssociationDescription(associationDescription);
                Job jb = this.scheduler.schedule(cmEmailNotificationJob);
                if (jb != null) {
                    log.info((Object)("CMS-ContractManager==> Email notification job created: id = " + jb.getId()));
                }
            } else if (jobs.size() > 0) {
                cmEmailNotificationJob = (Job)jobs.get(0);
                Long cmEmailNotificationJobId = cmEmailNotificationJob.getId();
                this.scheduler.delete(cmEmailNotificationJobId.longValue());
            }
        }
        catch (Exception e) {
            throw new ContractManagerRuntimeException(e.getLocalizedMessage());
        }
    }

    public ScheduleRule getTimerSchedule() {
        ScheduleRule scheduleRule = null;
        List jobs = this.scheduler.getJobsByAssociatedEntityType(ASSOCIATED_ENTITY_TYPE_CMEMAILNOTIFICATION);
        Job cmEmailNotificationJob = null;
        if (jobs.size() > 0) {
            cmEmailNotificationJob = (Job)jobs.get(0);
            scheduleRule = cmEmailNotificationJob.getRule();
        }
        return scheduleRule;
    }
}

