/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.ejb.FieldDropdown;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.IFieldDropdownManager;
import com.ericsson.service.IFieldManager;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IFieldDropdownManager.class})
@Stateless
public class FieldDropdownManager
implements IFieldDropdownManager {
    private static final Log log = LogFactory.getLog(FieldDropdownManager.class);
    @EJB
    private IFieldManager fieldManager;
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public void persist(FieldDropdown transientInstance) throws ContractManagerValidationException {
        log.debug((Object)"persisting FieldDropdown instance");
        try {
            this.isExists(transientInstance);
            this.entityManager.persist((Object)transientInstance);
            log.debug((Object)"persist successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"persist failed", (Throwable)re);
            throw re;
        }
    }

    public void remove(FieldDropdown persistentInstance) throws ContractManagerValidationException {
        log.debug((Object)"removing FieldDropdown instance");
        try {
            this.isFieldDropDownUsed(persistentInstance);
            this.entityManager.remove((Object)persistentInstance);
            log.debug((Object)"remove successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"remove failed", (Throwable)re);
            throw re;
        }
    }

    private void isFieldDropDownUsed(FieldDropdown persistentInstance) throws ContractManagerValidationException {
        List fields = null;
        fields = this.fieldManager.findByTypeAndValue(persistentInstance.getField().getType(), persistentInstance.getIdFieldDropdown().toString());
        if (fields != null && !fields.isEmpty()) {
            ArrayList<String> validationErrors = new ArrayList<String>();
            validationErrors.add("The Drop Down (" + persistentInstance.getValue() + ") is used as a value [default or otherwise], and hence cannot be deleted at this time!");
            throw new ContractManagerValidationException(validationErrors);
        }
    }

    public FieldDropdown merge(FieldDropdown detachedInstance) throws ContractManagerValidationException {
        log.debug((Object)"merging FieldDropdown instance");
        try {
            this.isExists(detachedInstance);
            FieldDropdown result = (FieldDropdown)this.entityManager.merge((Object)detachedInstance);
            log.debug((Object)"merge successful");
            return result;
        }
        catch (RuntimeException re) {
            log.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public FieldDropdown findById(long id) {
        log.debug((Object)("getting FieldDropdown instance with id: " + id));
        try {
            FieldDropdown instance = (FieldDropdown)this.entityManager.find(FieldDropdown.class, (Object)id);
            log.debug((Object)"get successful");
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List<FieldDropdown> findByFieldId(long id) {
        log.debug((Object)("getting FieldDropDown for field.idField: " + id));
        try {
            Query query = this.entityManager.createQuery("SELECT fielddropdown from FieldDropdown fielddropdown WHERE fielddropdown.field.idField = :id");
            query.setParameter("id", (Object)id);
            log.debug((Object)"get successful");
            return query.getResultList();
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    private void isExists(FieldDropdown transientInstance) throws ContractManagerValidationException {
        FieldDropdown existing = this.findByValueAndField(transientInstance.getValue(), transientInstance.getField().getIdField());
        if (existing != null && (transientInstance.getIdFieldDropdown() == null || existing.getIdFieldDropdown().longValue() != transientInstance.getIdFieldDropdown().longValue())) {
            ArrayList<String> validationErrors = new ArrayList<String>();
            validationErrors.add("Field Drop Down already exists!");
            throw new ContractManagerValidationException(validationErrors);
        }
    }

    private FieldDropdown findByValueAndField(String value, long fieldId) {
        try {
            Query query = this.entityManager.createQuery("SELECT fielddropdown from FieldDropdown fielddropdown WHERE fielddropdown.value = :value AND fielddropdown.field.idField = :id");
            query.setParameter("id", (Object)fieldId);
            query.setParameter("value", (Object)value);
            log.debug((Object)"get successful");
            try {
                return (FieldDropdown)query.getSingleResult();
            }
            catch (NoResultException e) {
                return null;
            }
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }
}

