/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.ejb.Frequency;
import com.ericsson.enumeration.FieldType;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.IFieldManager;
import com.ericsson.service.IFrequencyManager;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IFrequencyManager.class})
@Stateless
public class FrequencyManager
implements IFrequencyManager {
    private static final Log log = LogFactory.getLog(FrequencyManager.class);
    @EJB
    private IFieldManager fieldManager;
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;
    private List<Frequency> frequenciesCache = new ArrayList<Frequency>();

    public void persist(Frequency transientInstance) throws ContractManagerValidationException {
        log.debug((Object)"persisting Frequency instance");
        this.isExists(transientInstance);
        this.entityManager.persist((Object)transientInstance);
        log.debug((Object)"persist successful");
        this.reloadAllFrequnecies();
    }

    public void remove(Frequency persistentInstance) throws ContractManagerValidationException {
        log.debug((Object)"removing Frequency instance");
        this.isFrequencyUsed(persistentInstance);
        this.entityManager.remove((Object)persistentInstance);
        log.debug((Object)"remove successful");
        this.reloadAllFrequnecies();
    }

    private void isFrequencyUsed(Frequency persistentInstance) throws ContractManagerValidationException {
        List fields = null;
        fields = this.fieldManager.findByTypeAndValue(FieldType.Frequency, persistentInstance.getIdFrequency().toString());
        if (fields != null && !fields.isEmpty()) {
            ArrayList<String> validationErrors = new ArrayList<String>();
            validationErrors.add("The Frequency (" + persistentInstance.getDescription() + ") is used as a value [default or otherwise], and hence cannot be deleted at this time!");
            throw new ContractManagerValidationException(validationErrors);
        }
    }

    public Frequency merge(Frequency detachedInstance) throws ContractManagerValidationException {
        log.debug((Object)"merging Frequency instance");
        this.isExists(detachedInstance);
        Frequency result = (Frequency)this.entityManager.merge((Object)detachedInstance);
        log.debug((Object)"merge successful");
        this.reloadAllFrequnecies();
        return result;
    }

    public Frequency findById(long id) {
        log.debug((Object)("getting Frequency instance with id: " + id));
        try {
            Frequency instance = (Frequency)this.entityManager.find(Frequency.class, (Object)id);
            log.debug((Object)"get successful");
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public synchronized List<Frequency> getAllFrequencies() {
        if (this.frequenciesCache.size() == 0) {
            Query query = this.entityManager.createQuery("SELECT freq from Frequency freq");
            List results = query.getResultList();
            log.debug((Object)"get successful");
            if (results != null) {
                this.frequenciesCache.addAll(results);
            }
        }
        return new ArrayList<Frequency>(this.frequenciesCache);
    }

    private void reloadAllFrequnecies() {
        this.frequenciesCache.clear();
        this.getAllFrequencies();
    }

    private void isExists(Frequency transientInstance) throws ContractManagerValidationException {
        Frequency existing = this.findByName(transientInstance.getDescription());
        if (existing != null && (transientInstance.getIdFrequency() == null || existing.getIdFrequency().longValue() != transientInstance.getIdFrequency().longValue())) {
            ArrayList<String> validationErrors = new ArrayList<String>();
            validationErrors.add("Frequency already exists!");
            throw new ContractManagerValidationException(validationErrors);
        }
    }

    public Frequency findByName(String name) {
        try {
            Query query = this.entityManager.createQuery("SELECT freq from Frequency freq WHERE freq.description = :name");
            query.setParameter("name", (Object)name);
            log.debug((Object)"get successful");
            try {
                return (Frequency)query.getSingleResult();
            }
            catch (NoResultException e) {
                return null;
            }
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }
}

