/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.ejb.Language;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.ILanguageManager;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={ILanguageManager.class})
@Stateless
public class LanguageManager
implements ILanguageManager {
    private static final Log log = LogFactory.getLog(LanguageManager.class);
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public void persist(Language transientInstance) throws ContractManagerValidationException {
        log.debug((Object)"persisting Language instance");
        try {
            this.isExists(transientInstance);
            this.entityManager.persist((Object)transientInstance);
            log.debug((Object)"persist successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"persist failed", (Throwable)re);
            throw re;
        }
    }

    public void remove(Language persistentInstance) {
        log.debug((Object)"removing Language instance");
        try {
            this.entityManager.remove((Object)persistentInstance);
            log.debug((Object)"remove successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"remove failed", (Throwable)re);
            throw re;
        }
    }

    public Language merge(Language detachedInstance) throws ContractManagerValidationException {
        log.debug((Object)"merging Language instance");
        try {
            this.isExists(detachedInstance);
            Language result = (Language)this.entityManager.merge((Object)detachedInstance);
            log.debug((Object)"merge successful");
            return result;
        }
        catch (RuntimeException re) {
            log.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public Language findById(long id) {
        log.debug((Object)("getting Language instance with id: " + id));
        try {
            Language instance = (Language)this.entityManager.find(Language.class, (Object)id);
            log.debug((Object)"get successful");
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List<Language> getAllLanguages() {
        try {
            Query query = this.entityManager.createQuery("SELECT lang from Language lang order by lang.language");
            log.debug((Object)"get successful");
            return query.getResultList();
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    private void isExists(Language transientInstance) throws ContractManagerValidationException {
        Language existing = this.findByName(transientInstance.getLanguage());
        if (existing != null && (transientInstance.getIdLanguage() == null || existing.getIdLanguage().longValue() != transientInstance.getIdLanguage().longValue())) {
            ArrayList<String> validationErrors = new ArrayList<String>();
            validationErrors.add("Language already exists!");
            throw new ContractManagerValidationException(validationErrors);
        }
    }

    public Language findByName(String name) {
        try {
            Query query = this.entityManager.createQuery("SELECT lang from Language lang WHERE lang.language = :name");
            query.setParameter("name", (Object)name);
            log.debug((Object)"get successful");
            try {
                return (Language)query.getSingleResult();
            }
            catch (NoResultException e) {
                return null;
            }
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }
}

