/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.ejb.Device;
import com.ericsson.ejb.LicenseDetails;
import com.ericsson.ejb.Platform;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.IDeviceManager;
import com.ericsson.service.ILicenseDetailsManager;
import com.ericsson.service.IPlatformManager;
import java.util.ArrayList;
import java.util.Date;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={ILicenseDetailsManager.class})
@Stateless
public class LicenseDetailsManager
implements ILicenseDetailsManager {
    private static final Log log = LogFactory.getLog(LicenseDetailsManager.class);
    @EJB
    private IPlatformManager platformManager;
    @EJB
    private IDeviceManager deviceManager;
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public void persist(LicenseDetails transientInstance) {
        log.debug((Object)"persisting LicenseDetails instance");
        this.entityManager.persist((Object)transientInstance);
        log.debug((Object)"persist successful");
    }

    public void remove(LicenseDetails persistentInstance) {
        log.debug((Object)"removing LicenseDetails instance");
        this.entityManager.remove((Object)persistentInstance);
        log.debug((Object)"remove successful");
    }

    public LicenseDetails merge(LicenseDetails detachedInstance) {
        log.debug((Object)"merging LicenseDetails instance");
        LicenseDetails result = (LicenseDetails)this.entityManager.merge((Object)detachedInstance);
        log.debug((Object)"merge successful");
        return result;
    }

    public LicenseDetails findById(long id) {
        log.debug((Object)("getting LicenseDetails instance with id: " + id));
        LicenseDetails instance = (LicenseDetails)this.entityManager.find(LicenseDetails.class, (Object)id);
        log.debug((Object)"get successful");
        return instance;
    }

    public LicenseDetails findAEDetailsForTitle(String provider, Long titleId, String deliveryLocation, String platform, String device) throws ContractManagerValidationException {
        Device dbDevice = null;
        Platform dbPlatform = null;
        String platformQuery = " AND details.platform is null";
        String deviceQuery = " AND details.device is null";
        if (platform != null && platform.trim().length() > 0) {
            dbPlatform = this.platformManager.findByName(platform);
            platformQuery = " AND details.platform = :platform";
        }
        if (dbPlatform != null && device != null && device.trim().length() > 0) {
            dbDevice = this.deviceManager.findByNameAndPlatform(device, dbPlatform.getIdPlatform().longValue());
            deviceQuery = " AND details.device = :device";
        }
        Query query = this.entityManager.createQuery("SELECT distinct details from LicenseDetails details JOIN details.license.smAssets assets WHERE details.license.contentProvider = :provider  AND assets.id.idAsset = :titleId AND details.license.effectiveDate <= :currentDate AND details.license.expiryDate >= :currentDate AND details.license.active = :isActive AND details.deliveryLocation = :deliveryLocation" + platformQuery + deviceQuery);
        query.setParameter("provider", (Object)provider);
        query.setParameter("titleId", (Object)titleId.toString());
        query.setParameter("currentDate", new Date(), TemporalType.DATE);
        query.setParameter("isActive", (Object)Boolean.TRUE);
        query.setParameter("deliveryLocation", (Object)deliveryLocation);
        if (dbPlatform != null) {
            query.setParameter("platform", (Object)dbPlatform);
        }
        if (dbDevice != null) {
            query.setParameter("device", (Object)dbDevice);
        }
        try {
            LicenseDetails details = (LicenseDetails)query.getSingleResult();
            log.debug((Object)"get successful");
            return details;
        }
        catch (NoResultException e) {
            query = this.entityManager.createQuery("SELECT distinct details from LicenseDetails details JOIN details.license.smAssets assets WHERE details.license.contentProvider is null  AND assets.id.idAsset = :titleId AND details.license.effectiveDate <= :currentDate AND details.license.expiryDate >= :currentDate AND details.license.active = :isActive AND details.deliveryLocation = :deliveryLocation" + platformQuery + deviceQuery);
            query.setParameter("titleId", (Object)titleId.toString());
            query.setParameter("currentDate", new Date(), TemporalType.DATE);
            query.setParameter("isActive", (Object)Boolean.TRUE);
            query.setParameter("deliveryLocation", (Object)deliveryLocation);
            if (dbPlatform != null) {
                query.setParameter("platform", (Object)dbPlatform);
            }
            if (dbDevice != null) {
                query.setParameter("device", (Object)dbDevice);
            }
            try {
                LicenseDetails details = (LicenseDetails)query.getSingleResult();
                log.debug((Object)"get successful");
                return details;
            }
            catch (NoResultException e1) {
                query = this.entityManager.createQuery("SELECT details from LicenseDetails details WHERE details.license.contentProvider = :provider  AND details.license.allAssets = :allTitles AND details.license.effectiveDate <= :currentDate AND details.license.expiryDate >= :currentDate AND details.license.active = :isActive AND details.deliveryLocation = :deliveryLocation" + platformQuery + deviceQuery);
                query.setParameter("provider", (Object)provider);
                query.setParameter("allTitles", (Object)Boolean.TRUE);
                query.setParameter("currentDate", new Date(), TemporalType.DATE);
                query.setParameter("isActive", (Object)Boolean.TRUE);
                query.setParameter("deliveryLocation", (Object)deliveryLocation);
                if (dbPlatform != null) {
                    query.setParameter("platform", (Object)dbPlatform);
                }
                if (dbDevice != null) {
                    query.setParameter("device", (Object)dbDevice);
                }
                try {
                    LicenseDetails details = (LicenseDetails)query.getSingleResult();
                    log.debug((Object)"get successful");
                    return details;
                }
                catch (NoResultException e2) {
                    query = this.entityManager.createQuery("SELECT details from LicenseDetails details WHERE details.license.contentProvider is null  AND details.license.allAssets = :allTitles AND details.license.effectiveDate <= :currentDate AND details.license.expiryDate >= :currentDate AND details.license.active = :isActive AND details.deliveryLocation = :deliveryLocation" + platformQuery + deviceQuery);
                    query.setParameter("allTitles", (Object)Boolean.TRUE);
                    query.setParameter("currentDate", new Date(), TemporalType.DATE);
                    query.setParameter("isActive", (Object)Boolean.TRUE);
                    query.setParameter("deliveryLocation", (Object)deliveryLocation);
                    if (dbPlatform != null) {
                        query.setParameter("platform", (Object)dbPlatform);
                    }
                    if (dbDevice != null) {
                        query.setParameter("device", (Object)dbDevice);
                    }
                    try {
                        LicenseDetails details = (LicenseDetails)query.getSingleResult();
                        log.debug((Object)"get successful");
                        return details;
                    }
                    catch (NoResultException e3) {
                        return null;
                    }
                    catch (NonUniqueResultException e3) {
                        this.handleDuplicates(e3);
                    }
                }
                catch (NonUniqueResultException e2) {
                    this.handleDuplicates(e2);
                }
            }
            catch (NonUniqueResultException e1) {
                this.handleDuplicates(e1);
            }
        }
        catch (NonUniqueResultException e) {
            this.handleDuplicates(e);
        }
        return null;
    }

    private void handleDuplicates(NonUniqueResultException e) throws ContractManagerValidationException {
        ArrayList<String> validationErrors = new ArrayList<String>();
        validationErrors.add("Duplicate Licenses associated with the asset!");
        validationErrors.add(e.getLocalizedMessage());
        throw new ContractManagerValidationException(validationErrors);
    }
}

