/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.ejb.LicenseType;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.ILicenseTypeManager;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={ILicenseTypeManager.class})
@Stateless
public class LicenseTypeManager
implements ILicenseTypeManager {
    private static final Log log = LogFactory.getLog(LicenseTypeManager.class);
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public void persist(LicenseType transientInstance) throws ContractManagerValidationException {
        log.debug((Object)"persisting LicenseType instance");
        try {
            this.isExists(transientInstance);
            this.entityManager.persist((Object)transientInstance);
            log.debug((Object)"persist successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"persist failed", (Throwable)re);
            throw re;
        }
    }

    public boolean remove(LicenseType persistentInstance) {
        log.debug((Object)"removing LicenseType instance");
        try {
            this.entityManager.remove((Object)persistentInstance);
            log.debug((Object)"remove successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"remove failed", (Throwable)re);
            throw re;
        }
        return true;
    }

    public LicenseType merge(LicenseType detachedInstance) throws ContractManagerValidationException {
        log.debug((Object)"merging LicenseType instance");
        try {
            this.isExists(detachedInstance);
            LicenseType result = (LicenseType)this.entityManager.merge((Object)detachedInstance);
            log.debug((Object)"merge successful");
            return result;
        }
        catch (RuntimeException re) {
            log.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public LicenseType findById(long id) {
        log.debug((Object)("getting LicenseType instance with id: " + id));
        try {
            LicenseType instance = (LicenseType)this.entityManager.find(LicenseType.class, (Object)id);
            log.debug((Object)"get successful");
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List<LicenseType> getAllLicenseTypes() {
        try {
            Query query = this.entityManager.createQuery("SELECT type from LicenseType type");
            log.debug((Object)"get successful");
            return query.getResultList();
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    private void isExists(LicenseType transientInstance) throws ContractManagerValidationException {
        LicenseType existing = this.findByName(transientInstance.getType());
        if (existing != null && (transientInstance.getIdType() == null || existing.getIdType().longValue() != transientInstance.getIdType().longValue())) {
            ArrayList<String> validationErrors = new ArrayList<String>();
            validationErrors.add("License Type already exists!");
            throw new ContractManagerValidationException(validationErrors);
        }
    }

    public LicenseType findByName(String type) {
        try {
            Query query = this.entityManager.createQuery("SELECT type from LicenseType type WHERE type.type = :type");
            query.setParameter("type", (Object)type);
            log.debug((Object)"get successful");
            try {
                return (LicenseType)query.getSingleResult();
            }
            catch (NoResultException e) {
                return null;
            }
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }
}

