/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.mail;

import java.util.Set;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MailUtil {
    private static final Log log = LogFactory.getLog(MailUtil.class);
    private static String MAIL_SERVICE = "java:/Mail";

    public static void sendMail(String subject, String body, Set<String> to) {
        boolean haveMailToDeliver;
        boolean bl = haveMailToDeliver = to != null && to.size() > 0 && subject != null && body != null;
        if (!haveMailToDeliver) {
            log.warn((Object)"No email to send. Recipients/Subject/Body missing...");
            return;
        }
        try {
            Session session = MailUtil.getMailSession(new InitialContext());
            MimeMessage message = new MimeMessage(session);
            message.setFrom();
            InternetAddress[] sendTo = new InternetAddress[to.size()];
            int ctr = 0;
            for (String recipient : to) {
                sendTo[ctr++] = new InternetAddress(recipient);
            }
            message.setRecipients(Message.RecipientType.TO, (Address[])sendTo);
            message.setSubject(subject);
            message.setContent((Object)body, "text/plain");
            Transport.send((Message)message);
            log.debug((Object)("Your message to " + to + " was successfully sent."));
        }
        catch (Exception e) {
            log.error((Object)"Unable to send message: ", (Throwable)e);
        }
    }

    private static Session getMailSession(InitialContext context) throws NamingException {
        return (Session)context.lookup(MAIL_SERVICE);
    }
}

